# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the amplifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__target_gain','__min_gain','__max_gain','__target_gain_tilt','__gain_range','__amp_mode','__target_output_power','__max_output_power','__enabled','__fiber_type_profile',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    self.__target_gain = YANGDynClass(base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    self.__min_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    self.__max_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    self.__target_gain_tilt = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    self.__gain_range = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    self.__amp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    self.__target_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    self.__max_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=True)
    self.__fiber_type_profile = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/name (string)

    YANG Description: User-defined name assigned to identify a specific amplifier
in the device
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User-defined name assigned to identify a specific amplifier
in the device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/type (identityref)

    YANG Description: Type of the amplifier
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of the amplifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)


  def _get_target_gain(self):
    """
    Getter method for target_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/target_gain (decimal64)

    YANG Description: Positive gain applied by the amplifier. This is used
when the amp-mode is in CONSTANT_GAIN or DYNAMIC_GAIN
mode to set the target gain that the amplifier should
achieve.
    """
    return self.__target_gain
      
  def _set_target_gain(self, v, load=False):
    """
    Setter method for target_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/target_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_gain() directly.

    YANG Description: Positive gain applied by the amplifier. This is used
when the amp-mode is in CONSTANT_GAIN or DYNAMIC_GAIN
mode to set the target gain that the amplifier should
achieve.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)""",
        })

    self.__target_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_gain(self):
    self.__target_gain = YANGDynClass(base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)


  def _get_min_gain(self):
    """
    Getter method for min_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/min_gain (decimal64)

    YANG Description: The minimum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from dropping below a desired threshold.
If left empty, the platform will apply a minimum gain based
on hardware specifications.
    """
    return self.__min_gain
      
  def _set_min_gain(self, v, load=False):
    """
    Setter method for min_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/min_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_gain() directly.

    YANG Description: The minimum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from dropping below a desired threshold.
If left empty, the platform will apply a minimum gain based
on hardware specifications.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)""",
        })

    self.__min_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_gain(self):
    self.__min_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)


  def _get_max_gain(self):
    """
    Getter method for max_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/max_gain (decimal64)

    YANG Description: The maximum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from exceeding a desired threshold. If
left empty, the platform will apply a maximum gain based on
hardware specifications.
    """
    return self.__max_gain
      
  def _set_max_gain(self, v, load=False):
    """
    Setter method for max_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/max_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_gain() directly.

    YANG Description: The maximum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from exceeding a desired threshold. If
left empty, the platform will apply a maximum gain based on
hardware specifications.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)""",
        })

    self.__max_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_gain(self):
    self.__max_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)


  def _get_target_gain_tilt(self):
    """
    Getter method for target_gain_tilt, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/target_gain_tilt (decimal64)

    YANG Description: Gain tilt control
    """
    return self.__target_gain_tilt
      
  def _set_target_gain_tilt(self, v, load=False):
    """
    Setter method for target_gain_tilt, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/target_gain_tilt (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_gain_tilt is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_gain_tilt() directly.

    YANG Description: Gain tilt control
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_gain_tilt must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)""",
        })

    self.__target_gain_tilt = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_gain_tilt(self):
    self.__target_gain_tilt = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)


  def _get_gain_range(self):
    """
    Getter method for gain_range, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/gain_range (identityref)

    YANG Description: Selected gain range.  The gain range is a platform-defined
value indicating the switched gain amplifier setting
    """
    return self.__gain_range
      
  def _set_gain_range(self, v, load=False):
    """
    Setter method for gain_range, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/gain_range (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_gain_range is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_gain_range() directly.

    YANG Description: Selected gain range.  The gain range is a platform-defined
value indicating the switched gain amplifier setting
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """gain_range must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)""",
        })

    self.__gain_range = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_gain_range(self):
    self.__gain_range = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)


  def _get_amp_mode(self):
    """
    Getter method for amp_mode, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/amp_mode (identityref)

    YANG Description: The operating mode of the amplifier
    """
    return self.__amp_mode
      
  def _set_amp_mode(self, v, load=False):
    """
    Setter method for amp_mode, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/amp_mode (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_amp_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_amp_mode() directly.

    YANG Description: The operating mode of the amplifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """amp_mode must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)""",
        })

    self.__amp_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_amp_mode(self):
    self.__amp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)


  def _get_target_output_power(self):
    """
    Getter method for target_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/target_output_power (decimal64)

    YANG Description: Output optical power of the amplifier.
    """
    return self.__target_output_power
      
  def _set_target_output_power(self, v, load=False):
    """
    Setter method for target_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/target_output_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_output_power() directly.

    YANG Description: Output optical power of the amplifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_output_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)""",
        })

    self.__target_output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_output_power(self):
    self.__target_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)


  def _get_max_output_power(self):
    """
    Getter method for max_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/max_output_power (decimal64)

    YANG Description: The maximum optical output power of the amplifier. This
may be used to prevent the output power from exceeding a
desired threshold.
    """
    return self.__max_output_power
      
  def _set_max_output_power(self, v, load=False):
    """
    Setter method for max_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/max_output_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_output_power() directly.

    YANG Description: The maximum optical output power of the amplifier. This
may be used to prevent the output power from exceeding a
desired threshold.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_output_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)""",
        })

    self.__max_output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_output_power(self):
    self.__max_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/enabled (boolean)

    YANG Description: Turns power on / off to the amplifiers gain module.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Turns power on / off to the amplifiers gain module.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=True)


  def _get_fiber_type_profile(self):
    """
    Getter method for fiber_type_profile, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/fiber_type_profile (identityref)

    YANG Description: The fiber type profile specifies details about the
fiber type which are needed to accurately determine
the gain and perform efficient amplification. This is
only needed for Raman type amplifiers.
    """
    return self.__fiber_type_profile
      
  def _set_fiber_type_profile(self, v, load=False):
    """
    Setter method for fiber_type_profile, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config/fiber_type_profile (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fiber_type_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fiber_type_profile() directly.

    YANG Description: The fiber type profile specifies details about the
fiber type which are needed to accurately determine
the gain and perform efficient amplification. This is
only needed for Raman type amplifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fiber_type_profile must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)""",
        })

    self.__fiber_type_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fiber_type_profile(self):
    self.__fiber_type_profile = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  target_gain = __builtin__.property(_get_target_gain, _set_target_gain)
  min_gain = __builtin__.property(_get_min_gain, _set_min_gain)
  max_gain = __builtin__.property(_get_max_gain, _set_max_gain)
  target_gain_tilt = __builtin__.property(_get_target_gain_tilt, _set_target_gain_tilt)
  gain_range = __builtin__.property(_get_gain_range, _set_gain_range)
  amp_mode = __builtin__.property(_get_amp_mode, _set_amp_mode)
  target_output_power = __builtin__.property(_get_target_output_power, _set_target_output_power)
  max_output_power = __builtin__.property(_get_max_output_power, _set_max_output_power)
  enabled = __builtin__.property(_get_enabled, _set_enabled)
  fiber_type_profile = __builtin__.property(_get_fiber_type_profile, _set_fiber_type_profile)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('target_gain', target_gain), ('min_gain', min_gain), ('max_gain', max_gain), ('target_gain_tilt', target_gain_tilt), ('gain_range', gain_range), ('amp_mode', amp_mode), ('target_output_power', target_output_power), ('max_output_power', max_output_power), ('enabled', enabled), ('fiber_type_profile', fiber_type_profile), ])


class yc_actual_gain_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/actual-gain. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The actual gain applied by the amplifier in units of
0.01dB. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'actual-gain'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'actual-gain']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/min (decimal64)

    YANG Description: The minimum value of the statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_actual_gain_tilt_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain_tilt(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/actual-gain-tilt. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The actual tilt applied by the amplifier in units of
0.01dB. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'actual-gain-tilt'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'actual-gain-tilt']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/min (decimal64)

    YANG Description: The minimum value of the statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_input_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_total(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/input-power-total. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The total input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'input-power-total'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'input-power-total']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_input_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_c_band(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/input-power-c-band. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The C band (consisting of approximately 191 to 195 THz or
1530nm to 1565 nm) input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'input-power-c-band'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'input-power-c-band']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_input_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_l_band(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/input-power-l-band. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The L band (consisting of approximately 184 to 191 THz or
1565 to 1625 nm) input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'input-power-l-band'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'input-power-l-band']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_output_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_total(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/output-power-total. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The total output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'output-power-total'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'output-power-total']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_output_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_c_band(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/output-power-c-band. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The C band (consisting of approximately 191 to 195 THz or
1530nm to 1565 nm)output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'output-power-c-band'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'output-power-c-band']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_output_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_l_band(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/output-power-l-band. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The L band (consisting of approximately 184 to 191 THz or
1565 to 1625 nm)output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'output-power-l-band'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'output-power-l-band']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_laser_bias_current(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/laser-bias-current. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The current applied by the system to the transmit laser to
achieve the output power. The current is expressed in mA
with up to two decimal precision. If avg/min/max statistics
are not supported, just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'laser-bias-current'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'laser-bias-current']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_optical_return_loss_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_optical_return_loss(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state/optical-return-loss. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical return loss (ORL) is the ratio of the light
reflected back into the port to the light launched out of
the port. ORL is in units of 0.01dBm. If avg/min/max
statistics are not supported, just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-return-loss'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state', 'optical-return-loss']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the amplifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__target_gain','__min_gain','__max_gain','__target_gain_tilt','__gain_range','__amp_mode','__target_output_power','__max_output_power','__enabled','__fiber_type_profile','__component','__ingress_port','__egress_port','__actual_gain','__actual_gain_tilt','__input_power_total','__input_power_c_band','__input_power_l_band','__output_power_total','__output_power_c_band','__output_power_l_band','__laser_bias_current','__optical_return_loss',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    self.__target_gain = YANGDynClass(base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__target_gain_tilt = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__gain_range = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    self.__amp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    self.__target_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=False)
    self.__fiber_type_profile = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    self.__component = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)
    self.__ingress_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ingress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)
    self.__egress_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="egress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)
    self.__actual_gain = YANGDynClass(base=yc_actual_gain_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain, is_container='container', yang_name="actual-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__actual_gain_tilt = YANGDynClass(base=yc_actual_gain_tilt_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain_tilt, is_container='container', yang_name="actual-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__input_power_total = YANGDynClass(base=yc_input_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_total, is_container='container', yang_name="input-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__input_power_c_band = YANGDynClass(base=yc_input_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_c_band, is_container='container', yang_name="input-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__input_power_l_band = YANGDynClass(base=yc_input_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_l_band, is_container='container', yang_name="input-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__output_power_total = YANGDynClass(base=yc_output_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_total, is_container='container', yang_name="output-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__output_power_c_band = YANGDynClass(base=yc_output_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_c_band, is_container='container', yang_name="output-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__output_power_l_band = YANGDynClass(base=yc_output_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_l_band, is_container='container', yang_name="output-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__laser_bias_current = YANGDynClass(base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__optical_return_loss = YANGDynClass(base=yc_optical_return_loss_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_optical_return_loss, is_container='container', yang_name="optical-return-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/name (string)

    YANG Description: User-defined name assigned to identify a specific amplifier
in the device
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User-defined name assigned to identify a specific amplifier
in the device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/type (identityref)

    YANG Description: Type of the amplifier
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of the amplifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:EDFA': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FORWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:BACKWARD_RAMAN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HYBRID': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)


  def _get_target_gain(self):
    """
    Getter method for target_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/target_gain (decimal64)

    YANG Description: Positive gain applied by the amplifier. This is used
when the amp-mode is in CONSTANT_GAIN or DYNAMIC_GAIN
mode to set the target gain that the amplifier should
achieve.
    """
    return self.__target_gain
      
  def _set_target_gain(self, v, load=False):
    """
    Setter method for target_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/target_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_gain() directly.

    YANG Description: Positive gain applied by the amplifier. This is used
when the amp-mode is in CONSTANT_GAIN or DYNAMIC_GAIN
mode to set the target gain that the amplifier should
achieve.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__target_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_gain(self):
    self.__target_gain = YANGDynClass(base=RestrictedClassType(base_type=Decimal, restriction_dict={'range': ['0..max']}), is_leaf=True, yang_name="target-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_gain(self):
    """
    Getter method for min_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/min_gain (decimal64)

    YANG Description: The minimum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from dropping below a desired threshold.
If left empty, the platform will apply a minimum gain based
on hardware specifications.
    """
    return self.__min_gain
      
  def _set_min_gain(self, v, load=False):
    """
    Setter method for min_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/min_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_gain() directly.

    YANG Description: The minimum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from dropping below a desired threshold.
If left empty, the platform will apply a minimum gain based
on hardware specifications.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_gain(self):
    self.__min_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_gain(self):
    """
    Getter method for max_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/max_gain (decimal64)

    YANG Description: The maximum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from exceeding a desired threshold. If
left empty, the platform will apply a maximum gain based on
hardware specifications.
    """
    return self.__max_gain
      
  def _set_max_gain(self, v, load=False):
    """
    Setter method for max_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/max_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_gain() directly.

    YANG Description: The maximum allowed gain of the amplifier. This is used
when the amp-mode is in CONSTANT_POWER or DYNAMIC_GAIN mode
to prevent the gain from exceeding a desired threshold. If
left empty, the platform will apply a maximum gain based on
hardware specifications.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_gain(self):
    self.__max_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_target_gain_tilt(self):
    """
    Getter method for target_gain_tilt, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/target_gain_tilt (decimal64)

    YANG Description: Gain tilt control
    """
    return self.__target_gain_tilt
      
  def _set_target_gain_tilt(self, v, load=False):
    """
    Setter method for target_gain_tilt, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/target_gain_tilt (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_gain_tilt is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_gain_tilt() directly.

    YANG Description: Gain tilt control
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_gain_tilt must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__target_gain_tilt = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_gain_tilt(self):
    self.__target_gain_tilt = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_gain_range(self):
    """
    Getter method for gain_range, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/gain_range (identityref)

    YANG Description: Selected gain range.  The gain range is a platform-defined
value indicating the switched gain amplifier setting
    """
    return self.__gain_range
      
  def _set_gain_range(self, v, load=False):
    """
    Setter method for gain_range, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/gain_range (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_gain_range is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_gain_range() directly.

    YANG Description: Selected gain range.  The gain range is a platform-defined
value indicating the switched gain amplifier setting
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """gain_range must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)""",
        })

    self.__gain_range = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_gain_range(self):
    self.__gain_range = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LOW_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:MID_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:HIGH_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:FIXED_GAIN_RANGE': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="gain-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)


  def _get_amp_mode(self):
    """
    Getter method for amp_mode, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/amp_mode (identityref)

    YANG Description: The operating mode of the amplifier
    """
    return self.__amp_mode
      
  def _set_amp_mode(self, v, load=False):
    """
    Setter method for amp_mode, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/amp_mode (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_amp_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_amp_mode() directly.

    YANG Description: The operating mode of the amplifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """amp_mode must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)""",
        })

    self.__amp_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_amp_mode(self):
    self.__amp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_POWER': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:CONSTANT_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DYNAMIC_GAIN': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="amp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)


  def _get_target_output_power(self):
    """
    Getter method for target_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/target_output_power (decimal64)

    YANG Description: Output optical power of the amplifier.
    """
    return self.__target_output_power
      
  def _set_target_output_power(self, v, load=False):
    """
    Setter method for target_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/target_output_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_output_power() directly.

    YANG Description: Output optical power of the amplifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_output_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__target_output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_output_power(self):
    self.__target_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_output_power(self):
    """
    Getter method for max_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/max_output_power (decimal64)

    YANG Description: The maximum optical output power of the amplifier. This
may be used to prevent the output power from exceeding a
desired threshold.
    """
    return self.__max_output_power
      
  def _set_max_output_power(self, v, load=False):
    """
    Setter method for max_output_power, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/max_output_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_output_power() directly.

    YANG Description: The maximum optical output power of the amplifier. This
may be used to prevent the output power from exceeding a
desired threshold.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_output_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_output_power(self):
    self.__max_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/enabled (boolean)

    YANG Description: Turns power on / off to the amplifiers gain module.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Turns power on / off to the amplifiers gain module.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='boolean', is_config=False)


  def _get_fiber_type_profile(self):
    """
    Getter method for fiber_type_profile, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/fiber_type_profile (identityref)

    YANG Description: The fiber type profile specifies details about the
fiber type which are needed to accurately determine
the gain and perform efficient amplification. This is
only needed for Raman type amplifiers.
    """
    return self.__fiber_type_profile
      
  def _set_fiber_type_profile(self, v, load=False):
    """
    Setter method for fiber_type_profile, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/fiber_type_profile (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fiber_type_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fiber_type_profile() directly.

    YANG Description: The fiber type profile specifies details about the
fiber type which are needed to accurately determine
the gain and perform efficient amplification. This is
only needed for Raman type amplifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fiber_type_profile must be of a type compatible with identityref""",
          'defined-type': "openconfig-optical-amplifier:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)""",
        })

    self.__fiber_type_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fiber_type_profile(self):
    self.__fiber_type_profile = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:DSF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:LEAF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:SSMF': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWC': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}, 'oc-opt-amp:TWRS': {'@module': 'openconfig-optical-amplifier', '@namespace': 'http://openconfig.net/yang/optical-amplfier'}},), is_leaf=True, yang_name="fiber-type-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='identityref', is_config=False)


  def _get_component(self):
    """
    Getter method for component, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/component (leafref)

    YANG Description: Reference to the system-supplied physical component that
the amplifier gain block is contained within. Multiple
amplifier gain blocks may be contained within the same
physical component.
    """
    return self.__component
      
  def _set_component(self, v, load=False):
    """
    Setter method for component, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/component (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_component is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_component() directly.

    YANG Description: Reference to the system-supplied physical component that
the amplifier gain block is contained within. Multiple
amplifier gain blocks may be contained within the same
physical component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """component must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)""",
        })

    self.__component = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_component(self):
    self.__component = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)


  def _get_ingress_port(self):
    """
    Getter method for ingress_port, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/ingress_port (leafref)

    YANG Description: Reference to system-supplied name of the amplifier ingress
port. This leaf is only valid for ports of type INGRESS.
    """
    return self.__ingress_port
      
  def _set_ingress_port(self, v, load=False):
    """
    Setter method for ingress_port, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/ingress_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_port() directly.

    YANG Description: Reference to system-supplied name of the amplifier ingress
port. This leaf is only valid for ports of type INGRESS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ingress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ingress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)""",
        })

    self.__ingress_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_port(self):
    self.__ingress_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ingress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)


  def _get_egress_port(self):
    """
    Getter method for egress_port, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/egress_port (leafref)

    YANG Description: Reference to system-supplied name of the amplifier egress
port. This leaf is only valid for ports of type EGRESS.
    """
    return self.__egress_port
      
  def _set_egress_port(self, v, load=False):
    """
    Setter method for egress_port, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/egress_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_port() directly.

    YANG Description: Reference to system-supplied name of the amplifier egress
port. This leaf is only valid for ports of type EGRESS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="egress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="egress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)""",
        })

    self.__egress_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_port(self):
    self.__egress_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="egress-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=False)


  def _get_actual_gain(self):
    """
    Getter method for actual_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain (container)

    YANG Description: The actual gain applied by the amplifier in units of
0.01dB. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__actual_gain
      
  def _set_actual_gain(self, v, load=False):
    """
    Setter method for actual_gain, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_actual_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_actual_gain() directly.

    YANG Description: The actual gain applied by the amplifier in units of
0.01dB. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_actual_gain_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain, is_container='container', yang_name="actual-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """actual_gain must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_actual_gain_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain, is_container='container', yang_name="actual-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__actual_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_actual_gain(self):
    self.__actual_gain = YANGDynClass(base=yc_actual_gain_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain, is_container='container', yang_name="actual-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_actual_gain_tilt(self):
    """
    Getter method for actual_gain_tilt, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt (container)

    YANG Description: The actual tilt applied by the amplifier in units of
0.01dB. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__actual_gain_tilt
      
  def _set_actual_gain_tilt(self, v, load=False):
    """
    Setter method for actual_gain_tilt, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/actual_gain_tilt (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_actual_gain_tilt is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_actual_gain_tilt() directly.

    YANG Description: The actual tilt applied by the amplifier in units of
0.01dB. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_actual_gain_tilt_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain_tilt, is_container='container', yang_name="actual-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """actual_gain_tilt must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_actual_gain_tilt_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain_tilt, is_container='container', yang_name="actual-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__actual_gain_tilt = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_actual_gain_tilt(self):
    self.__actual_gain_tilt = YANGDynClass(base=yc_actual_gain_tilt_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_actual_gain_tilt, is_container='container', yang_name="actual-gain-tilt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_input_power_total(self):
    """
    Getter method for input_power_total, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total (container)

    YANG Description: The total input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__input_power_total
      
  def _set_input_power_total(self, v, load=False):
    """
    Setter method for input_power_total, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_total (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_power_total is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_power_total() directly.

    YANG Description: The total input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_total, is_container='container', yang_name="input-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_power_total must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_total, is_container='container', yang_name="input-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__input_power_total = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_power_total(self):
    self.__input_power_total = YANGDynClass(base=yc_input_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_total, is_container='container', yang_name="input-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_input_power_c_band(self):
    """
    Getter method for input_power_c_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band (container)

    YANG Description: The C band (consisting of approximately 191 to 195 THz or
1530nm to 1565 nm) input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__input_power_c_band
      
  def _set_input_power_c_band(self, v, load=False):
    """
    Setter method for input_power_c_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_c_band (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_power_c_band is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_power_c_band() directly.

    YANG Description: The C band (consisting of approximately 191 to 195 THz or
1530nm to 1565 nm) input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_c_band, is_container='container', yang_name="input-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_power_c_band must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_c_band, is_container='container', yang_name="input-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__input_power_c_band = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_power_c_band(self):
    self.__input_power_c_band = YANGDynClass(base=yc_input_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_c_band, is_container='container', yang_name="input-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_input_power_l_band(self):
    """
    Getter method for input_power_l_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band (container)

    YANG Description: The L band (consisting of approximately 184 to 191 THz or
1565 to 1625 nm) input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__input_power_l_band
      
  def _set_input_power_l_band(self, v, load=False):
    """
    Setter method for input_power_l_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/input_power_l_band (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_power_l_band is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_power_l_band() directly.

    YANG Description: The L band (consisting of approximately 184 to 191 THz or
1565 to 1625 nm) input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_l_band, is_container='container', yang_name="input-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_power_l_band must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_l_band, is_container='container', yang_name="input-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__input_power_l_band = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_power_l_band(self):
    self.__input_power_l_band = YANGDynClass(base=yc_input_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_input_power_l_band, is_container='container', yang_name="input-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_output_power_total(self):
    """
    Getter method for output_power_total, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total (container)

    YANG Description: The total output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__output_power_total
      
  def _set_output_power_total(self, v, load=False):
    """
    Setter method for output_power_total, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_total (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_power_total is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_power_total() directly.

    YANG Description: The total output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_output_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_total, is_container='container', yang_name="output-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_power_total must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_output_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_total, is_container='container', yang_name="output-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__output_power_total = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_power_total(self):
    self.__output_power_total = YANGDynClass(base=yc_output_power_total_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_total, is_container='container', yang_name="output-power-total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_output_power_c_band(self):
    """
    Getter method for output_power_c_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band (container)

    YANG Description: The C band (consisting of approximately 191 to 195 THz or
1530nm to 1565 nm)output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__output_power_c_band
      
  def _set_output_power_c_band(self, v, load=False):
    """
    Setter method for output_power_c_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_c_band (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_power_c_band is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_power_c_band() directly.

    YANG Description: The C band (consisting of approximately 191 to 195 THz or
1530nm to 1565 nm)output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_output_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_c_band, is_container='container', yang_name="output-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_power_c_band must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_output_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_c_band, is_container='container', yang_name="output-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__output_power_c_band = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_power_c_band(self):
    self.__output_power_c_band = YANGDynClass(base=yc_output_power_c_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_c_band, is_container='container', yang_name="output-power-c-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_output_power_l_band(self):
    """
    Getter method for output_power_l_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band (container)

    YANG Description: The L band (consisting of approximately 184 to 191 THz or
1565 to 1625 nm)output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    return self.__output_power_l_band
      
  def _set_output_power_l_band(self, v, load=False):
    """
    Setter method for output_power_l_band, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/output_power_l_band (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_power_l_band is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_power_l_band() directly.

    YANG Description: The L band (consisting of approximately 184 to 191 THz or
1565 to 1625 nm)output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_output_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_l_band, is_container='container', yang_name="output-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_power_l_band must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_output_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_l_band, is_container='container', yang_name="output-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__output_power_l_band = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_power_l_band(self):
    self.__output_power_l_band = YANGDynClass(base=yc_output_power_l_band_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_output_power_l_band, is_container='container', yang_name="output-power-l-band", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_laser_bias_current(self):
    """
    Getter method for laser_bias_current, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current (container)

    YANG Description: The current applied by the system to the transmit laser to
achieve the output power. The current is expressed in mA
with up to two decimal precision. If avg/min/max statistics
are not supported, just supply the instant value
    """
    return self.__laser_bias_current
      
  def _set_laser_bias_current(self, v, load=False):
    """
    Setter method for laser_bias_current, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/laser_bias_current (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_laser_bias_current is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_laser_bias_current() directly.

    YANG Description: The current applied by the system to the transmit laser to
achieve the output power. The current is expressed in mA
with up to two decimal precision. If avg/min/max statistics
are not supported, just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """laser_bias_current must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__laser_bias_current = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_laser_bias_current(self):
    self.__laser_bias_current = YANGDynClass(base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_optical_return_loss(self):
    """
    Getter method for optical_return_loss, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss (container)

    YANG Description: The optical return loss (ORL) is the ratio of the light
reflected back into the port to the light launched out of
the port. ORL is in units of 0.01dBm. If avg/min/max
statistics are not supported, just supply the instant value
    """
    return self.__optical_return_loss
      
  def _set_optical_return_loss(self, v, load=False):
    """
    Setter method for optical_return_loss, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state/optical_return_loss (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_return_loss is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_return_loss() directly.

    YANG Description: The optical return loss (ORL) is the ratio of the light
reflected back into the port to the light launched out of
the port. ORL is in units of 0.01dBm. If avg/min/max
statistics are not supported, just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_return_loss_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_optical_return_loss, is_container='container', yang_name="optical-return-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_return_loss must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_return_loss_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_optical_return_loss, is_container='container', yang_name="optical-return-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__optical_return_loss = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_return_loss(self):
    self.__optical_return_loss = YANGDynClass(base=yc_optical_return_loss_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state_optical_return_loss, is_container='container', yang_name="optical-return-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  target_gain = __builtin__.property(_get_target_gain)
  min_gain = __builtin__.property(_get_min_gain)
  max_gain = __builtin__.property(_get_max_gain)
  target_gain_tilt = __builtin__.property(_get_target_gain_tilt)
  gain_range = __builtin__.property(_get_gain_range)
  amp_mode = __builtin__.property(_get_amp_mode)
  target_output_power = __builtin__.property(_get_target_output_power)
  max_output_power = __builtin__.property(_get_max_output_power)
  enabled = __builtin__.property(_get_enabled)
  fiber_type_profile = __builtin__.property(_get_fiber_type_profile)
  component = __builtin__.property(_get_component)
  ingress_port = __builtin__.property(_get_ingress_port)
  egress_port = __builtin__.property(_get_egress_port)
  actual_gain = __builtin__.property(_get_actual_gain)
  actual_gain_tilt = __builtin__.property(_get_actual_gain_tilt)
  input_power_total = __builtin__.property(_get_input_power_total)
  input_power_c_band = __builtin__.property(_get_input_power_c_band)
  input_power_l_band = __builtin__.property(_get_input_power_l_band)
  output_power_total = __builtin__.property(_get_output_power_total)
  output_power_c_band = __builtin__.property(_get_output_power_c_band)
  output_power_l_band = __builtin__.property(_get_output_power_l_band)
  laser_bias_current = __builtin__.property(_get_laser_bias_current)
  optical_return_loss = __builtin__.property(_get_optical_return_loss)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('target_gain', target_gain), ('min_gain', min_gain), ('max_gain', max_gain), ('target_gain_tilt', target_gain_tilt), ('gain_range', gain_range), ('amp_mode', amp_mode), ('target_output_power', target_output_power), ('max_output_power', max_output_power), ('enabled', enabled), ('fiber_type_profile', fiber_type_profile), ('component', component), ('ingress_port', ingress_port), ('egress_port', egress_port), ('actual_gain', actual_gain), ('actual_gain_tilt', actual_gain_tilt), ('input_power_total', input_power_total), ('input_power_c_band', input_power_c_band), ('input_power_l_band', input_power_l_band), ('output_power_total', output_power_total), ('output_power_c_band', output_power_c_band), ('output_power_l_band', output_power_l_band), ('laser_bias_current', laser_bias_current), ('optical_return_loss', optical_return_loss), ])


class yc_amplifier_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers/amplifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of optical amplifiers present in the device
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'amplifier'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers', 'amplifier']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/name (leafref)

    YANG Description: Reference to the name of the amplifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the amplifier
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config (container)

    YANG Description: Configuration data for the amplifier
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the amplifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state (container)

    YANG Description: Operational state data for the amplifier
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /optical_amplifier/amplifiers/amplifier/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the amplifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_amplifiers_openconfig_optical_amplifier__optical_amplifier_amplifiers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/amplifiers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of amplifiers
  """
  __slots__ = ('_path_helper', '_extmethods', '__amplifier',)

  _yang_name = 'amplifiers'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__amplifier = YANGDynClass(base=YANGListType("name",yc_amplifier_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier, yang_name="amplifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'amplifiers']

  def _get_amplifier(self):
    """
    Getter method for amplifier, mapped from YANG variable /optical_amplifier/amplifiers/amplifier (list)

    YANG Description: List of optical amplifiers present in the device
    """
    return self.__amplifier
      
  def _set_amplifier(self, v, load=False):
    """
    Setter method for amplifier, mapped from YANG variable /optical_amplifier/amplifiers/amplifier (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_amplifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_amplifier() directly.

    YANG Description: List of optical amplifiers present in the device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_amplifier_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier, yang_name="amplifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """amplifier must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_amplifier_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier, yang_name="amplifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)""",
        })

    self.__amplifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_amplifier(self):
    self.__amplifier = YANGDynClass(base=YANGListType("name",yc_amplifier_openconfig_optical_amplifier__optical_amplifier_amplifiers_amplifier, yang_name="amplifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)

  amplifier = __builtin__.property(_get_amplifier, _set_amplifier)


  _pyangbind_elements = OrderedDict([('amplifier', amplifier), ])


class yc_config_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels/supervisory-channel/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for OSCs
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels', 'supervisory-channel', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/config/interface (oc-if:base-interface-ref)

    YANG Description: Reference to an OSC interface
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/config/interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to an OSC interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_input_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_input_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels/supervisory-channel/state/input-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
the target is expected to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'input-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels', 'supervisory-channel', 'state', 'input-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_output_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_output_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels/supervisory-channel/state/output-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
the target is expected to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'output-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels', 'supervisory-channel', 'state', 'output-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_laser_bias_current(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels/supervisory-channel/state/laser-bias-current. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The current applied by the system to the transmit laser to
achieve the output power. The current is expressed in mA
with up to one decimal precision. If avg/min/max statistics
are not supported, the target is expected to just supply
the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'laser-bias-current'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels', 'supervisory-channel', 'state', 'laser-bias-current']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels/supervisory-channel/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for OSCs
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__input_power','__output_power','__laser_bias_current','__output_frequency',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__input_power = YANGDynClass(base=yc_input_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_input_power, is_container='container', yang_name="input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__output_power = YANGDynClass(base=yc_output_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_output_power, is_container='container', yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__laser_bias_current = YANGDynClass(base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    self.__output_frequency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="output-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-opt-types:frequency-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels', 'supervisory-channel', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/interface (oc-if:base-interface-ref)

    YANG Description: Reference to an OSC interface
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to an OSC interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_input_power(self):
    """
    Getter method for input_power, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power (container)

    YANG Description: The input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
the target is expected to just supply the instant value
    """
    return self.__input_power
      
  def _set_input_power(self, v, load=False):
    """
    Setter method for input_power, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/input_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_power() directly.

    YANG Description: The input optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
the target is expected to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_input_power, is_container='container', yang_name="input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_input_power, is_container='container', yang_name="input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__input_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_power(self):
    self.__input_power = YANGDynClass(base=yc_input_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_input_power, is_container='container', yang_name="input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_output_power(self):
    """
    Getter method for output_power, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power (container)

    YANG Description: The output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
the target is expected to just supply the instant value
    """
    return self.__output_power
      
  def _set_output_power(self, v, load=False):
    """
    Setter method for output_power, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_power() directly.

    YANG Description: The output optical power of this port in units
of 0.01dBm. If avg/min/max statistics are not supported,
the target is expected to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_output_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_output_power, is_container='container', yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_output_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_output_power, is_container='container', yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_power(self):
    self.__output_power = YANGDynClass(base=yc_output_power_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_output_power, is_container='container', yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_laser_bias_current(self):
    """
    Getter method for laser_bias_current, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current (container)

    YANG Description: The current applied by the system to the transmit laser to
achieve the output power. The current is expressed in mA
with up to one decimal precision. If avg/min/max statistics
are not supported, the target is expected to just supply
the instant value
    """
    return self.__laser_bias_current
      
  def _set_laser_bias_current(self, v, load=False):
    """
    Setter method for laser_bias_current, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/laser_bias_current (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_laser_bias_current is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_laser_bias_current() directly.

    YANG Description: The current applied by the system to the transmit laser to
achieve the output power. The current is expressed in mA
with up to one decimal precision. If avg/min/max statistics
are not supported, the target is expected to just supply
the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """laser_bias_current must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)""",
        })

    self.__laser_bias_current = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_laser_bias_current(self):
    self.__laser_bias_current = YANGDynClass(base=yc_laser_bias_current_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state_laser_bias_current, is_container='container', yang_name="laser-bias-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=False)


  def _get_output_frequency(self):
    """
    Getter method for output_frequency, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_frequency (oc-opt-types:frequency-type)

    YANG Description: The frequency in MHz of the individual physical channel
(e.g. ITU C50 - 195.0THz and would be reported as
195,000,000 MHz in this model). This attribute is not
configurable on most client ports.
    """
    return self.__output_frequency
      
  def _set_output_frequency(self, v, load=False):
    """
    Setter method for output_frequency, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state/output_frequency (oc-opt-types:frequency-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_frequency() directly.

    YANG Description: The frequency in MHz of the individual physical channel
(e.g. ITU C50 - 195.0THz and would be reported as
195,000,000 MHz in this model). This attribute is not
configurable on most client ports.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="output-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-opt-types:frequency-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_frequency must be of a type compatible with oc-opt-types:frequency-type""",
          'defined-type': "oc-opt-types:frequency-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="output-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-opt-types:frequency-type', is_config=False)""",
        })

    self.__output_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_frequency(self):
    self.__output_frequency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="output-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='oc-opt-types:frequency-type', is_config=False)

  interface = __builtin__.property(_get_interface)
  input_power = __builtin__.property(_get_input_power)
  output_power = __builtin__.property(_get_output_power)
  laser_bias_current = __builtin__.property(_get_laser_bias_current)
  output_frequency = __builtin__.property(_get_output_frequency)


  _pyangbind_elements = OrderedDict([('interface', interface), ('input_power', input_power), ('output_power', output_power), ('laser_bias_current', laser_bias_current), ('output_frequency', output_frequency), ])


class yc_supervisory_channel_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels/supervisory-channel. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of supervisory channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__config','__state',)

  _yang_name = 'supervisory-channel'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels', 'supervisory-channel']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/interface (leafref)

    YANG Description: Reference to the interface of the supervisory channel
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to the interface of the supervisory channel
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/config (container)

    YANG Description: Configuration data for OSCs
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for OSCs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state (container)

    YANG Description: Operational state data for OSCs
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for OSCs
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('interface', interface), ('config', config), ('state', state), ])


class yc_supervisory_channels_openconfig_optical_amplifier__optical_amplifier_supervisory_channels(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier/supervisory-channels. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of supervisory channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__supervisory_channel',)

  _yang_name = 'supervisory-channels'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__supervisory_channel = YANGDynClass(base=YANGListType("interface",yc_supervisory_channel_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel, yang_name="supervisory-channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="supervisory-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier', 'supervisory-channels']

  def _get_supervisory_channel(self):
    """
    Getter method for supervisory_channel, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel (list)

    YANG Description: List of supervisory channels
    """
    return self.__supervisory_channel
      
  def _set_supervisory_channel(self, v, load=False):
    """
    Setter method for supervisory_channel, mapped from YANG variable /optical_amplifier/supervisory_channels/supervisory_channel (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supervisory_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supervisory_channel() directly.

    YANG Description: List of supervisory channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("interface",yc_supervisory_channel_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel, yang_name="supervisory-channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="supervisory-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supervisory_channel must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("interface",yc_supervisory_channel_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel, yang_name="supervisory-channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="supervisory-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)""",
        })

    self.__supervisory_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supervisory_channel(self):
    self.__supervisory_channel = YANGDynClass(base=YANGListType("interface",yc_supervisory_channel_openconfig_optical_amplifier__optical_amplifier_supervisory_channels_supervisory_channel, yang_name="supervisory-channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="supervisory-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='list', is_config=True)

  supervisory_channel = __builtin__.property(_get_supervisory_channel, _set_supervisory_channel)


  _pyangbind_elements = OrderedDict([('supervisory_channel', supervisory_channel), ])


class yc_optical_amplifier_openconfig_optical_amplifier__optical_amplifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /optical-amplifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for amplifiers and supervisory channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__amplifiers','__supervisory_channels',)

  _yang_name = 'optical-amplifier'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__amplifiers = YANGDynClass(base=yc_amplifiers_openconfig_optical_amplifier__optical_amplifier_amplifiers, is_container='container', yang_name="amplifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    self.__supervisory_channels = YANGDynClass(base=yc_supervisory_channels_openconfig_optical_amplifier__optical_amplifier_supervisory_channels, is_container='container', yang_name="supervisory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['optical-amplifier']

  def _get_amplifiers(self):
    """
    Getter method for amplifiers, mapped from YANG variable /optical_amplifier/amplifiers (container)

    YANG Description: Enclosing container for list of amplifiers
    """
    return self.__amplifiers
      
  def _set_amplifiers(self, v, load=False):
    """
    Setter method for amplifiers, mapped from YANG variable /optical_amplifier/amplifiers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_amplifiers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_amplifiers() directly.

    YANG Description: Enclosing container for list of amplifiers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_amplifiers_openconfig_optical_amplifier__optical_amplifier_amplifiers, is_container='container', yang_name="amplifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """amplifiers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_amplifiers_openconfig_optical_amplifier__optical_amplifier_amplifiers, is_container='container', yang_name="amplifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__amplifiers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_amplifiers(self):
    self.__amplifiers = YANGDynClass(base=yc_amplifiers_openconfig_optical_amplifier__optical_amplifier_amplifiers, is_container='container', yang_name="amplifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)


  def _get_supervisory_channels(self):
    """
    Getter method for supervisory_channels, mapped from YANG variable /optical_amplifier/supervisory_channels (container)

    YANG Description: Enclosing container for list of supervisory channels
    """
    return self.__supervisory_channels
      
  def _set_supervisory_channels(self, v, load=False):
    """
    Setter method for supervisory_channels, mapped from YANG variable /optical_amplifier/supervisory_channels (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supervisory_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supervisory_channels() directly.

    YANG Description: Enclosing container for list of supervisory channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_supervisory_channels_openconfig_optical_amplifier__optical_amplifier_supervisory_channels, is_container='container', yang_name="supervisory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supervisory_channels must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_supervisory_channels_openconfig_optical_amplifier__optical_amplifier_supervisory_channels, is_container='container', yang_name="supervisory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__supervisory_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supervisory_channels(self):
    self.__supervisory_channels = YANGDynClass(base=yc_supervisory_channels_openconfig_optical_amplifier__optical_amplifier_supervisory_channels, is_container='container', yang_name="supervisory-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

  amplifiers = __builtin__.property(_get_amplifiers, _set_amplifiers)
  supervisory_channels = __builtin__.property(_get_supervisory_channels, _set_supervisory_channels)


  _pyangbind_elements = OrderedDict([('amplifiers', amplifiers), ('supervisory_channels', supervisory_channels), ])


class openconfig_optical_amplifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-optical-amplifier - based on the path /openconfig-optical-amplifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This model describes configuration and operational state data
for optical amplifiers, deployed as part of a transport
line system.
  """
  __slots__ = ('_path_helper', '_extmethods', '__optical_amplifier',)

  _yang_name = 'openconfig-optical-amplifier'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__optical_amplifier = YANGDynClass(base=yc_optical_amplifier_openconfig_optical_amplifier__optical_amplifier, is_container='container', yang_name="optical-amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_optical_amplifier(self):
    """
    Getter method for optical_amplifier, mapped from YANG variable /optical_amplifier (container)

    YANG Description: Enclosing container for amplifiers and supervisory channels
    """
    return self.__optical_amplifier
      
  def _set_optical_amplifier(self, v, load=False):
    """
    Setter method for optical_amplifier, mapped from YANG variable /optical_amplifier (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_amplifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_amplifier() directly.

    YANG Description: Enclosing container for amplifiers and supervisory channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_amplifier_openconfig_optical_amplifier__optical_amplifier, is_container='container', yang_name="optical-amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_amplifier must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_amplifier_openconfig_optical_amplifier__optical_amplifier, is_container='container', yang_name="optical-amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)""",
        })

    self.__optical_amplifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_amplifier(self):
    self.__optical_amplifier = YANGDynClass(base=yc_optical_amplifier_openconfig_optical_amplifier__optical_amplifier, is_container='container', yang_name="optical-amplifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-amplfier', defining_module='openconfig-optical-amplifier', yang_type='container', is_config=True)

  optical_amplifier = __builtin__.property(_get_optical_amplifier, _set_optical_amplifier)


  _pyangbind_elements = OrderedDict([('optical_amplifier', optical_amplifier), ])


class openconfig_transport_line_common(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-common - based on the path /openconfig-transport-line-common. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines common data elements for OpenConfig data
models for optical transport line system elements, such as
amplifiers and ROADMs (wavelength routers).
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for an automatic protection
switch module
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__revertive','__wait_to_restore_time','__hold_off_time','__primary_switch_threshold','__primary_switch_hysteresis','__secondary_switch_threshold','__relative_switch_threshold','__relative_switch_threshold_offset','__force_to_port',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)
    self.__revertive = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    self.__wait_to_restore_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)
    self.__hold_off_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)
    self.__primary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    self.__primary_switch_hysteresis = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    self.__secondary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    self.__relative_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    self.__relative_switch_threshold_offset = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    self.__force_to_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /aps/aps_modules/aps_module/config/name (leafref)

    YANG Description: Reference to the component name (in the platform model)
corresponding to this automatic protection switch module
in the device
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /aps/aps_modules/aps_module/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the component name (in the platform model)
corresponding to this automatic protection switch module
in the device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)


  def _get_revertive(self):
    """
    Getter method for revertive, mapped from YANG variable /aps/aps_modules/aps_module/config/revertive (boolean)

    YANG Description: Revertive behavior of the module. If True, then
automatically revert after protection switch once the
fault is restored. This leaf is not valid when the
relative-switch-threshold is in effect
    """
    return self.__revertive
      
  def _set_revertive(self, v, load=False):
    """
    Setter method for revertive, mapped from YANG variable /aps/aps_modules/aps_module/config/revertive (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revertive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revertive() directly.

    YANG Description: Revertive behavior of the module. If True, then
automatically revert after protection switch once the
fault is restored. This leaf is not valid when the
relative-switch-threshold is in effect
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revertive must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)""",
        })

    self.__revertive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revertive(self):
    self.__revertive = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)


  def _get_wait_to_restore_time(self):
    """
    Getter method for wait_to_restore_time, mapped from YANG variable /aps/aps_modules/aps_module/config/wait_to_restore_time (uint32)

    YANG Description: The time that must elapse before an APS path
that has recovered from an signal failure (SF) or signal
degradation (SD) condition can be used again to transport
the normal traffic signal. During this time period, an SF or
SD condition shall override the wait-to-restore time period.
This leaf can only take effect when the revertive leaf
equals true
    """
    return self.__wait_to_restore_time
      
  def _set_wait_to_restore_time(self, v, load=False):
    """
    Setter method for wait_to_restore_time, mapped from YANG variable /aps/aps_modules/aps_module/config/wait_to_restore_time (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_wait_to_restore_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_wait_to_restore_time() directly.

    YANG Description: The time that must elapse before an APS path
that has recovered from an signal failure (SF) or signal
degradation (SD) condition can be used again to transport
the normal traffic signal. During this time period, an SF or
SD condition shall override the wait-to-restore time period.
This leaf can only take effect when the revertive leaf
equals true
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """wait_to_restore_time must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)""",
        })

    self.__wait_to_restore_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_wait_to_restore_time(self):
    self.__wait_to_restore_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)


  def _get_hold_off_time(self):
    """
    Getter method for hold_off_time, mapped from YANG variable /aps/aps_modules/aps_module/config/hold_off_time (uint32)

    YANG Description: The time delay between the declaration of an SF or SD
condition and the initiation of the protection switching
algorithm
    """
    return self.__hold_off_time
      
  def _set_hold_off_time(self, v, load=False):
    """
    Setter method for hold_off_time, mapped from YANG variable /aps/aps_modules/aps_module/config/hold_off_time (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_off_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_off_time() directly.

    YANG Description: The time delay between the declaration of an SF or SD
condition and the initiation of the protection switching
algorithm
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_off_time must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)""",
        })

    self.__hold_off_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_off_time(self):
    self.__hold_off_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=True)


  def _get_primary_switch_threshold(self):
    """
    Getter method for primary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/config/primary_switch_threshold (decimal64)

    YANG Description: The threshold at which the primary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
primary switch threshold will be overridden
    """
    return self.__primary_switch_threshold
      
  def _set_primary_switch_threshold(self, v, load=False):
    """
    Setter method for primary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/config/primary_switch_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_primary_switch_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_primary_switch_threshold() directly.

    YANG Description: The threshold at which the primary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
primary switch threshold will be overridden
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """primary_switch_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__primary_switch_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_primary_switch_threshold(self):
    self.__primary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)


  def _get_primary_switch_hysteresis(self):
    """
    Getter method for primary_switch_hysteresis, mapped from YANG variable /aps/aps_modules/aps_module/config/primary_switch_hysteresis (decimal64)

    YANG Description: The delta in dB between the primary-switch-threshold
and the signal received on the primary APS_PATH before
initiating a switch from the secondary APS_PATH to the
primary APS_PATH, in order to prevent toggling between ports
when an input signal is very close to the threshold. A zero
value means the switch hysteresis is disabled.
    """
    return self.__primary_switch_hysteresis
      
  def _set_primary_switch_hysteresis(self, v, load=False):
    """
    Setter method for primary_switch_hysteresis, mapped from YANG variable /aps/aps_modules/aps_module/config/primary_switch_hysteresis (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_primary_switch_hysteresis is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_primary_switch_hysteresis() directly.

    YANG Description: The delta in dB between the primary-switch-threshold
and the signal received on the primary APS_PATH before
initiating a switch from the secondary APS_PATH to the
primary APS_PATH, in order to prevent toggling between ports
when an input signal is very close to the threshold. A zero
value means the switch hysteresis is disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """primary_switch_hysteresis must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__primary_switch_hysteresis = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_primary_switch_hysteresis(self):
    self.__primary_switch_hysteresis = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)


  def _get_secondary_switch_threshold(self):
    """
    Getter method for secondary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/config/secondary_switch_threshold (decimal64)

    YANG Description: The threshold at which the secondary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
secondary switch threshold will be overridden
    """
    return self.__secondary_switch_threshold
      
  def _set_secondary_switch_threshold(self, v, load=False):
    """
    Setter method for secondary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/config/secondary_switch_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secondary_switch_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secondary_switch_threshold() directly.

    YANG Description: The threshold at which the secondary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
secondary switch threshold will be overridden
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secondary_switch_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__secondary_switch_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secondary_switch_threshold(self):
    self.__secondary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)


  def _get_relative_switch_threshold(self):
    """
    Getter method for relative_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/config/relative_switch_threshold (decimal64)

    YANG Description: The delta threshold in dB at which the current line port
will switch to the opposite line port. It can be set to
the value of 0dB. When set to 0dB, the threshold is ignored
and the system automatically applies the primary and
secondary switch thresholds. When set to a non-zero value,
it overrides the primary and secondary switch thresholds
    """
    return self.__relative_switch_threshold
      
  def _set_relative_switch_threshold(self, v, load=False):
    """
    Setter method for relative_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/config/relative_switch_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relative_switch_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relative_switch_threshold() directly.

    YANG Description: The delta threshold in dB at which the current line port
will switch to the opposite line port. It can be set to
the value of 0dB. When set to 0dB, the threshold is ignored
and the system automatically applies the primary and
secondary switch thresholds. When set to a non-zero value,
it overrides the primary and secondary switch thresholds
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relative_switch_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__relative_switch_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relative_switch_threshold(self):
    self.__relative_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)


  def _get_relative_switch_threshold_offset(self):
    """
    Getter method for relative_switch_threshold_offset, mapped from YANG variable /aps/aps_modules/aps_module/config/relative_switch_threshold_offset (decimal64)

    YANG Description: The offset of the relative switch threshold that compensates
the normal difference of receiving power between the primary
and secondary line ports. A negative offset corresponds to
the situation where the secondary line port receives a higher
power than the primary line port in normal condition， and a
positive offset means the opposite. The offset will only work
when the relative switch threshold is set to a non-zero
value
    """
    return self.__relative_switch_threshold_offset
      
  def _set_relative_switch_threshold_offset(self, v, load=False):
    """
    Setter method for relative_switch_threshold_offset, mapped from YANG variable /aps/aps_modules/aps_module/config/relative_switch_threshold_offset (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relative_switch_threshold_offset is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relative_switch_threshold_offset() directly.

    YANG Description: The offset of the relative switch threshold that compensates
the normal difference of receiving power between the primary
and secondary line ports. A negative offset corresponds to
the situation where the secondary line port receives a higher
power than the primary line port in normal condition， and a
positive offset means the opposite. The offset will only work
when the relative switch threshold is set to a non-zero
value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relative_switch_threshold_offset must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__relative_switch_threshold_offset = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relative_switch_threshold_offset(self):
    self.__relative_switch_threshold_offset = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)


  def _get_force_to_port(self):
    """
    Getter method for force_to_port, mapped from YANG variable /aps/aps_modules/aps_module/config/force_to_port (enumeration)

    YANG Description: Explicitly set the switch to stay on a port regardless of
its operational condition
    """
    return self.__force_to_port
      
  def _set_force_to_port(self, v, load=False):
    """
    Setter method for force_to_port, mapped from YANG variable /aps/aps_modules/aps_module/config/force_to_port (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_force_to_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_force_to_port() directly.

    YANG Description: Explicitly set the switch to stay on a port regardless of
its operational condition
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """force_to_port must be of a type compatible with enumeration""",
          'defined-type': "openconfig-transport-line-protection:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=True)""",
        })

    self.__force_to_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_force_to_port(self):
    self.__force_to_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  revertive = __builtin__.property(_get_revertive, _set_revertive)
  wait_to_restore_time = __builtin__.property(_get_wait_to_restore_time, _set_wait_to_restore_time)
  hold_off_time = __builtin__.property(_get_hold_off_time, _set_hold_off_time)
  primary_switch_threshold = __builtin__.property(_get_primary_switch_threshold, _set_primary_switch_threshold)
  primary_switch_hysteresis = __builtin__.property(_get_primary_switch_hysteresis, _set_primary_switch_hysteresis)
  secondary_switch_threshold = __builtin__.property(_get_secondary_switch_threshold, _set_secondary_switch_threshold)
  relative_switch_threshold = __builtin__.property(_get_relative_switch_threshold, _set_relative_switch_threshold)
  relative_switch_threshold_offset = __builtin__.property(_get_relative_switch_threshold_offset, _set_relative_switch_threshold_offset)
  force_to_port = __builtin__.property(_get_force_to_port, _set_force_to_port)


  _pyangbind_elements = OrderedDict([('name', name), ('revertive', revertive), ('wait_to_restore_time', wait_to_restore_time), ('hold_off_time', hold_off_time), ('primary_switch_threshold', primary_switch_threshold), ('primary_switch_hysteresis', primary_switch_hysteresis), ('secondary_switch_threshold', secondary_switch_threshold), ('relative_switch_threshold', relative_switch_threshold), ('relative_switch_threshold_offset', relative_switch_threshold_offset), ('force_to_port', force_to_port), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for an automatic protection
switch module
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__revertive','__wait_to_restore_time','__hold_off_time','__primary_switch_threshold','__primary_switch_hysteresis','__secondary_switch_threshold','__relative_switch_threshold','__relative_switch_threshold_offset','__force_to_port','__active_path',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=False)
    self.__revertive = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    self.__wait_to_restore_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)
    self.__hold_off_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)
    self.__primary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__primary_switch_hysteresis = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__secondary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__relative_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__relative_switch_threshold_offset = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__force_to_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=False)
    self.__active_path = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}},), is_leaf=True, yang_name="active-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /aps/aps_modules/aps_module/state/name (leafref)

    YANG Description: Reference to the component name (in the platform model)
corresponding to this automatic protection switch module
in the device
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /aps/aps_modules/aps_module/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the component name (in the platform model)
corresponding to this automatic protection switch module
in the device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=False)


  def _get_revertive(self):
    """
    Getter method for revertive, mapped from YANG variable /aps/aps_modules/aps_module/state/revertive (boolean)

    YANG Description: Revertive behavior of the module. If True, then
automatically revert after protection switch once the
fault is restored. This leaf is not valid when the
relative-switch-threshold is in effect
    """
    return self.__revertive
      
  def _set_revertive(self, v, load=False):
    """
    Setter method for revertive, mapped from YANG variable /aps/aps_modules/aps_module/state/revertive (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revertive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revertive() directly.

    YANG Description: Revertive behavior of the module. If True, then
automatically revert after protection switch once the
fault is restored. This leaf is not valid when the
relative-switch-threshold is in effect
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revertive must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)""",
        })

    self.__revertive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revertive(self):
    self.__revertive = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)


  def _get_wait_to_restore_time(self):
    """
    Getter method for wait_to_restore_time, mapped from YANG variable /aps/aps_modules/aps_module/state/wait_to_restore_time (uint32)

    YANG Description: The time that must elapse before an APS path
that has recovered from an signal failure (SF) or signal
degradation (SD) condition can be used again to transport
the normal traffic signal. During this time period, an SF or
SD condition shall override the wait-to-restore time period.
This leaf can only take effect when the revertive leaf
equals true
    """
    return self.__wait_to_restore_time
      
  def _set_wait_to_restore_time(self, v, load=False):
    """
    Setter method for wait_to_restore_time, mapped from YANG variable /aps/aps_modules/aps_module/state/wait_to_restore_time (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_wait_to_restore_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_wait_to_restore_time() directly.

    YANG Description: The time that must elapse before an APS path
that has recovered from an signal failure (SF) or signal
degradation (SD) condition can be used again to transport
the normal traffic signal. During this time period, an SF or
SD condition shall override the wait-to-restore time period.
This leaf can only take effect when the revertive leaf
equals true
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """wait_to_restore_time must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)""",
        })

    self.__wait_to_restore_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_wait_to_restore_time(self):
    self.__wait_to_restore_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="wait-to-restore-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)


  def _get_hold_off_time(self):
    """
    Getter method for hold_off_time, mapped from YANG variable /aps/aps_modules/aps_module/state/hold_off_time (uint32)

    YANG Description: The time delay between the declaration of an SF or SD
condition and the initiation of the protection switching
algorithm
    """
    return self.__hold_off_time
      
  def _set_hold_off_time(self, v, load=False):
    """
    Setter method for hold_off_time, mapped from YANG variable /aps/aps_modules/aps_module/state/hold_off_time (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_off_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_off_time() directly.

    YANG Description: The time delay between the declaration of an SF or SD
condition and the initiation of the protection switching
algorithm
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_off_time must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)""",
        })

    self.__hold_off_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_off_time(self):
    self.__hold_off_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hold-off-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='uint32', is_config=False)


  def _get_primary_switch_threshold(self):
    """
    Getter method for primary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/state/primary_switch_threshold (decimal64)

    YANG Description: The threshold at which the primary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
primary switch threshold will be overridden
    """
    return self.__primary_switch_threshold
      
  def _set_primary_switch_threshold(self, v, load=False):
    """
    Setter method for primary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/state/primary_switch_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_primary_switch_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_primary_switch_threshold() directly.

    YANG Description: The threshold at which the primary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
primary switch threshold will be overridden
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """primary_switch_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__primary_switch_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_primary_switch_threshold(self):
    self.__primary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="primary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_primary_switch_hysteresis(self):
    """
    Getter method for primary_switch_hysteresis, mapped from YANG variable /aps/aps_modules/aps_module/state/primary_switch_hysteresis (decimal64)

    YANG Description: The delta in dB between the primary-switch-threshold
and the signal received on the primary APS_PATH before
initiating a switch from the secondary APS_PATH to the
primary APS_PATH, in order to prevent toggling between ports
when an input signal is very close to the threshold. A zero
value means the switch hysteresis is disabled.
    """
    return self.__primary_switch_hysteresis
      
  def _set_primary_switch_hysteresis(self, v, load=False):
    """
    Setter method for primary_switch_hysteresis, mapped from YANG variable /aps/aps_modules/aps_module/state/primary_switch_hysteresis (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_primary_switch_hysteresis is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_primary_switch_hysteresis() directly.

    YANG Description: The delta in dB between the primary-switch-threshold
and the signal received on the primary APS_PATH before
initiating a switch from the secondary APS_PATH to the
primary APS_PATH, in order to prevent toggling between ports
when an input signal is very close to the threshold. A zero
value means the switch hysteresis is disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """primary_switch_hysteresis must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__primary_switch_hysteresis = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_primary_switch_hysteresis(self):
    self.__primary_switch_hysteresis = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="primary-switch-hysteresis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_secondary_switch_threshold(self):
    """
    Getter method for secondary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/state/secondary_switch_threshold (decimal64)

    YANG Description: The threshold at which the secondary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
secondary switch threshold will be overridden
    """
    return self.__secondary_switch_threshold
      
  def _set_secondary_switch_threshold(self, v, load=False):
    """
    Setter method for secondary_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/state/secondary_switch_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secondary_switch_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secondary_switch_threshold() directly.

    YANG Description: The threshold at which the secondary line port will switch to
the opposite line port in increments of 0.01 dBm. If the
hardware supports only one switch threshold for primary and
and secondary ports then it is recommended to set both
primary-switch-threshold and secondary-switch-threshold to
the same value to be explicit. When the relative switch
threshold is enabled, i.e. set to a non-zero value, the
secondary switch threshold will be overridden
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secondary_switch_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__secondary_switch_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secondary_switch_threshold(self):
    self.__secondary_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="secondary-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_relative_switch_threshold(self):
    """
    Getter method for relative_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/state/relative_switch_threshold (decimal64)

    YANG Description: The delta threshold in dB at which the current line port
will switch to the opposite line port. It can be set to
the value of 0dB. When set to 0dB, the threshold is ignored
and the system automatically applies the primary and
secondary switch thresholds. When set to a non-zero value,
it overrides the primary and secondary switch thresholds
    """
    return self.__relative_switch_threshold
      
  def _set_relative_switch_threshold(self, v, load=False):
    """
    Setter method for relative_switch_threshold, mapped from YANG variable /aps/aps_modules/aps_module/state/relative_switch_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relative_switch_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relative_switch_threshold() directly.

    YANG Description: The delta threshold in dB at which the current line port
will switch to the opposite line port. It can be set to
the value of 0dB. When set to 0dB, the threshold is ignored
and the system automatically applies the primary and
secondary switch thresholds. When set to a non-zero value,
it overrides the primary and secondary switch thresholds
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relative_switch_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__relative_switch_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relative_switch_threshold(self):
    self.__relative_switch_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_relative_switch_threshold_offset(self):
    """
    Getter method for relative_switch_threshold_offset, mapped from YANG variable /aps/aps_modules/aps_module/state/relative_switch_threshold_offset (decimal64)

    YANG Description: The offset of the relative switch threshold that compensates
the normal difference of receiving power between the primary
and secondary line ports. A negative offset corresponds to
the situation where the secondary line port receives a higher
power than the primary line port in normal condition， and a
positive offset means the opposite. The offset will only work
when the relative switch threshold is set to a non-zero
value
    """
    return self.__relative_switch_threshold_offset
      
  def _set_relative_switch_threshold_offset(self, v, load=False):
    """
    Setter method for relative_switch_threshold_offset, mapped from YANG variable /aps/aps_modules/aps_module/state/relative_switch_threshold_offset (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relative_switch_threshold_offset is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relative_switch_threshold_offset() directly.

    YANG Description: The offset of the relative switch threshold that compensates
the normal difference of receiving power between the primary
and secondary line ports. A negative offset corresponds to
the situation where the secondary line port receives a higher
power than the primary line port in normal condition， and a
positive offset means the opposite. The offset will only work
when the relative switch threshold is set to a non-zero
value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relative_switch_threshold_offset must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__relative_switch_threshold_offset = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relative_switch_threshold_offset(self):
    self.__relative_switch_threshold_offset = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0), is_leaf=True, yang_name="relative-switch-threshold-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_force_to_port(self):
    """
    Getter method for force_to_port, mapped from YANG variable /aps/aps_modules/aps_module/state/force_to_port (enumeration)

    YANG Description: Explicitly set the switch to stay on a port regardless of
its operational condition
    """
    return self.__force_to_port
      
  def _set_force_to_port(self, v, load=False):
    """
    Setter method for force_to_port, mapped from YANG variable /aps/aps_modules/aps_module/state/force_to_port (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_force_to_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_force_to_port() directly.

    YANG Description: Explicitly set the switch to stay on a port regardless of
its operational condition
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """force_to_port must be of a type compatible with enumeration""",
          'defined-type': "openconfig-transport-line-protection:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=False)""",
        })

    self.__force_to_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_force_to_port(self):
    self.__force_to_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'PRIMARY': {}, 'SECONDARY': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="force-to-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='enumeration', is_config=False)


  def _get_active_path(self):
    """
    Getter method for active_path, mapped from YANG variable /aps/aps_modules/aps_module/state/active_path (identityref)

    YANG Description: Indicates which line path on the protection switch is
currently the active path connected to the common port
    """
    return self.__active_path
      
  def _set_active_path(self, v, load=False):
    """
    Setter method for active_path, mapped from YANG variable /aps/aps_modules/aps_module/state/active_path (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_active_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_active_path() directly.

    YANG Description: Indicates which line path on the protection switch is
currently the active path connected to the common port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}},), is_leaf=True, yang_name="active-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """active_path must be of a type compatible with identityref""",
          'defined-type': "openconfig-transport-line-protection:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}},), is_leaf=True, yang_name="active-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='identityref', is_config=False)""",
        })

    self.__active_path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_active_path(self):
    self.__active_path = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:PRIMARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}, 'oc-line-protect:SECONDARY': {'@module': 'openconfig-transport-line-protection', '@namespace': 'http://openconfig.net/yang/optical-transport-line-protection'}},), is_leaf=True, yang_name="active-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='identityref', is_config=False)

  name = __builtin__.property(_get_name)
  revertive = __builtin__.property(_get_revertive)
  wait_to_restore_time = __builtin__.property(_get_wait_to_restore_time)
  hold_off_time = __builtin__.property(_get_hold_off_time)
  primary_switch_threshold = __builtin__.property(_get_primary_switch_threshold)
  primary_switch_hysteresis = __builtin__.property(_get_primary_switch_hysteresis)
  secondary_switch_threshold = __builtin__.property(_get_secondary_switch_threshold)
  relative_switch_threshold = __builtin__.property(_get_relative_switch_threshold)
  relative_switch_threshold_offset = __builtin__.property(_get_relative_switch_threshold_offset)
  force_to_port = __builtin__.property(_get_force_to_port)
  active_path = __builtin__.property(_get_active_path)


  _pyangbind_elements = OrderedDict([('name', name), ('revertive', revertive), ('wait_to_restore_time', wait_to_restore_time), ('hold_off_time', hold_off_time), ('primary_switch_threshold', primary_switch_threshold), ('primary_switch_hysteresis', primary_switch_hysteresis), ('secondary_switch_threshold', secondary_switch_threshold), ('relative_switch_threshold', relative_switch_threshold), ('relative_switch_threshold_offset', relative_switch_threshold_offset), ('force_to_port', force_to_port), ('active_path', active_path), ])


class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-in/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the line primary input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__target_attenuation',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-in', 'config']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)


  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/config/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/config/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)
  target_attenuation = __builtin__.property(_get_target_attenuation, _set_target_attenuation)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('target_attenuation', target_attenuation), ])


class yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state_optical_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-in', 'state', 'optical-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-in/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for the line primary input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__target_attenuation','__attenuation','__optical_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-in', 'state']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)


  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_attenuation(self):
    """
    Getter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/attenuation (decimal64)

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__attenuation
      
  def _set_attenuation(self, v, load=False):
    """
    Setter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_attenuation() directly.

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_attenuation(self):
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_optical_power(self):
    """
    Getter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power (container)

    YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    return self.__optical_power
      
  def _set_optical_power(self, v, load=False):
    """
    Setter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state/optical_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_power() directly.

    YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)""",
        })

    self.__optical_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_power(self):
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

  enabled = __builtin__.property(_get_enabled)
  target_attenuation = __builtin__.property(_get_target_attenuation)
  attenuation = __builtin__.property(_get_attenuation)
  optical_power = __builtin__.property(_get_optical_power)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('target_attenuation', target_attenuation), ('attenuation', attenuation), ('optical_power', optical_power), ])


class yc_line_primary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-in. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for information related to the line primary
input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'line-primary-in'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-in']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/config (container)

    YANG Description: Configuration data for the line primary input port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the line primary input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state (container)

    YANG Description: State data for the line primary input port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for the line primary input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-out/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the line primary output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_attenuation',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-out', 'config']

  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/config/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/config/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

  target_attenuation = __builtin__.property(_get_target_attenuation, _set_target_attenuation)


  _pyangbind_elements = OrderedDict([('target_attenuation', target_attenuation), ])


class yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state_optical_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-out', 'state', 'optical-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-out/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for the line primary output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_attenuation','__attenuation','__optical_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-out', 'state']

  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_attenuation(self):
    """
    Getter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/attenuation (decimal64)

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__attenuation
      
  def _set_attenuation(self, v, load=False):
    """
    Setter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_attenuation() directly.

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_attenuation(self):
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_optical_power(self):
    """
    Getter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power (container)

    YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    return self.__optical_power
      
  def _set_optical_power(self, v, load=False):
    """
    Setter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state/optical_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_power() directly.

    YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)""",
        })

    self.__optical_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_power(self):
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

  target_attenuation = __builtin__.property(_get_target_attenuation)
  attenuation = __builtin__.property(_get_attenuation)
  optical_power = __builtin__.property(_get_optical_power)


  _pyangbind_elements = OrderedDict([('target_attenuation', target_attenuation), ('attenuation', attenuation), ('optical_power', optical_power), ])


class yc_line_primary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-primary-out. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for information related to the line primary
output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'line-primary-out'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-primary-out']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/config (container)

    YANG Description: Configuration data for the line primary output port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the line primary output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state (container)

    YANG Description: State data for the line primary output port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for the line primary output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-in/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the line secondary input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__target_attenuation',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-in', 'config']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)


  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/config/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/config/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)
  target_attenuation = __builtin__.property(_get_target_attenuation, _set_target_attenuation)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('target_attenuation', target_attenuation), ])


class yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state_optical_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-in', 'state', 'optical-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-in/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for the line secondary input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__target_attenuation','__attenuation','__optical_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-in', 'state']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)


  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_attenuation(self):
    """
    Getter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/attenuation (decimal64)

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__attenuation
      
  def _set_attenuation(self, v, load=False):
    """
    Setter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_attenuation() directly.

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_attenuation(self):
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_optical_power(self):
    """
    Getter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power (container)

    YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    return self.__optical_power
      
  def _set_optical_power(self, v, load=False):
    """
    Setter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state/optical_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_power() directly.

    YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)""",
        })

    self.__optical_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_power(self):
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

  enabled = __builtin__.property(_get_enabled)
  target_attenuation = __builtin__.property(_get_target_attenuation)
  attenuation = __builtin__.property(_get_attenuation)
  optical_power = __builtin__.property(_get_optical_power)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('target_attenuation', target_attenuation), ('attenuation', attenuation), ('optical_power', optical_power), ])


class yc_line_secondary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-in. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for information related to the line secondary
input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'line-secondary-in'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-in']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/config (container)

    YANG Description: Configuration data for the line secondary input port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the line secondary input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state (container)

    YANG Description: State data for the line secondary input port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for the line secondary input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-out/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the line secondary output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_attenuation',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-out', 'config']

  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/config/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/config/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

  target_attenuation = __builtin__.property(_get_target_attenuation, _set_target_attenuation)


  _pyangbind_elements = OrderedDict([('target_attenuation', target_attenuation), ])


class yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state_optical_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-out', 'state', 'optical-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-out/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for the line secondary output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_attenuation','__attenuation','__optical_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-out', 'state']

  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_attenuation(self):
    """
    Getter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/attenuation (decimal64)

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__attenuation
      
  def _set_attenuation(self, v, load=False):
    """
    Setter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_attenuation() directly.

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_attenuation(self):
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_optical_power(self):
    """
    Getter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power (container)

    YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    return self.__optical_power
      
  def _set_optical_power(self, v, load=False):
    """
    Setter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state/optical_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_power() directly.

    YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)""",
        })

    self.__optical_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_power(self):
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

  target_attenuation = __builtin__.property(_get_target_attenuation)
  attenuation = __builtin__.property(_get_attenuation)
  optical_power = __builtin__.property(_get_optical_power)


  _pyangbind_elements = OrderedDict([('target_attenuation', target_attenuation), ('attenuation', attenuation), ('optical_power', optical_power), ])


class yc_line_secondary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/line-secondary-out. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for information related to the line secondary
output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'line-secondary-out'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'line-secondary-out']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/config (container)

    YANG Description: Configuration data for the line secondary output port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the line secondary output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state (container)

    YANG Description: State data for the line secondary output port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for the line secondary output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-in/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the line common input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__target_attenuation',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-in', 'config']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=True)


  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/config/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/config/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)
  target_attenuation = __builtin__.property(_get_target_attenuation, _set_target_attenuation)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('target_attenuation', target_attenuation), ])


class yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state_optical_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-in/state/optical-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-in', 'state', 'optical-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-in/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for the line common input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__target_attenuation','__attenuation','__optical_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-in', 'state']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
port. Disabling the port turns off alarm reporting for
the port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='boolean', is_config=False)


  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_attenuation(self):
    """
    Getter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/attenuation (decimal64)

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    return self.__attenuation
      
  def _set_attenuation(self, v, load=False):
    """
    Setter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_attenuation() directly.

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_attenuation(self):
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_optical_power(self):
    """
    Getter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power (container)

    YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    return self.__optical_power
      
  def _set_optical_power(self, v, load=False):
    """
    Setter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state/optical_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_power() directly.

    YANG Description: The optical input power of this port in units of
0.01dBm. Optical input power represents the signal
traversing from an external destination into the module.
The power is measured before any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)""",
        })

    self.__optical_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_power(self):
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

  enabled = __builtin__.property(_get_enabled)
  target_attenuation = __builtin__.property(_get_target_attenuation)
  attenuation = __builtin__.property(_get_attenuation)
  optical_power = __builtin__.property(_get_optical_power)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('target_attenuation', target_attenuation), ('attenuation', attenuation), ('optical_power', optical_power), ])


class yc_common_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-in. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for information related to the line common
input port
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'common-in'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-in']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/config (container)

    YANG Description: Configuration data for the line common input port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the line common input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state (container)

    YANG Description: State data for the line common input port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for the line common input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-output/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the line common output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_attenuation',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-output', 'config']

  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/config/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/config/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=True)

  target_attenuation = __builtin__.property(_get_target_attenuation, _set_target_attenuation)


  _pyangbind_elements = OrderedDict([('target_attenuation', target_attenuation), ])


class yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state_optical_power(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-output/state/optical-power. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'optical-power'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-output', 'state', 'optical-power']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/max (decimal64)

    YANG Description: The maximum value of the statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-output/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for the line common output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_attenuation','__attenuation','__optical_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-output', 'state']

  def _get_target_attenuation(self):
    """
    Getter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/target_attenuation (decimal64)

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__target_attenuation
      
  def _set_target_attenuation(self, v, load=False):
    """
    Setter method for target_attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/target_attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_attenuation() directly.

    YANG Description: Target attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__target_attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_attenuation(self):
    self.__target_attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="target-attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_attenuation(self):
    """
    Getter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/attenuation (decimal64)

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    return self.__attenuation
      
  def _set_attenuation(self, v, load=False):
    """
    Setter method for attenuation, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/attenuation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_attenuation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_attenuation() directly.

    YANG Description: The attenuation of the variable optical attenuator
associated with the port in increments of 0.01 dB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """attenuation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)""",
        })

    self.__attenuation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_attenuation(self):
    self.__attenuation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="attenuation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='decimal64', is_config=False)


  def _get_optical_power(self):
    """
    Getter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power (container)

    YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    return self.__optical_power
      
  def _set_optical_power(self, v, load=False):
    """
    Setter method for optical_power, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state/optical_power (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_power() directly.

    YANG Description: The optical output power of this port in units of
0.01dBm. Optical output power represents the signal
traversing from the module to an external destination. The
power is measured after any attenuation. If avg/min/max
statistics are not supported, the target is expected to
just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_power must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)""",
        })

    self.__optical_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_power(self):
    self.__optical_power = YANGDynClass(base=yc_optical_power_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state_optical_power, is_container='container', yang_name="optical-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=False)

  target_attenuation = __builtin__.property(_get_target_attenuation)
  attenuation = __builtin__.property(_get_attenuation)
  optical_power = __builtin__.property(_get_optical_power)


  _pyangbind_elements = OrderedDict([('target_attenuation', target_attenuation), ('attenuation', attenuation), ('optical_power', optical_power), ])


class yc_common_output_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports/common-output. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for information related to the line common
output port
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'common-output'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports', 'common-output']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/config (container)

    YANG Description: Configuration data for the line common output port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the line common output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state (container)

    YANG Description: State data for the line common output port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for the line common output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_ports_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module/ports. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level grouping for automatic protection switch ports
  """
  __slots__ = ('_path_helper', '_extmethods', '__line_primary_in','__line_primary_out','__line_secondary_in','__line_secondary_out','__common_in','__common_output',)

  _yang_name = 'ports'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__line_primary_in = YANGDynClass(base=yc_line_primary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in, is_container='container', yang_name="line-primary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__line_primary_out = YANGDynClass(base=yc_line_primary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out, is_container='container', yang_name="line-primary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__line_secondary_in = YANGDynClass(base=yc_line_secondary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in, is_container='container', yang_name="line-secondary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__line_secondary_out = YANGDynClass(base=yc_line_secondary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out, is_container='container', yang_name="line-secondary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__common_in = YANGDynClass(base=yc_common_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in, is_container='container', yang_name="common-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__common_output = YANGDynClass(base=yc_common_output_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output, is_container='container', yang_name="common-output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module', 'ports']

  def _get_line_primary_in(self):
    """
    Getter method for line_primary_in, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in (container)

    YANG Description: Container for information related to the line primary
input port
    """
    return self.__line_primary_in
      
  def _set_line_primary_in(self, v, load=False):
    """
    Setter method for line_primary_in, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_in (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_line_primary_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_line_primary_in() directly.

    YANG Description: Container for information related to the line primary
input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_line_primary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in, is_container='container', yang_name="line-primary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """line_primary_in must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_line_primary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in, is_container='container', yang_name="line-primary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__line_primary_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_line_primary_in(self):
    self.__line_primary_in = YANGDynClass(base=yc_line_primary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_in, is_container='container', yang_name="line-primary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_line_primary_out(self):
    """
    Getter method for line_primary_out, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out (container)

    YANG Description: Container for information related to the line primary
output port
    """
    return self.__line_primary_out
      
  def _set_line_primary_out(self, v, load=False):
    """
    Setter method for line_primary_out, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_primary_out (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_line_primary_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_line_primary_out() directly.

    YANG Description: Container for information related to the line primary
output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_line_primary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out, is_container='container', yang_name="line-primary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """line_primary_out must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_line_primary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out, is_container='container', yang_name="line-primary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__line_primary_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_line_primary_out(self):
    self.__line_primary_out = YANGDynClass(base=yc_line_primary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_primary_out, is_container='container', yang_name="line-primary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_line_secondary_in(self):
    """
    Getter method for line_secondary_in, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in (container)

    YANG Description: Container for information related to the line secondary
input port
    """
    return self.__line_secondary_in
      
  def _set_line_secondary_in(self, v, load=False):
    """
    Setter method for line_secondary_in, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_in (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_line_secondary_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_line_secondary_in() directly.

    YANG Description: Container for information related to the line secondary
input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_line_secondary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in, is_container='container', yang_name="line-secondary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """line_secondary_in must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_line_secondary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in, is_container='container', yang_name="line-secondary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__line_secondary_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_line_secondary_in(self):
    self.__line_secondary_in = YANGDynClass(base=yc_line_secondary_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_in, is_container='container', yang_name="line-secondary-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_line_secondary_out(self):
    """
    Getter method for line_secondary_out, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out (container)

    YANG Description: Container for information related to the line secondary
output port
    """
    return self.__line_secondary_out
      
  def _set_line_secondary_out(self, v, load=False):
    """
    Setter method for line_secondary_out, mapped from YANG variable /aps/aps_modules/aps_module/ports/line_secondary_out (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_line_secondary_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_line_secondary_out() directly.

    YANG Description: Container for information related to the line secondary
output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_line_secondary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out, is_container='container', yang_name="line-secondary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """line_secondary_out must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_line_secondary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out, is_container='container', yang_name="line-secondary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__line_secondary_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_line_secondary_out(self):
    self.__line_secondary_out = YANGDynClass(base=yc_line_secondary_out_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_line_secondary_out, is_container='container', yang_name="line-secondary-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_common_in(self):
    """
    Getter method for common_in, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in (container)

    YANG Description: Container for information related to the line common
input port
    """
    return self.__common_in
      
  def _set_common_in(self, v, load=False):
    """
    Setter method for common_in, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_in (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_common_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_common_in() directly.

    YANG Description: Container for information related to the line common
input port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_common_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in, is_container='container', yang_name="common-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """common_in must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_common_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in, is_container='container', yang_name="common-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__common_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_common_in(self):
    self.__common_in = YANGDynClass(base=yc_common_in_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_in, is_container='container', yang_name="common-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_common_output(self):
    """
    Getter method for common_output, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output (container)

    YANG Description: Container for information related to the line common
output port
    """
    return self.__common_output
      
  def _set_common_output(self, v, load=False):
    """
    Setter method for common_output, mapped from YANG variable /aps/aps_modules/aps_module/ports/common_output (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_common_output is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_common_output() directly.

    YANG Description: Container for information related to the line common
output port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_common_output_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output, is_container='container', yang_name="common-output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """common_output must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_common_output_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output, is_container='container', yang_name="common-output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__common_output = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_common_output(self):
    self.__common_output = YANGDynClass(base=yc_common_output_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports_common_output, is_container='container', yang_name="common-output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  line_primary_in = __builtin__.property(_get_line_primary_in, _set_line_primary_in)
  line_primary_out = __builtin__.property(_get_line_primary_out, _set_line_primary_out)
  line_secondary_in = __builtin__.property(_get_line_secondary_in, _set_line_secondary_in)
  line_secondary_out = __builtin__.property(_get_line_secondary_out, _set_line_secondary_out)
  common_in = __builtin__.property(_get_common_in, _set_common_in)
  common_output = __builtin__.property(_get_common_output, _set_common_output)


  _pyangbind_elements = OrderedDict([('line_primary_in', line_primary_in), ('line_primary_out', line_primary_out), ('line_secondary_in', line_secondary_in), ('line_secondary_out', line_secondary_out), ('common_in', common_in), ('common_output', common_output), ])


class yc_aps_module_openconfig_transport_line_protection__aps_aps_modules_aps_module(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules/aps-module. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of automatic protection switch modules present
in the device
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__ports',)

  _yang_name = 'aps-module'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    self.__ports = YANGDynClass(base=yc_ports_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports, is_container='container', yang_name="ports", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules', 'aps-module']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /aps/aps_modules/aps_module/name (leafref)

    YANG Description: Reference to the config name list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /aps/aps_modules/aps_module/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the config name list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /aps/aps_modules/aps_module/config (container)

    YANG Description: Configuration data for an automatic protection
switch module
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /aps/aps_modules/aps_module/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for an automatic protection
switch module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_protection__aps_aps_modules_aps_module_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /aps/aps_modules/aps_module/state (container)

    YANG Description: Operational state data for an automatic protection
switch module
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /aps/aps_modules/aps_module/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for an automatic protection
switch module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_protection__aps_aps_modules_aps_module_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)


  def _get_ports(self):
    """
    Getter method for ports, mapped from YANG variable /aps/aps_modules/aps_module/ports (container)

    YANG Description: Top level grouping for automatic protection switch ports
    """
    return self.__ports
      
  def _set_ports(self, v, load=False):
    """
    Setter method for ports, mapped from YANG variable /aps/aps_modules/aps_module/ports (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ports is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ports() directly.

    YANG Description: Top level grouping for automatic protection switch ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ports_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports, is_container='container', yang_name="ports", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ports must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ports_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports, is_container='container', yang_name="ports", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__ports = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ports(self):
    self.__ports = YANGDynClass(base=yc_ports_openconfig_transport_line_protection__aps_aps_modules_aps_module_ports, is_container='container', yang_name="ports", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  ports = __builtin__.property(_get_ports, _set_ports)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('ports', ports), ])


class yc_aps_modules_openconfig_transport_line_protection__aps_aps_modules(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps/aps-modules. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of automatic protection
      switch modules
  """
  __slots__ = ('_path_helper', '_extmethods', '__aps_module',)

  _yang_name = 'aps-modules'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__aps_module = YANGDynClass(base=YANGListType("name",yc_aps_module_openconfig_transport_line_protection__aps_aps_modules_aps_module, yang_name="aps-module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="aps-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps', 'aps-modules']

  def _get_aps_module(self):
    """
    Getter method for aps_module, mapped from YANG variable /aps/aps_modules/aps_module (list)

    YANG Description: List of automatic protection switch modules present
in the device
    """
    return self.__aps_module
      
  def _set_aps_module(self, v, load=False):
    """
    Setter method for aps_module, mapped from YANG variable /aps/aps_modules/aps_module (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_aps_module is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_aps_module() directly.

    YANG Description: List of automatic protection switch modules present
in the device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_aps_module_openconfig_transport_line_protection__aps_aps_modules_aps_module, yang_name="aps-module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="aps-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """aps_module must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_aps_module_openconfig_transport_line_protection__aps_aps_modules_aps_module, yang_name="aps-module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="aps-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='list', is_config=True)""",
        })

    self.__aps_module = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_aps_module(self):
    self.__aps_module = YANGDynClass(base=YANGListType("name",yc_aps_module_openconfig_transport_line_protection__aps_aps_modules_aps_module, yang_name="aps-module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="aps-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='list', is_config=True)

  aps_module = __builtin__.property(_get_aps_module, _set_aps_module)


  _pyangbind_elements = OrderedDict([('aps_module', aps_module), ])


class yc_aps_openconfig_transport_line_protection__aps(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /aps. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level grouping for automatic protection switch data
  """
  __slots__ = ('_path_helper', '_extmethods', '__aps_modules',)

  _yang_name = 'aps'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__aps_modules = YANGDynClass(base=yc_aps_modules_openconfig_transport_line_protection__aps_aps_modules, is_container='container', yang_name="aps-modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['aps']

  def _get_aps_modules(self):
    """
    Getter method for aps_modules, mapped from YANG variable /aps/aps_modules (container)

    YANG Description: Enclosing container for list of automatic protection
      switch modules
    """
    return self.__aps_modules
      
  def _set_aps_modules(self, v, load=False):
    """
    Setter method for aps_modules, mapped from YANG variable /aps/aps_modules (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_aps_modules is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_aps_modules() directly.

    YANG Description: Enclosing container for list of automatic protection
      switch modules
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_aps_modules_openconfig_transport_line_protection__aps_aps_modules, is_container='container', yang_name="aps-modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """aps_modules must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_aps_modules_openconfig_transport_line_protection__aps_aps_modules, is_container='container', yang_name="aps-modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__aps_modules = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_aps_modules(self):
    self.__aps_modules = YANGDynClass(base=yc_aps_modules_openconfig_transport_line_protection__aps_aps_modules, is_container='container', yang_name="aps-modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  aps_modules = __builtin__.property(_get_aps_modules, _set_aps_modules)


  _pyangbind_elements = OrderedDict([('aps_modules', aps_modules), ])


class openconfig_transport_line_protection(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-protection - based on the path /openconfig-transport-line-protection. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This model describes configuration and operational state data
for optical line protection elements, deployed as part of a
transport line system. An Automatic Protection Switch (APS)
is typically installed in the same device as the amplifiers
and wave-router, however an APS can also be a standalone
device. In both scenarios, it serves the same purpose of
providing protection using two dark fiber pairs to ensure the
amplifiers can still receive a signal if one of the two fiber
pairs is broken. The APS port details and directionality are
shown below. The three major attributes, together with their
modifiers, define the behavior of the APS and can be prioritized
in the descending order as shown in the following table
  """
  __slots__ = ('_path_helper', '_extmethods', '__aps',)

  _yang_name = 'openconfig-transport-line-protection'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__aps = YANGDynClass(base=yc_aps_openconfig_transport_line_protection__aps, is_container='container', yang_name="aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_aps(self):
    """
    Getter method for aps, mapped from YANG variable /aps (container)

    YANG Description: Top level grouping for automatic protection switch data
    """
    return self.__aps
      
  def _set_aps(self, v, load=False):
    """
    Setter method for aps, mapped from YANG variable /aps (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_aps is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_aps() directly.

    YANG Description: Top level grouping for automatic protection switch data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_aps_openconfig_transport_line_protection__aps, is_container='container', yang_name="aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """aps must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_aps_openconfig_transport_line_protection__aps, is_container='container', yang_name="aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)""",
        })

    self.__aps = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_aps(self):
    self.__aps = YANGDynClass(base=yc_aps_openconfig_transport_line_protection__aps, is_container='container', yang_name="aps", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/optical-transport-line-protection', defining_module='openconfig-transport-line-protection', yang_type='container', is_config=True)

  aps = __builtin__.property(_get_aps, _set_aps)


  _pyangbind_elements = OrderedDict([('aps', aps), ])


class openconfig_transport_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-types - based on the path /openconfig-transport-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module contains general type definitions and identities
for optical transport models.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__admin_state','__rate_class','__trib_protocol','__logical_channel_type','__loopback_mode','__test_signal','__client_mapping_mode',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    self.__admin_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)
    self.__rate_class = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    self.__trib_protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    self.__logical_channel_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    self.__loopback_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=True)
    self.__test_signal = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    self.__client_mapping_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/config/index (uint32)

    YANG Description: Index of the current logical channel
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/config/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index of the current logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/config/description (string)

    YANG Description: Description of the logical channel
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description of the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)


  def _get_admin_state(self):
    """
    Getter method for admin_state, mapped from YANG variable /terminal_device/logical_channels/channel/config/admin_state (oc-opt-types:admin-state-type)

    YANG Description: Sets the admin state of the logical channel
    """
    return self.__admin_state
      
  def _set_admin_state(self, v, load=False):
    """
    Setter method for admin_state, mapped from YANG variable /terminal_device/logical_channels/channel/config/admin_state (oc-opt-types:admin-state-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_state() directly.

    YANG Description: Sets the admin state of the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_state must be of a type compatible with oc-opt-types:admin-state-type""",
          'defined-type': "oc-opt-types:admin-state-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)""",
        })

    self.__admin_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_state(self):
    self.__admin_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)


  def _get_rate_class(self):
    """
    Getter method for rate_class, mapped from YANG variable /terminal_device/logical_channels/channel/config/rate_class (identityref)

    YANG Description: Rounded bit rate of the tributary signal. Exact bit rate
will be refined by protocol selection.
    """
    return self.__rate_class
      
  def _set_rate_class(self, v, load=False):
    """
    Setter method for rate_class, mapped from YANG variable /terminal_device/logical_channels/channel/config/rate_class (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_class() directly.

    YANG Description: Rounded bit rate of the tributary signal. Exact bit rate
will be refined by protocol selection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_class must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__rate_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_class(self):
    self.__rate_class = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)


  def _get_trib_protocol(self):
    """
    Getter method for trib_protocol, mapped from YANG variable /terminal_device/logical_channels/channel/config/trib_protocol (identityref)

    YANG Description: Protocol framing of the tributary signal. If this
LogicalChannel is directly connected to a Client-Port or
Optical-Channel, this is the protocol of the associated port.
If the LogicalChannel is connected to other LogicalChannels,
the TributaryProtocol of the LogicalChannels will define a
specific mapping/demapping or multiplexing/demultiplexing
function.

Not all protocols are valid, depending on the value
of trib-rate-class.  The expectation is that the NMS
will validate that a correct combination of rate class
and protocol are specfied.  Basic combinations are:

rate class: 1G
protocols: 1GE

rate class: 2.5G
protocols: OC48, STM16

rate class: 10G
protocols:  10GE LAN, 10GE WAN, OC192, STM64, OTU2, OTU2e,
           OTU1e, ODU2, ODU2e, ODU1e

rate class: 40G
protocols:  40GE, OC768, STM256, OTU3, ODU3

rate class: 100G
protocols:  100GE, 100G MLG, OTU4, OTUCn, ODU4
    """
    return self.__trib_protocol
      
  def _set_trib_protocol(self, v, load=False):
    """
    Setter method for trib_protocol, mapped from YANG variable /terminal_device/logical_channels/channel/config/trib_protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_trib_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_trib_protocol() directly.

    YANG Description: Protocol framing of the tributary signal. If this
LogicalChannel is directly connected to a Client-Port or
Optical-Channel, this is the protocol of the associated port.
If the LogicalChannel is connected to other LogicalChannels,
the TributaryProtocol of the LogicalChannels will define a
specific mapping/demapping or multiplexing/demultiplexing
function.

Not all protocols are valid, depending on the value
of trib-rate-class.  The expectation is that the NMS
will validate that a correct combination of rate class
and protocol are specfied.  Basic combinations are:

rate class: 1G
protocols: 1GE

rate class: 2.5G
protocols: OC48, STM16

rate class: 10G
protocols:  10GE LAN, 10GE WAN, OC192, STM64, OTU2, OTU2e,
           OTU1e, ODU2, ODU2e, ODU1e

rate class: 40G
protocols:  40GE, OC768, STM256, OTU3, ODU3

rate class: 100G
protocols:  100GE, 100G MLG, OTU4, OTUCn, ODU4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-t