//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
	"time"
)

// ActionClassification provides polymorphic access to related types.
// Call the interface's GetAction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Action, *AlertingAction, *LogToMetricAction
type ActionClassification interface {
	// GetAction returns the Action content of the underlying type.
	GetAction() *Action
}

// Action descriptor.
type Action struct {
	// REQUIRED; Specifies the action. Supported values - AlertingAction, LogToMetricAction
	ODataType *string `json:"odata.type,omitempty"`
}

// GetAction implements the ActionClassification interface for type Action.
func (a *Action) GetAction() *Action { return a }

// ActionDetail - The action detail
type ActionDetail struct {
	// The detail of the friendly error message
	Detail *string `json:"Detail,omitempty"`

	// The mechanism type
	MechanismType *string `json:"MechanismType,omitempty"`

	// The name of the action
	Name *string `json:"Name,omitempty"`

	// The send time
	SendTime *string `json:"SendTime,omitempty"`

	// The status of the action
	Status *string `json:"Status,omitempty"`

	// The substatus of the action
	SubState *string `json:"SubState,omitempty"`
}

// ActionGroup - An Azure action group.
type ActionGroup struct {
	// REQUIRED; Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers
	// will receive communications.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; The short name of the action group. This will be used in SMS messages.
	GroupShortName *string `json:"groupShortName,omitempty"`

	// The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are
	// supported.
	ArmRoleReceivers []*ArmRoleReceiver `json:"armRoleReceivers,omitempty"`

	// The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers []*AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`

	// The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers []*AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`

	// The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers []*AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`

	// The list of email receivers that are part of this action group.
	EmailReceivers []*EmailReceiver `json:"emailReceivers,omitempty"`

	// The list of event hub receivers that are part of this action group.
	EventHubReceivers []*EventHubReceiver `json:"eventHubReceivers,omitempty"`

	// The list of ITSM receivers that are part of this action group.
	ItsmReceivers []*ItsmReceiver `json:"itsmReceivers,omitempty"`

	// The list of logic app receivers that are part of this action group.
	LogicAppReceivers []*LogicAppReceiver `json:"logicAppReceivers,omitempty"`

	// The list of SMS receivers that are part of this action group.
	SmsReceivers []*SmsReceiver `json:"smsReceivers,omitempty"`

	// The list of voice receivers that are part of this action group.
	VoiceReceivers []*VoiceReceiver `json:"voiceReceivers,omitempty"`

	// The list of webhook receivers that are part of this action group.
	WebhookReceivers []*WebhookReceiver `json:"webhookReceivers,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ActionGroup.
func (a ActionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "armRoleReceivers", a.ArmRoleReceivers)
	populate(objectMap, "automationRunbookReceivers", a.AutomationRunbookReceivers)
	populate(objectMap, "azureAppPushReceivers", a.AzureAppPushReceivers)
	populate(objectMap, "azureFunctionReceivers", a.AzureFunctionReceivers)
	populate(objectMap, "emailReceivers", a.EmailReceivers)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "eventHubReceivers", a.EventHubReceivers)
	populate(objectMap, "groupShortName", a.GroupShortName)
	populate(objectMap, "itsmReceivers", a.ItsmReceivers)
	populate(objectMap, "logicAppReceivers", a.LogicAppReceivers)
	populate(objectMap, "smsReceivers", a.SmsReceivers)
	populate(objectMap, "voiceReceivers", a.VoiceReceivers)
	populate(objectMap, "webhookReceivers", a.WebhookReceivers)
	return json.Marshal(objectMap)
}

// ActionGroupAutoGenerated - A pointer to an Azure Action Group.
type ActionGroupAutoGenerated struct {
	// REQUIRED; The resource ID of the Action Group. This cannot be null or empty.
	ActionGroupID *string `json:"actionGroupId,omitempty"`

	// the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	WebhookProperties map[string]*string `json:"webhookProperties,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ActionGroupAutoGenerated.
func (a ActionGroupAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionGroupId", a.ActionGroupID)
	populate(objectMap, "webhookProperties", a.WebhookProperties)
	return json.Marshal(objectMap)
}

// ActionGroupList - A list of action groups.
type ActionGroupList struct {
	// Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of action groups.
	Value []*ActionGroupResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ActionGroupList.
func (a ActionGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// ActionGroupPatch - An Azure action group for patch operations.
type ActionGroupPatch struct {
	// Indicates whether this action group is enabled. If an action group is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// ActionGroupPatchBody - An action group object for the body of patch operations.
type ActionGroupPatchBody struct {
	// The action group settings for an update operation.
	Properties *ActionGroupPatch `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ActionGroupPatchBody.
func (a ActionGroupPatchBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// ActionGroupResource - An action group resource.
type ActionGroupResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The action groups properties of the resource.
	Properties *ActionGroup `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource identity
	Identity *string `json:"identity,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource kind
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ActionGroupResource.
func (a ActionGroupResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// ActionGroupsClientBeginPostTestNotificationsOptions contains the optional parameters for the ActionGroupsClient.BeginPostTestNotifications
// method.
type ActionGroupsClientBeginPostTestNotificationsOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientCreateOrUpdateOptions contains the optional parameters for the ActionGroupsClient.CreateOrUpdate method.
type ActionGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientDeleteOptions contains the optional parameters for the ActionGroupsClient.Delete method.
type ActionGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientEnableReceiverOptions contains the optional parameters for the ActionGroupsClient.EnableReceiver method.
type ActionGroupsClientEnableReceiverOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientGetOptions contains the optional parameters for the ActionGroupsClient.Get method.
type ActionGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientGetTestNotificationsOptions contains the optional parameters for the ActionGroupsClient.GetTestNotifications
// method.
type ActionGroupsClientGetTestNotificationsOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientListByResourceGroupOptions contains the optional parameters for the ActionGroupsClient.ListByResourceGroup
// method.
type ActionGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientListBySubscriptionIDOptions contains the optional parameters for the ActionGroupsClient.ListBySubscriptionID
// method.
type ActionGroupsClientListBySubscriptionIDOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientUpdateOptions contains the optional parameters for the ActionGroupsClient.Update method.
type ActionGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActionList - A list of Activity Log Alert rule actions.
type ActionList struct {
	// The list of the Action Groups.
	ActionGroups []*ActionGroupAutoGenerated `json:"actionGroups,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ActionList.
func (a ActionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionGroups", a.ActionGroups)
	return json.Marshal(objectMap)
}

// ActivityLogAlertResource - An Activity Log Alert rule resource.
type ActivityLogAlertResource struct {
	// The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always
	// be 'global'.
	Location *string `json:"location,omitempty"`

	// The Activity Log Alert rule properties of the resource.
	Properties *AlertRuleProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ActivityLogAlertResource.
func (a ActivityLogAlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// ActivityLogAlertsClientCreateOrUpdateOptions contains the optional parameters for the ActivityLogAlertsClient.CreateOrUpdate
// method.
type ActivityLogAlertsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientDeleteOptions contains the optional parameters for the ActivityLogAlertsClient.Delete method.
type ActivityLogAlertsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientGetOptions contains the optional parameters for the ActivityLogAlertsClient.Get method.
type ActivityLogAlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientListByResourceGroupOptions contains the optional parameters for the ActivityLogAlertsClient.ListByResourceGroup
// method.
type ActivityLogAlertsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientListBySubscriptionIDOptions contains the optional parameters for the ActivityLogAlertsClient.ListBySubscriptionID
// method.
type ActivityLogAlertsClientListBySubscriptionIDOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientUpdateOptions contains the optional parameters for the ActivityLogAlertsClient.Update method.
type ActivityLogAlertsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogsClientListOptions contains the optional parameters for the ActivityLogsClient.List method.
type ActivityLogsClientListOptions struct {
	// Used to fetch events with only the given properties.
	// The $select argument is a comma separated list of property names to be returned. Possible values are: authorization, claims,
	// correlationId, description, eventDataId, eventName, eventTimestamp,
	// httpRequest, level, operationId, operationName, properties, resourceGroupName, resourceProviderName, resourceId, status,
	// submissionTimestamp, subStatus, subscriptionId
	Select *string
}

// AlertRule - An alert rule.
type AlertRule struct {
	// REQUIRED; the condition that results in the alert rule being activated.
	Condition RuleConditionClassification `json:"condition,omitempty"`

	// REQUIRED; the flag that indicates whether the alert rule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; the name of the alert rule.
	Name *string `json:"name,omitempty"`

	// action that is performed when the alert rule becomes active, and when an alert condition is resolved.
	Action RuleActionClassification `json:"action,omitempty"`

	// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions []RuleActionClassification `json:"actions,omitempty"`

	// the description of the alert rule that will be included in the alert email.
	Description *string `json:"description,omitempty"`

	// the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRule.
func (a AlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", a.Action)
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "condition", a.Condition)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", a.LastUpdatedTime)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertRule.
func (a *AlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			a.Action, err = unmarshalRuleActionClassification(val)
			delete(rawMsg, key)
		case "actions":
			a.Actions, err = unmarshalRuleActionClassificationArray(val)
			delete(rawMsg, key)
		case "condition":
			a.Condition, err = unmarshalRuleConditionClassification(val)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, &a.Description)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, &a.IsEnabled)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, &a.LastUpdatedTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &a.Name)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// AlertRuleAllOfCondition - An Activity Log Alert rule condition that is met when all its member conditions are met.
type AlertRuleAllOfCondition struct {
	// REQUIRED; The list of Activity Log Alert rule conditions.
	AllOf []*AlertRuleAnyOfOrLeafCondition `json:"allOf,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleAllOfCondition.
func (a AlertRuleAllOfCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allOf", a.AllOf)
	return json.Marshal(objectMap)
}

// AlertRuleAnyOfOrLeafCondition - An Activity Log Alert rule condition that is met when all its member conditions are met.
// Each condition can be of one of the following types:Important: Each type has its unique subset of properties.
// Properties from different types CANNOT exist in one condition.
// * Leaf Condition - must contain 'field' and either 'equals' or 'containsAny'.Please note, 'anyOf' should not be set in
// a Leaf Condition.
// * AnyOf Condition - must contain only 'anyOf' (which is an array of Leaf Conditions).Please note, 'field', 'equals' and
// 'containsAny' should not be set in an AnyOf Condition.
type AlertRuleAnyOfOrLeafCondition struct {
	// An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
	AnyOf []*AlertRuleLeafCondition `json:"anyOf,omitempty"`

	// The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition
	// is met.
	ContainsAny []*string `json:"containsAny,omitempty"`

	// The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`

	// The name of the Activity Log event's field that this condition will examine. The possible values for this field are (case-insensitive):
	// 'resourceId', 'category', 'caller', 'level', 'operationName',
	// 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleAnyOfOrLeafCondition.
func (a AlertRuleAnyOfOrLeafCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "anyOf", a.AnyOf)
	populate(objectMap, "containsAny", a.ContainsAny)
	populate(objectMap, "equals", a.Equals)
	populate(objectMap, "field", a.Field)
	return json.Marshal(objectMap)
}

// AlertRuleIncidentsClientGetOptions contains the optional parameters for the AlertRuleIncidentsClient.Get method.
type AlertRuleIncidentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertRuleIncidentsClientListByAlertRuleOptions contains the optional parameters for the AlertRuleIncidentsClient.ListByAlertRule
// method.
type AlertRuleIncidentsClientListByAlertRuleOptions struct {
	// placeholder for future optional parameters
}

// AlertRuleLeafCondition - An Activity Log Alert rule condition that is met by comparing the field and value of an Activity
// Log event. This condition must contain 'field' and either 'equals' or 'containsAny'.
type AlertRuleLeafCondition struct {
	// The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition
	// is met.
	ContainsAny []*string `json:"containsAny,omitempty"`

	// The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`

	// The name of the Activity Log event's field that this condition will examine. The possible values for this field are (case-insensitive):
	// 'resourceId', 'category', 'caller', 'level', 'operationName',
	// 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleLeafCondition.
func (a AlertRuleLeafCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "containsAny", a.ContainsAny)
	populate(objectMap, "equals", a.Equals)
	populate(objectMap, "field", a.Field)
	return json.Marshal(objectMap)
}

// AlertRuleList - A list of Activity Log Alert rules.
type AlertRuleList struct {
	// Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of Activity Log Alert rules.
	Value []*ActivityLogAlertResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleList.
func (a AlertRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// AlertRulePatchObject - An Activity Log Alert rule object for the body of patch operations.
type AlertRulePatchObject struct {
	// The activity log alert settings for an update operation.
	Properties *AlertRulePatchProperties `json:"properties,omitempty"`

	// The resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRulePatchObject.
func (a AlertRulePatchObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// AlertRulePatchProperties - An Activity Log Alert rule properties for patch operations.
type AlertRulePatchProperties struct {
	// Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its
	// actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertRuleProperties - An Azure Activity Log Alert rule.
type AlertRuleProperties struct {
	// REQUIRED; The actions that will activate when the condition is met.
	Actions *ActionList `json:"actions,omitempty"`

	// REQUIRED; The condition that will cause this alert to activate.
	Condition *AlertRuleAllOfCondition `json:"condition,omitempty"`

	// REQUIRED; A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource
	// IDs that fall under one of these prefixes. This list must include at least one
	// item.
	Scopes []*string `json:"scopes,omitempty"`

	// A description of this Activity Log Alert rule.
	Description *string `json:"description,omitempty"`

	// Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its
	// actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleProperties.
func (a AlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "condition", a.Condition)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "scopes", a.Scopes)
	return json.Marshal(objectMap)
}

// AlertRuleResource - The alert rule resource.
type AlertRuleResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The alert rule properties of the resource.
	Properties *AlertRule `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleResource.
func (a AlertRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// AlertRuleResourceCollection - Represents a collection of alert rule resources.
type AlertRuleResourceCollection struct {
	// the values for the alert rule resources.
	Value []*AlertRuleResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleResourceCollection.
func (a AlertRuleResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// AlertRuleResourcePatch - The alert rule object for patch operations.
type AlertRuleResourcePatch struct {
	// The properties of an alert rule.
	Properties *AlertRule `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleResourcePatch.
func (a AlertRuleResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// AlertRulesClientCreateOrUpdateOptions contains the optional parameters for the AlertRulesClient.CreateOrUpdate method.
type AlertRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientDeleteOptions contains the optional parameters for the AlertRulesClient.Delete method.
type AlertRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientGetOptions contains the optional parameters for the AlertRulesClient.Get method.
type AlertRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientListByResourceGroupOptions contains the optional parameters for the AlertRulesClient.ListByResourceGroup
// method.
type AlertRulesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientListBySubscriptionOptions contains the optional parameters for the AlertRulesClient.ListBySubscription
// method.
type AlertRulesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientUpdateOptions contains the optional parameters for the AlertRulesClient.Update method.
type AlertRulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AlertingAction - Specify action need to be taken when rule type is Alert
type AlertingAction struct {
	// REQUIRED; Specifies the action. Supported values - AlertingAction, LogToMetricAction
	ODataType *string `json:"odata.type,omitempty"`

	// REQUIRED; Severity of the alert
	Severity *AlertSeverity `json:"severity,omitempty"`

	// REQUIRED; The trigger condition that results in the alert rule being.
	Trigger *TriggerCondition `json:"trigger,omitempty"`

	// Azure action group reference.
	AznsAction *AzNsActionGroup `json:"aznsAction,omitempty"`

	// time (in minutes) for which Alerts should be throttled or suppressed.
	ThrottlingInMin *int32 `json:"throttlingInMin,omitempty"`
}

// GetAction implements the ActionClassification interface for type AlertingAction.
func (a *AlertingAction) GetAction() *Action {
	return &Action{
		ODataType: a.ODataType,
	}
}

// MarshalJSON implements the json.Marshaller interface for type AlertingAction.
func (a AlertingAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aznsAction", a.AznsAction)
	objectMap["odata.type"] = "Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction"
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "throttlingInMin", a.ThrottlingInMin)
	populate(objectMap, "trigger", a.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertingAction.
func (a *AlertingAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aznsAction":
			err = unpopulate(val, &a.AznsAction)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &a.ODataType)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, &a.Severity)
			delete(rawMsg, key)
		case "throttlingInMin":
			err = unpopulate(val, &a.ThrottlingInMin)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, &a.Trigger)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// ArmRoleReceiver - An arm role receiver.
type ArmRoleReceiver struct {
	// REQUIRED; The name of the arm role receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The arm role id.
	RoleID *string `json:"roleId,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutomationRunbookReceiver - The Azure Automation Runbook notification receiver.
type AutomationRunbookReceiver struct {
	// REQUIRED; The Azure automation account Id which holds this runbook and authenticate to Azure resource.
	AutomationAccountID *string `json:"automationAccountId,omitempty"`

	// REQUIRED; Indicates whether this instance is global runbook.
	IsGlobalRunbook *bool `json:"isGlobalRunbook,omitempty"`

	// REQUIRED; The name for this runbook.
	RunbookName *string `json:"runbookName,omitempty"`

	// REQUIRED; The resource id for webhook linked to this runbook.
	WebhookResourceID *string `json:"webhookResourceId,omitempty"`

	// Indicates name of the webhook.
	Name *string `json:"name,omitempty"`

	// The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutoscaleNotification - Autoscale notification.
type AutoscaleNotification struct {
	// REQUIRED; the operation associated with the notification and its value must be "scale"
	Operation *string `json:"operation,omitempty"`

	// the email notification.
	Email *EmailNotification `json:"email,omitempty"`

	// the collection of webhook notifications.
	Webhooks []*WebhookNotification `json:"webhooks,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleNotification.
func (a AutoscaleNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "email", a.Email)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "webhooks", a.Webhooks)
	return json.Marshal(objectMap)
}

// AutoscaleProfile - Autoscale profile.
type AutoscaleProfile struct {
	// REQUIRED; the number of instances that can be used during this profile.
	Capacity *ScaleCapacity `json:"capacity,omitempty"`

	// REQUIRED; the name of the profile.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules
	// can be specified.
	Rules []*ScaleRule `json:"rules,omitempty"`

	// the specific date-time for the profile. This element is not used if the Recurrence element is used.
	FixedDate *TimeWindow `json:"fixedDate,omitempty"`

	// the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
	Recurrence *Recurrence `json:"recurrence,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleProfile.
func (a AutoscaleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "fixedDate", a.FixedDate)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "recurrence", a.Recurrence)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// AutoscaleSetting - A setting that contains all of the configuration for the automatic scaling of a resource.
type AutoscaleSetting struct {
	// REQUIRED; the collection of automatic scaling profiles that specify different scaling parameters for different time periods.
	// A maximum of 20 profiles can be specified.
	Profiles []*AutoscaleProfile `json:"profiles,omitempty"`

	// the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'true'.
	Enabled *bool `json:"enabled,omitempty"`

	// the name of the autoscale setting.
	Name *string `json:"name,omitempty"`

	// the collection of notifications.
	Notifications []*AutoscaleNotification `json:"notifications,omitempty"`

	// the location of the resource that the autoscale setting should be added to.
	TargetResourceLocation *string `json:"targetResourceLocation,omitempty"`

	// the resource identifier of the resource that the autoscale setting should be added to.
	TargetResourceURI *string `json:"targetResourceUri,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleSetting.
func (a AutoscaleSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "notifications", a.Notifications)
	populate(objectMap, "profiles", a.Profiles)
	populate(objectMap, "targetResourceLocation", a.TargetResourceLocation)
	populate(objectMap, "targetResourceUri", a.TargetResourceURI)
	return json.Marshal(objectMap)
}

// AutoscaleSettingResource - The autoscale setting resource.
type AutoscaleSettingResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The autoscale setting of the resource.
	Properties *AutoscaleSetting `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleSettingResource.
func (a AutoscaleSettingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// AutoscaleSettingResourceCollection - Represents a collection of autoscale setting resources.
type AutoscaleSettingResourceCollection struct {
	// REQUIRED; the values for the autoscale setting resources.
	Value []*AutoscaleSettingResource `json:"value,omitempty"`

	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleSettingResourceCollection.
func (a AutoscaleSettingResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// AutoscaleSettingResourcePatch - The autoscale setting object for patch operations.
type AutoscaleSettingResourcePatch struct {
	// The autoscale setting properties of the update operation.
	Properties *AutoscaleSetting `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleSettingResourcePatch.
func (a AutoscaleSettingResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// AutoscaleSettingsClientCreateOrUpdateOptions contains the optional parameters for the AutoscaleSettingsClient.CreateOrUpdate
// method.
type AutoscaleSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientDeleteOptions contains the optional parameters for the AutoscaleSettingsClient.Delete method.
type AutoscaleSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientGetOptions contains the optional parameters for the AutoscaleSettingsClient.Get method.
type AutoscaleSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientListByResourceGroupOptions contains the optional parameters for the AutoscaleSettingsClient.ListByResourceGroup
// method.
type AutoscaleSettingsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientListBySubscriptionOptions contains the optional parameters for the AutoscaleSettingsClient.ListBySubscription
// method.
type AutoscaleSettingsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientUpdateOptions contains the optional parameters for the AutoscaleSettingsClient.Update method.
type AutoscaleSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AzNsActionGroup - Azure action group
type AzNsActionGroup struct {
	// Azure Action Group reference.
	ActionGroup []*string `json:"actionGroup,omitempty"`

	// Custom payload to be sent for all webhook URI in Azure action group
	CustomWebhookPayload *string `json:"customWebhookPayload,omitempty"`

	// Custom subject override for all email ids in Azure action group
	EmailSubject *string `json:"emailSubject,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AzNsActionGroup.
func (a AzNsActionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionGroup", a.ActionGroup)
	populate(objectMap, "customWebhookPayload", a.CustomWebhookPayload)
	populate(objectMap, "emailSubject", a.EmailSubject)
	return json.Marshal(objectMap)
}

// AzureAppPushReceiver - The Azure mobile App push notification receiver.
type AzureAppPushReceiver struct {
	// REQUIRED; The email address registered for the Azure mobile app.
	EmailAddress *string `json:"emailAddress,omitempty"`

	// REQUIRED; The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
}

// AzureFunctionReceiver - An azure function receiver.
type AzureFunctionReceiver struct {
	// REQUIRED; The azure resource id of the function app.
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`

	// REQUIRED; The function name in the function app.
	FunctionName *string `json:"functionName,omitempty"`

	// REQUIRED; The http trigger url where http request sent to.
	HTTPTriggerURL *string `json:"httpTriggerUrl,omitempty"`

	// REQUIRED; The name of the azure function receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AzureMonitorMetricsDestination - Azure Monitor Metrics destination.
type AzureMonitorMetricsDestination struct {
	// A friendly name for the destination. This name should be unique across all destinations (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`
}

// AzureMonitorPrivateLinkScope - An Azure Monitor PrivateLinkScope definition.
type AzureMonitorPrivateLinkScope struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties that define a Azure Monitor PrivateLinkScope resource.
	Properties *AzureMonitorPrivateLinkScopeProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorPrivateLinkScope.
func (a AzureMonitorPrivateLinkScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// AzureMonitorPrivateLinkScopeListResult - Describes the list of Azure Monitor PrivateLinkScope resources.
type AzureMonitorPrivateLinkScopeListResult struct {
	// REQUIRED; List of Azure Monitor PrivateLinkScope definitions.
	Value []*AzureMonitorPrivateLinkScope `json:"value,omitempty"`

	// The URI to get the next set of Azure Monitor PrivateLinkScope definitions if too many PrivateLinkScopes where returned
	// in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorPrivateLinkScopeListResult.
func (a AzureMonitorPrivateLinkScopeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// AzureMonitorPrivateLinkScopeProperties - Properties that define a Azure Monitor PrivateLinkScope resource.
type AzureMonitorPrivateLinkScopeProperties struct {
	// READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it
	// is defined. Users cannot change this value but are able to read from it. Values will include
	// Provisioning ,Succeeded, Canceled and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorPrivateLinkScopeProperties.
func (a AzureMonitorPrivateLinkScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateEndpointConnections", a.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// AzureResource - An azure resource object
type AzureResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource identity
	Identity *string `json:"identity,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource kind
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AzureResource.
func (a AzureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// AzureResourceAutoGenerated - An Azure resource object.
type AzureResourceAutoGenerated struct {
	// The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always
	// be 'global'.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceAutoGenerated.
func (a AzureResourceAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// BaselineMetadata - Represents a baseline metadata value.
type BaselineMetadata struct {
	// REQUIRED; Name of the baseline metadata.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Value of the baseline metadata.
	Value *string `json:"value,omitempty"`
}

// BaselinesClientListOptions contains the optional parameters for the BaselinesClient.List method.
type BaselinesClientListOptions struct {
	// The list of aggregation types (comma separated) to retrieve.
	Aggregation *string
	// The $filter is used to reduce the set of metric data returned. Example: Metric contains metadata A, B and C. - Return all
	// time series of C where A = a1 and B = b1 or b2 $filter=A eq 'a1' and B eq 'b1'
	// or B eq 'b2' and C eq '' - Invalid variant: $filter=A eq 'a1' and B eq 'b1' and C eq '' or B = 'b2' This is invalid because
	// the logical or operator cannot separate two different metadata names. -
	// Return all time series where A = a1, B = b1 and C = c1: $filter=A eq 'a1' and B eq 'b1' and C eq 'c1' - Return all time
	// series where A = a1 $filter=A eq 'a1' and B eq '' and C eq ''. Special case:
	// When dimension name or dimension value uses round brackets. Eg: When dimension name is dim (test) 1 Instead of using $filter=
	// "dim (test) 1 eq '' " use $filter= "dim %2528test%2529 1 eq '' " When
	// dimension name is dim (test) 3 and dimension value is dim3 (test) val Instead of using $filter= "dim (test) 3 eq 'dim3
	// (test) val' " use $filter= "dim %2528test%2529 3 eq 'dim3 %2528test%2529 val' "
	Filter *string
	// The interval (i.e. timegrain) of the query.
	Interval *string
	// The names of the metrics (comma separated) to retrieve. Special case: If a metricname itself has a comma in it then use
	// %2 to indicate it. Eg: 'Metric,Name1' should be 'Metric%2Name1'
	Metricnames *string
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
	// Allows retrieving only metadata of the baseline. On data request all information is retrieved.
	ResultType *ResultType
	// The list of sensitivities (comma separated) to retrieve.
	Sensitivities *string
	// The timespan of the query. It is a string with the following format 'startDateTimeISO/endDateTimeISO'.
	Timespan *string
}

// ConfigurationAccessEndpointSpec - Definition of the endpoint used for accessing configuration.
type ConfigurationAccessEndpointSpec struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// Context - The context info
type Context struct {
	// The context id type
	ContextType *string `json:"ContextType,omitempty"`

	// The source of the notification request
	NotificationSource *string `json:"NotificationSource,omitempty"`
}

// Criteria - Specifies the criteria for converting log to metric.
type Criteria struct {
	// REQUIRED; Name of the metric
	MetricName *string `json:"metricName,omitempty"`

	// List of Dimensions for creating metric
	Dimensions []*Dimension `json:"dimensions,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Criteria.
func (c Criteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dimensions", c.Dimensions)
	populate(objectMap, "metricName", c.MetricName)
	return json.Marshal(objectMap)
}

// DataCollectionEndpoint - Definition of data collection endpoint.
type DataCollectionEndpoint struct {
	// The endpoint used by agents to access their configuration.
	ConfigurationAccess *DataCollectionEndpointConfigurationAccess `json:"configurationAccess,omitempty"`

	// Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`

	// The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`

	// The endpoint used by clients to ingest logs.
	LogsIngestion *DataCollectionEndpointLogsIngestion `json:"logsIngestion,omitempty"`

	// Network access control rules for the endpoints.
	NetworkACLs *DataCollectionEndpointNetworkACLs `json:"networkAcls,omitempty"`

	// READ-ONLY; The resource provisioning state. This property is READ-ONLY.
	ProvisioningState *KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionEndpointConfigurationAccess - The endpoint used by agents to access their configuration.
type DataCollectionEndpointConfigurationAccess struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// DataCollectionEndpointLogsIngestion - The endpoint used by clients to ingest logs.
type DataCollectionEndpointLogsIngestion struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// DataCollectionEndpointNetworkACLs - Network access control rules for the endpoints.
type DataCollectionEndpointNetworkACLs struct {
	// The configuration to set whether network access from public internet to the endpoints are allowed.
	PublicNetworkAccess *KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// DataCollectionEndpointResource - Definition of ARM tracked top level resource.
type DataCollectionEndpointResource struct {
	// REQUIRED; The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`

	// The kind of the resource.
	Kind *KnownDataCollectionEndpointResourceKind `json:"kind,omitempty"`

	// Resource properties.
	Properties *DataCollectionEndpointResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionEndpointResourceSystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionEndpointResource.
func (d DataCollectionEndpointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// DataCollectionEndpointResourceListResult - A pageable list of resources.
type DataCollectionEndpointResourceListResult struct {
	// REQUIRED; A list of resources.
	Value []*DataCollectionEndpointResource `json:"value,omitempty"`

	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionEndpointResourceListResult.
func (d DataCollectionEndpointResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// DataCollectionEndpointResourceProperties - Resource properties.
type DataCollectionEndpointResourceProperties struct {
	// The endpoint used by agents to access their configuration.
	ConfigurationAccess *DataCollectionEndpointConfigurationAccess `json:"configurationAccess,omitempty"`

	// Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`

	// The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`

	// The endpoint used by clients to ingest logs.
	LogsIngestion *DataCollectionEndpointLogsIngestion `json:"logsIngestion,omitempty"`

	// Network access control rules for the endpoints.
	NetworkACLs *DataCollectionEndpointNetworkACLs `json:"networkAcls,omitempty"`

	// READ-ONLY; The resource provisioning state. This property is READ-ONLY.
	ProvisioningState *KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionEndpointResourceSystemData - Metadata pertaining to creation and last modification of the resource.
type DataCollectionEndpointResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionEndpointResourceSystemData.
func (d DataCollectionEndpointResourceSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", d.CreatedAt)
	populate(objectMap, "createdBy", d.CreatedBy)
	populate(objectMap, "createdByType", d.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", d.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", d.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", d.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataCollectionEndpointResourceSystemData.
func (d *DataCollectionEndpointResourceSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, &d.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, &d.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, &d.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, &d.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, &d.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, &d.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DataCollectionEndpointsClientCreateOptions contains the optional parameters for the DataCollectionEndpointsClient.Create
// method.
type DataCollectionEndpointsClientCreateOptions struct {
	// The payload
	Body *DataCollectionEndpointResource
}

// DataCollectionEndpointsClientDeleteOptions contains the optional parameters for the DataCollectionEndpointsClient.Delete
// method.
type DataCollectionEndpointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientGetOptions contains the optional parameters for the DataCollectionEndpointsClient.Get method.
type DataCollectionEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientListByResourceGroupOptions contains the optional parameters for the DataCollectionEndpointsClient.ListByResourceGroup
// method.
type DataCollectionEndpointsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientListBySubscriptionOptions contains the optional parameters for the DataCollectionEndpointsClient.ListBySubscription
// method.
type DataCollectionEndpointsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientUpdateOptions contains the optional parameters for the DataCollectionEndpointsClient.Update
// method.
type DataCollectionEndpointsClientUpdateOptions struct {
	// The payload
	Body *ResourceForUpdate
}

// DataCollectionRule - Definition of what monitoring data to collect and where that data should be sent.
type DataCollectionRule struct {
	// The specification of data flows.
	DataFlows []*DataFlow `json:"dataFlows,omitempty"`

	// The specification of data sources. This property is optional and can be omitted if the rule is meant to be used via direct
	// calls to the provisioned endpoint.
	DataSources *DataCollectionRuleDataSources `json:"dataSources,omitempty"`

	// Description of the data collection rule.
	Description *string `json:"description,omitempty"`

	// The specification of destinations.
	Destinations *DataCollectionRuleDestinations `json:"destinations,omitempty"`

	// READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty" azure:"ro"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRule.
func (d DataCollectionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataFlows", d.DataFlows)
	populate(objectMap, "dataSources", d.DataSources)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "destinations", d.Destinations)
	populate(objectMap, "immutableId", d.ImmutableID)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// DataCollectionRuleAssociation - Definition of association of a data collection rule with a monitored Azure resource.
type DataCollectionRuleAssociation struct {
	// The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`

	// The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`

	// Description of the association.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationProxyOnlyResource - Definition of generic ARM proxy resource.
type DataCollectionRuleAssociationProxyOnlyResource struct {
	// Resource properties.
	Properties *DataCollectionRuleAssociationProxyOnlyResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionRuleAssociationProxyOnlyResourceSystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationProxyOnlyResourceListResult - A pageable list of resources.
type DataCollectionRuleAssociationProxyOnlyResourceListResult struct {
	// REQUIRED; A list of resources.
	Value []*DataCollectionRuleAssociationProxyOnlyResource `json:"value,omitempty"`

	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleAssociationProxyOnlyResourceListResult.
func (d DataCollectionRuleAssociationProxyOnlyResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// DataCollectionRuleAssociationProxyOnlyResourceProperties - Resource properties.
type DataCollectionRuleAssociationProxyOnlyResourceProperties struct {
	// The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`

	// The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`

	// Description of the association.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationProxyOnlyResourceSystemData - Metadata pertaining to creation and last modification of the
// resource.
type DataCollectionRuleAssociationProxyOnlyResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleAssociationProxyOnlyResourceSystemData.
func (d DataCollectionRuleAssociationProxyOnlyResourceSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", d.CreatedAt)
	populate(objectMap, "createdBy", d.CreatedBy)
	populate(objectMap, "createdByType", d.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", d.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", d.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", d.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataCollectionRuleAssociationProxyOnlyResourceSystemData.
func (d *DataCollectionRuleAssociationProxyOnlyResourceSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, &d.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, &d.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, &d.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, &d.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, &d.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, &d.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DataCollectionRuleAssociationsClientCreateOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.Create
// method.
type DataCollectionRuleAssociationsClientCreateOptions struct {
	// The payload
	Body *DataCollectionRuleAssociationProxyOnlyResource
}

// DataCollectionRuleAssociationsClientDeleteOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.Delete
// method.
type DataCollectionRuleAssociationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientGetOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.Get
// method.
type DataCollectionRuleAssociationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientListByResourceOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.ListByResource
// method.
type DataCollectionRuleAssociationsClientListByResourceOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientListByRuleOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.ListByRule
// method.
type DataCollectionRuleAssociationsClientListByRuleOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleDataSources - The specification of data sources. This property is optional and can be omitted if the
// rule is meant to be used via direct calls to the provisioned endpoint.
type DataCollectionRuleDataSources struct {
	// The list of Azure VM extension data source configurations.
	Extensions []*ExtensionDataSource `json:"extensions,omitempty"`

	// The list of performance counter data source configurations.
	PerformanceCounters []*PerfCounterDataSource `json:"performanceCounters,omitempty"`

	// The list of Syslog data source configurations.
	Syslog []*SyslogDataSource `json:"syslog,omitempty"`

	// The list of Windows Event Log data source configurations.
	WindowsEventLogs []*WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleDataSources.
func (d DataCollectionRuleDataSources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extensions", d.Extensions)
	populate(objectMap, "performanceCounters", d.PerformanceCounters)
	populate(objectMap, "syslog", d.Syslog)
	populate(objectMap, "windowsEventLogs", d.WindowsEventLogs)
	return json.Marshal(objectMap)
}

// DataCollectionRuleDestinations - The specification of destinations.
type DataCollectionRuleDestinations struct {
	// Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`

	// List of Log Analytics destinations.
	LogAnalytics []*LogAnalyticsDestination `json:"logAnalytics,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleDestinations.
func (d DataCollectionRuleDestinations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureMonitorMetrics", d.AzureMonitorMetrics)
	populate(objectMap, "logAnalytics", d.LogAnalytics)
	return json.Marshal(objectMap)
}

// DataCollectionRuleResource - Definition of ARM tracked top level resource.
type DataCollectionRuleResource struct {
	// REQUIRED; The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`

	// The kind of the resource.
	Kind *KnownDataCollectionRuleResourceKind `json:"kind,omitempty"`

	// Resource properties.
	Properties *DataCollectionRuleResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionRuleResourceSystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleResource.
func (d DataCollectionRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// DataCollectionRuleResourceListResult - A pageable list of resources.
type DataCollectionRuleResourceListResult struct {
	// REQUIRED; A list of resources.
	Value []*DataCollectionRuleResource `json:"value,omitempty"`

	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleResourceListResult.
func (d DataCollectionRuleResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// DataCollectionRuleResourceProperties - Resource properties.
type DataCollectionRuleResourceProperties struct {
	// The specification of data flows.
	DataFlows []*DataFlow `json:"dataFlows,omitempty"`

	// The specification of data sources. This property is optional and can be omitted if the rule is meant to be used via direct
	// calls to the provisioned endpoint.
	DataSources *DataCollectionRuleDataSources `json:"dataSources,omitempty"`

	// Description of the data collection rule.
	Description *string `json:"description,omitempty"`

	// The specification of destinations.
	Destinations *DataCollectionRuleDestinations `json:"destinations,omitempty"`

	// READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty" azure:"ro"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleResourceProperties.
func (d DataCollectionRuleResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataFlows", d.DataFlows)
	populate(objectMap, "dataSources", d.DataSources)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "destinations", d.Destinations)
	populate(objectMap, "immutableId", d.ImmutableID)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// DataCollectionRuleResourceSystemData - Metadata pertaining to creation and last modification of the resource.
type DataCollectionRuleResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataCollectionRuleResourceSystemData.
func (d DataCollectionRuleResourceSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", d.CreatedAt)
	populate(objectMap, "createdBy", d.CreatedBy)
	populate(objectMap, "createdByType", d.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", d.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", d.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", d.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataCollectionRuleResourceSystemData.
func (d *DataCollectionRuleResourceSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, &d.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, &d.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, &d.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, &d.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, &d.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, &d.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DataCollectionRulesClientCreateOptions contains the optional parameters for the DataCollectionRulesClient.Create method.
type DataCollectionRulesClientCreateOptions struct {
	// The payload
	Body *DataCollectionRuleResource
}

// DataCollectionRulesClientDeleteOptions contains the optional parameters for the DataCollectionRulesClient.Delete method.
type DataCollectionRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientGetOptions contains the optional parameters for the DataCollectionRulesClient.Get method.
type DataCollectionRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientListByResourceGroupOptions contains the optional parameters for the DataCollectionRulesClient.ListByResourceGroup
// method.
type DataCollectionRulesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientListBySubscriptionOptions contains the optional parameters for the DataCollectionRulesClient.ListBySubscription
// method.
type DataCollectionRulesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientUpdateOptions contains the optional parameters for the DataCollectionRulesClient.Update method.
type DataCollectionRulesClientUpdateOptions struct {
	// The payload
	Body *ResourceForUpdate
}

// DataContainer - Information about a container with data for a given resource.
type DataContainer struct {
	// REQUIRED; Log Analytics workspace information.
	Workspace *WorkspaceInfo `json:"workspace,omitempty"`
}

// DataFlow - Definition of which streams are sent to which destinations.
type DataFlow struct {
	// List of destinations for this data flow.
	Destinations []*string `json:"destinations,omitempty"`

	// List of streams for this data flow.
	Streams []*KnownDataFlowStreams `json:"streams,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataFlow.
func (d DataFlow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destinations", d.Destinations)
	populate(objectMap, "streams", d.Streams)
	return json.Marshal(objectMap)
}

// DataSourcesSpec - Specification of data sources that will be collected.
type DataSourcesSpec struct {
	// The list of Azure VM extension data source configurations.
	Extensions []*ExtensionDataSource `json:"extensions,omitempty"`

	// The list of performance counter data source configurations.
	PerformanceCounters []*PerfCounterDataSource `json:"performanceCounters,omitempty"`

	// The list of Syslog data source configurations.
	Syslog []*SyslogDataSource `json:"syslog,omitempty"`

	// The list of Windows Event Log data source configurations.
	WindowsEventLogs []*WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DataSourcesSpec.
func (d DataSourcesSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extensions", d.Extensions)
	populate(objectMap, "performanceCounters", d.PerformanceCounters)
	populate(objectMap, "syslog", d.Syslog)
	populate(objectMap, "windowsEventLogs", d.WindowsEventLogs)
	return json.Marshal(objectMap)
}

// DestinationsSpec - Specification of destinations that can be used in data flows.
type DestinationsSpec struct {
	// Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`

	// List of Log Analytics destinations.
	LogAnalytics []*LogAnalyticsDestination `json:"logAnalytics,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DestinationsSpec.
func (d DestinationsSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureMonitorMetrics", d.AzureMonitorMetrics)
	populate(objectMap, "logAnalytics", d.LogAnalytics)
	return json.Marshal(objectMap)
}

// DestinationsSpecAzureMonitorMetrics - Azure Monitor Metrics destination.
type DestinationsSpecAzureMonitorMetrics struct {
	// A friendly name for the destination. This name should be unique across all destinations (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`
}

// DiagnosticSettings - The diagnostic settings.
type DiagnosticSettings struct {
	// The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`

	// The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`

	// A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics,
	// or use a destination type constructed as follows: _. Possible values are:
	// Dedicated and null (null is default.)
	LogAnalyticsDestinationType *string `json:"logAnalyticsDestinationType,omitempty"`

	// The list of logs settings.
	Logs []*LogSettings `json:"logs,omitempty"`

	// The list of metric settings.
	Metrics []*MetricSettings `json:"metrics,omitempty"`

	// The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`

	// The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example:
	// /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticSettings.
func (d DiagnosticSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eventHubAuthorizationRuleId", d.EventHubAuthorizationRuleID)
	populate(objectMap, "eventHubName", d.EventHubName)
	populate(objectMap, "logAnalyticsDestinationType", d.LogAnalyticsDestinationType)
	populate(objectMap, "logs", d.Logs)
	populate(objectMap, "metrics", d.Metrics)
	populate(objectMap, "serviceBusRuleId", d.ServiceBusRuleID)
	populate(objectMap, "storageAccountId", d.StorageAccountID)
	populate(objectMap, "workspaceId", d.WorkspaceID)
	return json.Marshal(objectMap)
}

// DiagnosticSettingsCategory - The diagnostic settings Category.
type DiagnosticSettingsCategory struct {
	// The type of the diagnostic settings category.
	CategoryType *CategoryType `json:"categoryType,omitempty"`
}

// DiagnosticSettingsCategoryClientGetOptions contains the optional parameters for the DiagnosticSettingsCategoryClient.Get
// method.
type DiagnosticSettingsCategoryClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsCategoryClientListOptions contains the optional parameters for the DiagnosticSettingsCategoryClient.List
// method.
type DiagnosticSettingsCategoryClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsCategoryResource - The diagnostic settings category resource.
type DiagnosticSettingsCategoryResource struct {
	// The properties of a Diagnostic Settings Category.
	Properties *DiagnosticSettingsCategory `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticSettingsCategoryResourceCollection - Represents a collection of diagnostic setting category resources.
type DiagnosticSettingsCategoryResourceCollection struct {
	// The collection of diagnostic settings category resources.
	Value []*DiagnosticSettingsCategoryResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticSettingsCategoryResourceCollection.
func (d DiagnosticSettingsCategoryResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// DiagnosticSettingsClientCreateOrUpdateOptions contains the optional parameters for the DiagnosticSettingsClient.CreateOrUpdate
// method.
type DiagnosticSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientDeleteOptions contains the optional parameters for the DiagnosticSettingsClient.Delete method.
type DiagnosticSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientGetOptions contains the optional parameters for the DiagnosticSettingsClient.Get method.
type DiagnosticSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientListOptions contains the optional parameters for the DiagnosticSettingsClient.List method.
type DiagnosticSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsResource - The diagnostic setting resource.
type DiagnosticSettingsResource struct {
	// Properties of a Diagnostic Settings Resource.
	Properties *DiagnosticSettings `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticSettingsResourceCollection - Represents a collection of alert rule resources.
type DiagnosticSettingsResourceCollection struct {
	// The collection of diagnostic settings resources;.
	Value []*DiagnosticSettingsResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticSettingsResourceCollection.
func (d DiagnosticSettingsResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// Dimension - Specifies the criteria for converting log to metric.
type Dimension struct {
	// REQUIRED; Name of the dimension
	Name *string `json:"name,omitempty"`

	// REQUIRED; Operator for dimension values
	Operator *Operator `json:"operator,omitempty"`

	// REQUIRED; List of dimension values
	Values []*string `json:"values,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	populate(objectMap, "operator", d.Operator)
	populate(objectMap, "values", d.Values)
	return json.Marshal(objectMap)
}

// DynamicMetricCriteria - Criterion for dynamic threshold.
type DynamicMetricCriteria struct {
	// REQUIRED; The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric
	// series pattern.
	AlertSensitivity *DynamicThresholdSensitivity `json:"alertSensitivity,omitempty"`

	// REQUIRED; Specifies the type of threshold criteria
	CriterionType *CriterionType `json:"criterionType,omitempty"`

	// REQUIRED; The minimum number of violations required within the selected lookback time window required to raise an alert.
	FailingPeriods *DynamicThresholdFailingPeriods `json:"failingPeriods,omitempty"`

	// REQUIRED; Name of the metric.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; Name of the criteria.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The operator used to compare the metric value against the threshold.
	Operator *DynamicThresholdOperator `json:"operator,omitempty"`

	// REQUIRED; the criteria time aggregation types.
	TimeAggregation *AggregationTypeEnum `json:"timeAggregation,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}

	// List of dimension conditions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds
	// (in ISO8601 format)
	IgnoreDataBefore *time.Time `json:"ignoreDataBefore,omitempty"`

	// Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
}

// GetMultiMetricCriteria implements the MultiMetricCriteriaClassification interface for type DynamicMetricCriteria.
func (d *DynamicMetricCriteria) GetMultiMetricCriteria() *MultiMetricCriteria {
	return &MultiMetricCriteria{
		CriterionType:        d.CriterionType,
		Name:                 d.Name,
		MetricName:           d.MetricName,
		MetricNamespace:      d.MetricNamespace,
		TimeAggregation:      d.TimeAggregation,
		Dimensions:           d.Dimensions,
		SkipMetricValidation: d.SkipMetricValidation,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// MarshalJSON implements the json.Marshaller interface for type DynamicMetricCriteria.
func (d DynamicMetricCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertSensitivity", d.AlertSensitivity)
	objectMap["criterionType"] = CriterionTypeDynamicThresholdCriterion
	populate(objectMap, "dimensions", d.Dimensions)
	populate(objectMap, "failingPeriods", d.FailingPeriods)
	populateTimeRFC3339(objectMap, "ignoreDataBefore", d.IgnoreDataBefore)
	populate(objectMap, "metricName", d.MetricName)
	populate(objectMap, "metricNamespace", d.MetricNamespace)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "operator", d.Operator)
	populate(objectMap, "skipMetricValidation", d.SkipMetricValidation)
	populate(objectMap, "timeAggregation", d.TimeAggregation)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicMetricCriteria.
func (d *DynamicMetricCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertSensitivity":
			err = unpopulate(val, &d.AlertSensitivity)
			delete(rawMsg, key)
		case "criterionType":
			err = unpopulate(val, &d.CriterionType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, &d.Dimensions)
			delete(rawMsg, key)
		case "failingPeriods":
			err = unpopulate(val, &d.FailingPeriods)
			delete(rawMsg, key)
		case "ignoreDataBefore":
			err = unpopulateTimeRFC3339(val, &d.IgnoreDataBefore)
			delete(rawMsg, key)
		case "metricName":
			err = unpopulate(val, &d.MetricName)
			delete(rawMsg, key)
		case "metricNamespace":
			err = unpopulate(val, &d.MetricNamespace)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &d.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, &d.Operator)
			delete(rawMsg, key)
		case "skipMetricValidation":
			err = unpopulate(val, &d.SkipMetricValidation)
			delete(rawMsg, key)
		case "timeAggregation":
			err = unpopulate(val, &d.TimeAggregation)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DynamicThresholdFailingPeriods - The minimum number of violations required within the selected lookback time window required
// to raise an alert.
type DynamicThresholdFailingPeriods struct {
	// REQUIRED; The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
	MinFailingPeriodsToAlert *float32 `json:"minFailingPeriodsToAlert,omitempty"`

	// REQUIRED; The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity
	// (windowSize) and the selected number of aggregated points.
	NumberOfEvaluationPeriods *float32 `json:"numberOfEvaluationPeriods,omitempty"`
}

// EmailNotification - Email notification of an autoscale event.
type EmailNotification struct {
	// the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
	CustomEmails []*string `json:"customEmails,omitempty"`

	// a value indicating whether to send email to subscription administrator.
	SendToSubscriptionAdministrator *bool `json:"sendToSubscriptionAdministrator,omitempty"`

	// a value indicating whether to send email to subscription co-administrators.
	SendToSubscriptionCoAdministrators *bool `json:"sendToSubscriptionCoAdministrators,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type EmailNotification.
func (e EmailNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customEmails", e.CustomEmails)
	populate(objectMap, "sendToSubscriptionAdministrator", e.SendToSubscriptionAdministrator)
	populate(objectMap, "sendToSubscriptionCoAdministrators", e.SendToSubscriptionCoAdministrators)
	return json.Marshal(objectMap)
}

// EmailReceiver - An email receiver.
type EmailReceiver struct {
	// REQUIRED; The email address of this receiver.
	EmailAddress *string `json:"emailAddress,omitempty"`

	// REQUIRED; The name of the email receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`

	// READ-ONLY; The receiver status of the e-mail.
	Status *ReceiverStatus `json:"status,omitempty" azure:"ro"`
}

// EnableRequest - Describes a receiver that should be resubscribed.
type EnableRequest struct {
	// REQUIRED; The name of the receiver to resubscribe.
	ReceiverName *string `json:"receiverName,omitempty"`
}

// Error details.
type Error struct {
	// REQUIRED; Error code identifying the specific error.
	Code *string `json:"code,omitempty"`

	// Error message in the caller's locale.
	Message *string `json:"message,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info map[string]interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorContract - Describes the format of Error response.
type ErrorContract struct {
	// The error details.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponseAutoGenerated - The error response.
type ErrorResponseAutoGenerated struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponseCommon - The resource management error response.
type ErrorResponseCommon struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`

	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponseCommon `json:"details,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseCommon.
func (e ErrorResponseCommon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// ErrorResponseCommonV2 - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponseCommonV2 struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EventCategoriesClientListOptions contains the optional parameters for the EventCategoriesClient.List method.
type EventCategoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// EventCategoryCollection - A collection of event categories. Currently possible values are: Administrative, Security, ServiceHealth,
// Alert, Recommendation, Policy.
type EventCategoryCollection struct {
	// REQUIRED; the list that includes the Azure event categories.
	Value []*LocalizableString `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type EventCategoryCollection.
func (e EventCategoryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// EventData - The Azure event log entries are of type EventData
type EventData struct {
	// READ-ONLY; The sender authorization information.
	Authorization *SenderAuthorization `json:"authorization,omitempty" azure:"ro"`

	// READ-ONLY; the email address of the user who has performed the operation, the UPN claim or SPN claim based on availability.
	Caller *string `json:"caller,omitempty" azure:"ro"`

	// READ-ONLY; the event category.
	Category *LocalizableString `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; key value pairs to identify ARM permissions.
	Claims map[string]*string `json:"claims,omitempty" azure:"ro"`

	// READ-ONLY; the correlation Id, usually a GUID in the string format. The correlation Id is shared among the events that
	// belong to the same uber operation.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; the description of the event.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; the event data Id. This is a unique identifier for an event.
	EventDataID *string `json:"eventDataId,omitempty" azure:"ro"`

	// READ-ONLY; the event name. This value should not be confused with OperationName. For practical purposes, OperationName
	// might be more appealing to end users.
	EventName *LocalizableString `json:"eventName,omitempty" azure:"ro"`

	// READ-ONLY; the timestamp of when the event was generated by the Azure service processing the request corresponding the
	// event. It in ISO 8601 format.
	EventTimestamp *time.Time `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; the HTTP request info. Usually includes the 'clientRequestId', 'clientIpAddress' (IP address of the user who
	// initiated the event) and 'method' (HTTP method e.g. PUT).
	HTTPRequest *HTTPRequestInfo `json:"httpRequest,omitempty" azure:"ro"`

	// READ-ONLY; the Id of this event as required by ARM for RBAC. It contains the EventDataID and a timestamp information.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; the event level
	Level *EventLevel `json:"level,omitempty" azure:"ro"`

	// READ-ONLY; It is usually a GUID shared among the events corresponding to single operation. This value should not be confused
	// with EventName.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`

	// READ-ONLY; the operation name.
	OperationName *LocalizableString `json:"operationName,omitempty" azure:"ro"`

	// READ-ONLY; the set of pairs (usually a Dictionary) that includes details about the event.
	Properties map[string]*string `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; the resource group name of the impacted resource.
	ResourceGroupName *string `json:"resourceGroupName,omitempty" azure:"ro"`

	// READ-ONLY; the resource uri that uniquely identifies the resource that caused this event.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; the resource provider name of the impacted resource.
	ResourceProviderName *LocalizableString `json:"resourceProviderName,omitempty" azure:"ro"`

	// READ-ONLY; the resource type
	ResourceType *LocalizableString `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; a string describing the status of the operation. Some typical values are: Started, In progress, Succeeded, Failed,
	// Resolved.
	Status *LocalizableString `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; the event sub status. Most of the time, when included, this captures the HTTP status code of the REST call.
	// Common values are: OK (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted
	// (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code: 400), Not Found (HTTP Status
	// Code: 404), Conflict (HTTP Status Code: 409), Internal Server Error (HTTP Status
	// Code: 500), Service Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504)
	SubStatus *LocalizableString `json:"subStatus,omitempty" azure:"ro"`

	// READ-ONLY; the timestamp of when the event became available for querying via this API. It is in ISO 8601 format. This value
	// should not be confused eventTimestamp. As there might be a delay between the occurrence
	// time of the event, and the time that the event is submitted to the Azure logging infrastructure.
	SubmissionTimestamp *time.Time `json:"submissionTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; the Azure subscription Id usually a GUID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; the Azure tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type EventData.
func (e EventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorization", e.Authorization)
	populate(objectMap, "caller", e.Caller)
	populate(objectMap, "category", e.Category)
	populate(objectMap, "claims", e.Claims)
	populate(objectMap, "correlationId", e.CorrelationID)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "eventDataId", e.EventDataID)
	populate(objectMap, "eventName", e.EventName)
	populateTimeRFC3339(objectMap, "eventTimestamp", e.EventTimestamp)
	populate(objectMap, "httpRequest", e.HTTPRequest)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "level", e.Level)
	populate(objectMap, "operationId", e.OperationID)
	populate(objectMap, "operationName", e.OperationName)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "resourceGroupName", e.ResourceGroupName)
	populate(objectMap, "resourceId", e.ResourceID)
	populate(objectMap, "resourceProviderName", e.ResourceProviderName)
	populate(objectMap, "resourceType", e.ResourceType)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "subStatus", e.SubStatus)
	populateTimeRFC3339(objectMap, "submissionTimestamp", e.SubmissionTimestamp)
	populate(objectMap, "subscriptionId", e.SubscriptionID)
	populate(objectMap, "tenantId", e.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventData.
func (e *EventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, &e.Authorization)
			delete(rawMsg, key)
		case "caller":
			err = unpopulate(val, &e.Caller)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, &e.Category)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, &e.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, &e.CorrelationID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, &e.Description)
			delete(rawMsg, key)
		case "eventDataId":
			err = unpopulate(val, &e.EventDataID)
			delete(rawMsg, key)
		case "eventName":
			err = unpopulate(val, &e.EventName)
			delete(rawMsg, key)
		case "eventTimestamp":
			err = unpopulateTimeRFC3339(val, &e.EventTimestamp)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, &e.HTTPRequest)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, &e.ID)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, &e.Level)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, &e.OperationID)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, &e.OperationName)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, &e.Properties)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, &e.ResourceGroupName)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, &e.ResourceID)
			delete(rawMsg, key)
		case "resourceProviderName":
			err = unpopulate(val, &e.ResourceProviderName)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, &e.ResourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, &e.Status)
			delete(rawMsg, key)
		case "subStatus":
			err = unpopulate(val, &e.SubStatus)
			delete(rawMsg, key)
		case "submissionTimestamp":
			err = unpopulateTimeRFC3339(val, &e.SubmissionTimestamp)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, &e.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, &e.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// EventDataCollection - Represents collection of events.
type EventDataCollection struct {
	// REQUIRED; this list that includes the Azure audit logs.
	Value []*EventData `json:"value,omitempty"`

	// Provides the link to retrieve the next set of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type EventDataCollection.
func (e EventDataCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// EventHubReceiver - An Event hub receiver.
type EventHubReceiver struct {
	// REQUIRED; The name of the specific Event Hub queue
	EventHubName *string `json:"eventHubName,omitempty"`

	// REQUIRED; The Event Hub namespace
	EventHubNameSpace *string `json:"eventHubNameSpace,omitempty"`

	// REQUIRED; The name of the Event hub receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The Id for the subscription containing this event hub
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The tenant Id for the subscription containing this event hub
	TenantID *string `json:"tenantId,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// ExtensionDataSource - Definition of which data will be collected from a separate VM extension that integrates with the
// Azure Monitor Agent. Collected from either Windows and Linux machines, depending on which extension is
// defined.
type ExtensionDataSource struct {
	// REQUIRED; The name of the VM extension.
	ExtensionName *string `json:"extensionName,omitempty"`

	// The extension settings. The format is specific for particular extension.
	ExtensionSettings map[string]interface{} `json:"extensionSettings,omitempty"`

	// The list of data sources this extension needs data from.
	InputDataSources []*string `json:"inputDataSources,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownExtensionDataSourceStreams `json:"streams,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ExtensionDataSource.
func (e ExtensionDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extensionName", e.ExtensionName)
	populate(objectMap, "extensionSettings", e.ExtensionSettings)
	populate(objectMap, "inputDataSources", e.InputDataSources)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "streams", e.Streams)
	return json.Marshal(objectMap)
}

// HTTPRequestInfo - The Http request info.
type HTTPRequestInfo struct {
	// the client Ip Address
	ClientIPAddress *string `json:"clientIpAddress,omitempty"`

	// the client request id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`

	// the Http request method.
	Method *string `json:"method,omitempty"`

	// the Uri.
	URI *string `json:"uri,omitempty"`
}

// Incident - An alert incident indicates the activation status of an alert rule.
type Incident struct {
	// READ-ONLY; The time at which the incident was activated in ISO8601 format.
	ActivatedTime *time.Time `json:"activatedTime,omitempty" azure:"ro"`

	// READ-ONLY; A boolean to indicate whether the incident is active or resolved.
	IsActive *bool `json:"isActive,omitempty" azure:"ro"`

	// READ-ONLY; Incident name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active.
	ResolvedTime *time.Time `json:"resolvedTime,omitempty" azure:"ro"`

	// READ-ONLY; Rule name that is associated with the incident.
	RuleName *string `json:"ruleName,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "activatedTime", i.ActivatedTime)
	populate(objectMap, "isActive", i.IsActive)
	populate(objectMap, "name", i.Name)
	populateTimeRFC3339(objectMap, "resolvedTime", i.ResolvedTime)
	populate(objectMap, "ruleName", i.RuleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Incident.
func (i *Incident) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activatedTime":
			err = unpopulateTimeRFC3339(val, &i.ActivatedTime)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, &i.IsActive)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &i.Name)
			delete(rawMsg, key)
		case "resolvedTime":
			err = unpopulateTimeRFC3339(val, &i.ResolvedTime)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, &i.RuleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// IncidentListResult - The List incidents operation response.
type IncidentListResult struct {
	// the incident collection.
	Value []*Incident `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type IncidentListResult.
func (i IncidentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// ItsmReceiver - An Itsm receiver.
type ItsmReceiver struct {
	// REQUIRED; Unique identification of ITSM connection among multiple defined in above workspace.
	ConnectionID *string `json:"connectionId,omitempty"`

	// REQUIRED; The name of the Itsm receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
	Region *string `json:"region,omitempty"`

	// REQUIRED; JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob
	// as well.
	TicketConfiguration *string `json:"ticketConfiguration,omitempty"`

	// REQUIRED; OMS LA instance identifier.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// LocalizableString - The localizable string class.
type LocalizableString struct {
	// REQUIRED; the invariant value.
	Value *string `json:"value,omitempty"`

	// the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// LocationThresholdRuleCondition - A rule condition based on a certain number of locations failing.
type LocationThresholdRuleCondition struct {
	// REQUIRED; the number of locations that must fail to activate the alert.
	FailedLocationCount *int32 `json:"failedLocationCount,omitempty"`

	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified
	// then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type LocationThresholdRuleCondition.
func (l *LocationThresholdRuleCondition) GetRuleCondition() *RuleCondition {
	return &RuleCondition{
		ODataType:  l.ODataType,
		DataSource: l.DataSource,
	}
}

// MarshalJSON implements the json.Marshaller interface for type LocationThresholdRuleCondition.
func (l LocationThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataSource", l.DataSource)
	populate(objectMap, "failedLocationCount", l.FailedLocationCount)
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
	populate(objectMap, "windowSize", l.WindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocationThresholdRuleCondition.
func (l *LocationThresholdRuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			l.DataSource, err = unmarshalRuleDataSourceClassification(val)
			delete(rawMsg, key)
		case "failedLocationCount":
			err = unpopulate(val, &l.FailedLocationCount)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &l.ODataType)
			delete(rawMsg, key)
		case "windowSize":
			err = unpopulate(val, &l.WindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// LogAnalyticsDestination - Log Analytics destination.
type LogAnalyticsDestination struct {
	// A friendly name for the destination. This name should be unique across all destinations (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// The resource ID of the Log Analytics workspace.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`

	// READ-ONLY; The Customer ID of the Log Analytics workspace.
	WorkspaceID *string `json:"workspaceId,omitempty" azure:"ro"`
}

// LogMetricTrigger - A log metrics trigger descriptor.
type LogMetricTrigger struct {
	// Evaluation of metric on a particular column
	MetricColumn *string `json:"metricColumn,omitempty"`

	// Metric Trigger Type - 'Consecutive' or 'Total'
	MetricTriggerType *MetricTriggerType `json:"metricTriggerType,omitempty"`

	// The threshold of the metric trigger.
	Threshold *float64 `json:"threshold,omitempty"`

	// Evaluation operation for Metric -'GreaterThan' or 'LessThan' or 'Equal'.
	ThresholdOperator *ConditionalOperator `json:"thresholdOperator,omitempty"`
}

// LogProfileCollection - Represents a collection of log profiles.
type LogProfileCollection struct {
	// REQUIRED; the values of the log profiles.
	Value []*LogProfileResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type LogProfileCollection.
func (l LogProfileCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// LogProfileProperties - The log profile properties.
type LogProfileProperties struct {
	// REQUIRED; the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write',
	// 'Delete', and/or 'Action.'
	Categories []*string `json:"categories,omitempty"`

	// REQUIRED; List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid
	// ARM locations including the 'global' location.
	Locations []*string `json:"locations,omitempty"`

	// REQUIRED; the retention policy for the events in the log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`

	// The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the
	// Activity Log. The rule ID is of the format: '{service bus resource
	// ID}/authorizationrules/{key name}'.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`

	// the resource id of the storage account to which you would like to send the Activity Log.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type LogProfileProperties.
func (l LogProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "categories", l.Categories)
	populate(objectMap, "locations", l.Locations)
	populate(objectMap, "retentionPolicy", l.RetentionPolicy)
	populate(objectMap, "serviceBusRuleId", l.ServiceBusRuleID)
	populate(objectMap, "storageAccountId", l.StorageAccountID)
	return json.Marshal(objectMap)
}

// LogProfileResource - The log profile resource.
type LogProfileResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The log profile properties of the resource.
	Properties *LogProfileProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type LogProfileResource.
func (l LogProfileResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// LogProfileResourcePatch - The log profile resource for patch operations.
type LogProfileResourcePatch struct {
	// The log profile properties for an update operation.
	Properties *LogProfileProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type LogProfileResourcePatch.
func (l LogProfileResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// LogProfilesClientCreateOrUpdateOptions contains the optional parameters for the LogProfilesClient.CreateOrUpdate method.
type LogProfilesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientDeleteOptions contains the optional parameters for the LogProfilesClient.Delete method.
type LogProfilesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientGetOptions contains the optional parameters for the LogProfilesClient.Get method.
type LogProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientListOptions contains the optional parameters for the LogProfilesClient.List method.
type LogProfilesClientListOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientUpdateOptions contains the optional parameters for the LogProfilesClient.Update method.
type LogProfilesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// LogSearchRule - Log Search Rule Definition
type LogSearchRule struct {
	// REQUIRED; Action needs to be taken on rule execution.
	Action ActionClassification `json:"action,omitempty"`

	// REQUIRED; Data Source against which rule will Query Data
	Source *Source `json:"source,omitempty"`

	// The flag that indicates whether the alert should be automatically resolved or not. The default is false.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`

	// The description of the Log Search rule.
	Description *string `json:"description,omitempty"`

	// The display name of the alert rule
	DisplayName *string `json:"displayName,omitempty"`

	// The flag which indicates whether the Log Search rule is enabled. Value should be true or false
	Enabled *Enabled `json:"enabled,omitempty"`

	// Schedule (Frequency, Time Window) for rule. Required for action type - AlertingAction
	Schedule *Schedule `json:"schedule,omitempty"`

	// READ-ONLY; The api-version used when creating this alert rule
	CreatedWithAPIVersion *string `json:"createdWithApiVersion,omitempty" azure:"ro"`

	// READ-ONLY; True if alert rule is legacy Log Analytic rule
	IsLegacyLogAnalyticsRule *bool `json:"isLegacyLogAnalyticsRule,omitempty" azure:"ro"`

	// READ-ONLY; Last time the rule was updated in IS08601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the scheduled query rule
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type LogSearchRule.
func (l LogSearchRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", l.Action)
	populate(objectMap, "autoMitigate", l.AutoMitigate)
	populate(objectMap, "createdWithApiVersion", l.CreatedWithAPIVersion)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "enabled", l.Enabled)
	populate(objectMap, "isLegacyLogAnalyticsRule", l.IsLegacyLogAnalyticsRule)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", l.LastUpdatedTime)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "schedule", l.Schedule)
	populate(objectMap, "source", l.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSearchRule.
func (l *LogSearchRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			l.Action, err = unmarshalActionClassification(val)
			delete(rawMsg, key)
		case "autoMitigate":
			err = unpopulate(val, &l.AutoMitigate)
			delete(rawMsg, key)
		case "createdWithApiVersion":
			err = unpopulate(val, &l.CreatedWithAPIVersion)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, &l.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, &l.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &l.Enabled)
			delete(rawMsg, key)
		case "isLegacyLogAnalyticsRule":
			err = unpopulate(val, &l.IsLegacyLogAnalyticsRule)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, &l.LastUpdatedTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, &l.ProvisioningState)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, &l.Schedule)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, &l.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// LogSearchRulePatch - Log Search Rule Definition for Patching
type LogSearchRulePatch struct {
	// The flag which indicates whether the Log Search rule is enabled. Value should be true or false
	Enabled *Enabled `json:"enabled,omitempty"`
}

// LogSearchRuleResource - The Log Search Rule resource.
type LogSearchRuleResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The rule properties of the resource.
	Properties *LogSearchRule `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g.
	// ApiApps are a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type LogSearchRuleResource.
func (l LogSearchRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "kind", l.Kind)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// LogSearchRuleResourceCollection - Represents a collection of Log Search rule resources.
type LogSearchRuleResourceCollection struct {
	// The values for the Log Search Rule resources.
	Value []*LogSearchRuleResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type LogSearchRuleResourceCollection.
func (l LogSearchRuleResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// LogSearchRuleResourcePatch - The log search rule resource for patch operations.
type LogSearchRuleResourcePatch struct {
	// The log search rule properties of the resource.
	Properties *LogSearchRulePatch `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type LogSearchRuleResourcePatch.
func (l LogSearchRuleResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// LogSettings - Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	// REQUIRED; a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log
	// categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`

	// the retention policy for this log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogToMetricAction - Specify action need to be taken when rule type is converting log to metric
type LogToMetricAction struct {
	// REQUIRED; Criteria of Metric
	Criteria []*Criteria `json:"criteria,omitempty"`

	// REQUIRED; Specifies the action. Supported values - AlertingAction, LogToMetricAction
	ODataType *string `json:"odata.type,omitempty"`
}

// GetAction implements the ActionClassification interface for type LogToMetricAction.
func (l *LogToMetricAction) GetAction() *Action {
	return &Action{
		ODataType: l.ODataType,
	}
}

// MarshalJSON implements the json.Marshaller interface for type LogToMetricAction.
func (l LogToMetricAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "criteria", l.Criteria)
	objectMap["odata.type"] = "Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogToMetricAction.
func (l *LogToMetricAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "criteria":
			err = unpopulate(val, &l.Criteria)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &l.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// LogicAppReceiver - A logic app receiver.
type LogicAppReceiver struct {
	// REQUIRED; The callback url where http request sent to.
	CallbackURL *string `json:"callbackUrl,omitempty"`

	// REQUIRED; The name of the logic app receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The azure resource id of the logic app receiver.
	ResourceID *string `json:"resourceId,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// LogsIngestionEndpointSpec - Definition of the endpoint used for ingesting logs.
type LogsIngestionEndpointSpec struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// ManagementEventAggregationCondition - How the data that is collected should be combined over time.
type ManagementEventAggregationCondition struct {
	// the condition operator.
	Operator *ConditionOperator `json:"operator,omitempty"`

	// The threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified
	// then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// ManagementEventRuleCondition - A management event rule condition.
type ManagementEventRuleCondition struct {
	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// How the data that is collected should be combined over time and when the alert is activated. Note that for management event
	// alerts aggregation is optional – if it is not provided then any event will
	// cause the alert to activate.
	Aggregation *ManagementEventAggregationCondition `json:"aggregation,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type ManagementEventRuleCondition.
func (m *ManagementEventRuleCondition) GetRuleCondition() *RuleCondition {
	return &RuleCondition{
		ODataType:  m.ODataType,
		DataSource: m.DataSource,
	}
}

// MarshalJSON implements the json.Marshaller interface for type ManagementEventRuleCondition.
func (m ManagementEventRuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregation", m.Aggregation)
	populate(objectMap, "dataSource", m.DataSource)
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementEventRuleCondition.
func (m *ManagementEventRuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregation":
			err = unpopulate(val, &m.Aggregation)
			delete(rawMsg, key)
		case "dataSource":
			m.DataSource, err = unmarshalRuleDataSourceClassification(val)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &m.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetadataValue - Represents a metric metadata value.
type MetadataValue struct {
	// the name of the metadata.
	Name *LocalizableString `json:"name,omitempty"`

	// the value of the metadata.
	Value *string `json:"value,omitempty"`
}

// Metric - The result data of a query.
type Metric struct {
	// REQUIRED; the metric Id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; the name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString `json:"name,omitempty"`

	// REQUIRED; the time series returned when a data query is performed.
	Timeseries []*TimeSeriesElement `json:"timeseries,omitempty"`

	// REQUIRED; the resource type of the metric resource.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The unit of the metric.
	Unit *MetricUnit `json:"unit,omitempty"`

	// Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// 'Success' or the error details on query failures for this metric.
	ErrorCode *string `json:"errorCode,omitempty"`

	// Error message encountered querying this specific metric.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Metric.
func (m Metric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "errorCode", m.ErrorCode)
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "timeseries", m.Timeseries)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// MetricAlertAction - An alert action.
type MetricAlertAction struct {
	// the id of the action group to use.
	ActionGroupID *string `json:"actionGroupId,omitempty"`

	// This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
	WebHookProperties map[string]*string `json:"webHookProperties,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertAction.
func (m MetricAlertAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionGroupId", m.ActionGroupID)
	populate(objectMap, "webHookProperties", m.WebHookProperties)
	return json.Marshal(objectMap)
}

// MetricAlertCriteriaClassification provides polymorphic access to related types.
// Call the interface's GetMetricAlertCriteria() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MetricAlertCriteria, *MetricAlertMultipleResourceMultipleMetricCriteria, *MetricAlertSingleResourceMultipleMetricCriteria,
// - *WebtestLocationAvailabilityCriteria
type MetricAlertCriteriaClassification interface {
	// GetMetricAlertCriteria returns the MetricAlertCriteria content of the underlying type.
	GetMetricAlertCriteria() *MetricAlertCriteria
}

// MetricAlertCriteria - The rule criteria that defines the conditions of the alert rule.
type MetricAlertCriteria struct {
	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type MetricAlertCriteria.
func (m *MetricAlertCriteria) GetMetricAlertCriteria() *MetricAlertCriteria { return m }

// MarshalJSON implements the json.Marshaller interface for type MetricAlertCriteria.
func (m MetricAlertCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["odata.type"] = m.ODataType
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAlertCriteria.
func (m *MetricAlertCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "odata.type":
			err = unpopulate(val, &m.ODataType)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricAlertMultipleResourceMultipleMetricCriteria - Specifies the metric alert criteria for multiple resource that has
// multiple metric criteria.
type MetricAlertMultipleResourceMultipleMetricCriteria struct {
	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}

	// the list of multiple metric criteria for this 'all of' operation.
	AllOf []MultiMetricCriteriaClassification `json:"allOf,omitempty"`
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type MetricAlertMultipleResourceMultipleMetricCriteria.
func (m *MetricAlertMultipleResourceMultipleMetricCriteria) GetMetricAlertCriteria() *MetricAlertCriteria {
	return &MetricAlertCriteria{
		ODataType:            m.ODataType,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertMultipleResourceMultipleMetricCriteria.
func (m MetricAlertMultipleResourceMultipleMetricCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allOf", m.AllOf)
	objectMap["odata.type"] = OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAlertMultipleResourceMultipleMetricCriteria.
func (m *MetricAlertMultipleResourceMultipleMetricCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allOf":
			m.AllOf, err = unmarshalMultiMetricCriteriaClassificationArray(val)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &m.ODataType)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricAlertProperties - An alert rule.
type MetricAlertProperties struct {
	// REQUIRED; defines the specific alert criteria information.
	Criteria MetricAlertCriteriaClassification `json:"criteria,omitempty"`

	// REQUIRED; the flag that indicates whether the metric alert is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; how often the metric alert is evaluated represented in ISO 8601 duration format.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`

	// REQUIRED; the list of resource id's that this metric alert is scoped to.
	Scopes []*string `json:"scopes,omitempty"`

	// REQUIRED; Alert severity {0, 1, 2, 3, 4}
	Severity *int32 `json:"severity,omitempty"`

	// REQUIRED; the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
	WindowSize *string `json:"windowSize,omitempty"`

	// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions []*MetricAlertAction `json:"actions,omitempty"`

	// the flag that indicates whether the alert should be auto resolved or not. The default is true.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`

	// the description of the metric alert that will be included in the alert email.
	Description *string `json:"description,omitempty"`

	// the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription,
	// resource group, or more than one resource.
	TargetResourceRegion *string `json:"targetResourceRegion,omitempty"`

	// the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription,
	// resource group, or more than one resource.
	TargetResourceType *string `json:"targetResourceType,omitempty"`

	// READ-ONLY; the value indicating whether this alert rule is migrated.
	IsMigrated *bool `json:"isMigrated,omitempty" azure:"ro"`

	// READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertProperties.
func (m MetricAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", m.Actions)
	populate(objectMap, "autoMitigate", m.AutoMitigate)
	populate(objectMap, "criteria", m.Criteria)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "evaluationFrequency", m.EvaluationFrequency)
	populate(objectMap, "isMigrated", m.IsMigrated)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", m.LastUpdatedTime)
	populate(objectMap, "scopes", m.Scopes)
	populate(objectMap, "severity", m.Severity)
	populate(objectMap, "targetResourceRegion", m.TargetResourceRegion)
	populate(objectMap, "targetResourceType", m.TargetResourceType)
	populate(objectMap, "windowSize", m.WindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAlertProperties.
func (m *MetricAlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, &m.Actions)
			delete(rawMsg, key)
		case "autoMitigate":
			err = unpopulate(val, &m.AutoMitigate)
			delete(rawMsg, key)
		case "criteria":
			m.Criteria, err = unmarshalMetricAlertCriteriaClassification(val)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, &m.Description)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &m.Enabled)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, &m.EvaluationFrequency)
			delete(rawMsg, key)
		case "isMigrated":
			err = unpopulate(val, &m.IsMigrated)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, &m.LastUpdatedTime)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, &m.Scopes)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, &m.Severity)
			delete(rawMsg, key)
		case "targetResourceRegion":
			err = unpopulate(val, &m.TargetResourceRegion)
			delete(rawMsg, key)
		case "targetResourceType":
			err = unpopulate(val, &m.TargetResourceType)
			delete(rawMsg, key)
		case "windowSize":
			err = unpopulate(val, &m.WindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricAlertPropertiesPatch - An alert rule properties for patch.
type MetricAlertPropertiesPatch struct {
	// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions []*MetricAlertAction `json:"actions,omitempty"`

	// the flag that indicates whether the alert should be auto resolved or not. The default is true.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`

	// defines the specific alert criteria information.
	Criteria MetricAlertCriteriaClassification `json:"criteria,omitempty"`

	// the description of the metric alert that will be included in the alert email.
	Description *string `json:"description,omitempty"`

	// the flag that indicates whether the metric alert is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// how often the metric alert is evaluated represented in ISO 8601 duration format.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`

	// the list of resource id's that this metric alert is scoped to.
	Scopes []*string `json:"scopes,omitempty"`

	// Alert severity {0, 1, 2, 3, 4}
	Severity *int32 `json:"severity,omitempty"`

	// the region of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
	TargetResourceRegion *string `json:"targetResourceRegion,omitempty"`

	// the resource type of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
	TargetResourceType *string `json:"targetResourceType,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
	WindowSize *string `json:"windowSize,omitempty"`

	// READ-ONLY; the value indicating whether this alert rule is migrated.
	IsMigrated *bool `json:"isMigrated,omitempty" azure:"ro"`

	// READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertPropertiesPatch.
func (m MetricAlertPropertiesPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", m.Actions)
	populate(objectMap, "autoMitigate", m.AutoMitigate)
	populate(objectMap, "criteria", m.Criteria)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "evaluationFrequency", m.EvaluationFrequency)
	populate(objectMap, "isMigrated", m.IsMigrated)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", m.LastUpdatedTime)
	populate(objectMap, "scopes", m.Scopes)
	populate(objectMap, "severity", m.Severity)
	populate(objectMap, "targetResourceRegion", m.TargetResourceRegion)
	populate(objectMap, "targetResourceType", m.TargetResourceType)
	populate(objectMap, "windowSize", m.WindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAlertPropertiesPatch.
func (m *MetricAlertPropertiesPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, &m.Actions)
			delete(rawMsg, key)
		case "autoMitigate":
			err = unpopulate(val, &m.AutoMitigate)
			delete(rawMsg, key)
		case "criteria":
			m.Criteria, err = unmarshalMetricAlertCriteriaClassification(val)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, &m.Description)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &m.Enabled)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, &m.EvaluationFrequency)
			delete(rawMsg, key)
		case "isMigrated":
			err = unpopulate(val, &m.IsMigrated)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, &m.LastUpdatedTime)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, &m.Scopes)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, &m.Severity)
			delete(rawMsg, key)
		case "targetResourceRegion":
			err = unpopulate(val, &m.TargetResourceRegion)
			delete(rawMsg, key)
		case "targetResourceType":
			err = unpopulate(val, &m.TargetResourceType)
			delete(rawMsg, key)
		case "windowSize":
			err = unpopulate(val, &m.WindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricAlertResource - The metric alert resource.
type MetricAlertResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The alert rule properties of the resource.
	Properties *MetricAlertProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertResource.
func (m MetricAlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MetricAlertResourceCollection - Represents a collection of alert rule resources.
type MetricAlertResourceCollection struct {
	// the values for the alert rule resources.
	Value []*MetricAlertResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertResourceCollection.
func (m MetricAlertResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// MetricAlertResourcePatch - The metric alert resource for patch operations.
type MetricAlertResourcePatch struct {
	// The alert rule properties of the resource.
	Properties *MetricAlertPropertiesPatch `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertResourcePatch.
func (m MetricAlertResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// MetricAlertSingleResourceMultipleMetricCriteria - Specifies the metric alert criteria for a single resource that has multiple
// metric criteria.
type MetricAlertSingleResourceMultipleMetricCriteria struct {
	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}

	// The list of metric criteria for this 'all of' operation.
	AllOf []*MetricCriteria `json:"allOf,omitempty"`
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type MetricAlertSingleResourceMultipleMetricCriteria.
func (m *MetricAlertSingleResourceMultipleMetricCriteria) GetMetricAlertCriteria() *MetricAlertCriteria {
	return &MetricAlertCriteria{
		ODataType:            m.ODataType,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertSingleResourceMultipleMetricCriteria.
func (m MetricAlertSingleResourceMultipleMetricCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allOf", m.AllOf)
	objectMap["odata.type"] = OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAlertSingleResourceMultipleMetricCriteria.
func (m *MetricAlertSingleResourceMultipleMetricCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allOf":
			err = unpopulate(val, &m.AllOf)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &m.ODataType)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricAlertStatus - An alert status.
type MetricAlertStatus struct {
	// The alert rule arm id.
	ID *string `json:"id,omitempty"`

	// The status name.
	Name *string `json:"name,omitempty"`

	// The alert status properties of the metric alert status.
	Properties *MetricAlertStatusProperties `json:"properties,omitempty"`

	// The extended resource type name.
	Type *string `json:"type,omitempty"`
}

// MetricAlertStatusCollection - Represents a collection of alert rule resources.
type MetricAlertStatusCollection struct {
	// the values for the alert rule resources.
	Value []*MetricAlertStatus `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertStatusCollection.
func (m MetricAlertStatusCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// MetricAlertStatusProperties - An alert status properties.
type MetricAlertStatusProperties struct {
	// An object describing the type of the dimensions.
	Dimensions map[string]*string `json:"dimensions,omitempty"`

	// status value
	Status *string `json:"status,omitempty"`

	// UTC time when the status was checked.
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricAlertStatusProperties.
func (m MetricAlertStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "status", m.Status)
	populateTimeRFC3339(objectMap, "timestamp", m.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAlertStatusProperties.
func (m *MetricAlertStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dimensions":
			err = unpopulate(val, &m.Dimensions)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, &m.Status)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, &m.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricAlertsClientCreateOrUpdateOptions contains the optional parameters for the MetricAlertsClient.CreateOrUpdate method.
type MetricAlertsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientDeleteOptions contains the optional parameters for the MetricAlertsClient.Delete method.
type MetricAlertsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientGetOptions contains the optional parameters for the MetricAlertsClient.Get method.
type MetricAlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientListByResourceGroupOptions contains the optional parameters for the MetricAlertsClient.ListByResourceGroup
// method.
type MetricAlertsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientListBySubscriptionOptions contains the optional parameters for the MetricAlertsClient.ListBySubscription
// method.
type MetricAlertsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientUpdateOptions contains the optional parameters for the MetricAlertsClient.Update method.
type MetricAlertsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsStatusClientListByNameOptions contains the optional parameters for the MetricAlertsStatusClient.ListByName
// method.
type MetricAlertsStatusClientListByNameOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsStatusClientListOptions contains the optional parameters for the MetricAlertsStatusClient.List method.
type MetricAlertsStatusClientListOptions struct {
	// placeholder for future optional parameters
}

// MetricAvailability - Metric availability specifies the time grain (aggregation interval or frequency) and the retention
// period for that time grain.
type MetricAvailability struct {
	// the retention period for the metric at the specified timegrain. Expressed as a duration 'PT1M', 'P1D', etc.
	Retention *string `json:"retention,omitempty"`

	// the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricBaselinesProperties - The response to a metric baselines query.
type MetricBaselinesProperties struct {
	// REQUIRED; The baseline for each time series that was queried.
	Baselines []*TimeSeriesBaseline `json:"baselines,omitempty"`

	// REQUIRED; The interval (window size) for which the metric data was returned in. This may be adjusted in the future and
	// returned back from what was originally requested. This is not present if a metadata request
	// was made.
	Interval *string `json:"interval,omitempty"`

	// REQUIRED; The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
	// '/'. This may be adjusted in the future and returned back from what was originally
	// requested.
	Timespan *string `json:"timespan,omitempty"`

	// The namespace of the metrics been queried.
	Namespace *string `json:"namespace,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricBaselinesProperties.
func (m MetricBaselinesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baselines", m.Baselines)
	populate(objectMap, "interval", m.Interval)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "timespan", m.Timespan)
	return json.Marshal(objectMap)
}

// MetricBaselinesResponse - A list of metric baselines.
type MetricBaselinesResponse struct {
	// The list of metric baselines.
	Value []*SingleMetricBaseline `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricBaselinesResponse.
func (m MetricBaselinesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// MetricCriteria - Criterion to filter metrics.
type MetricCriteria struct {
	// REQUIRED; Specifies the type of threshold criteria
	CriterionType *CriterionType `json:"criterionType,omitempty"`

	// REQUIRED; Name of the metric.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; Name of the criteria.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the criteria operator.
	Operator *Operator `json:"operator,omitempty"`

	// REQUIRED; the criteria threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`

	// REQUIRED; the criteria time aggregation types.
	TimeAggregation *AggregationTypeEnum `json:"timeAggregation,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}

	// List of dimension conditions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
}

// GetMultiMetricCriteria implements the MultiMetricCriteriaClassification interface for type MetricCriteria.
func (m *MetricCriteria) GetMultiMetricCriteria() *MultiMetricCriteria {
	return &MultiMetricCriteria{
		CriterionType:        m.CriterionType,
		Name:                 m.Name,
		MetricName:           m.MetricName,
		MetricNamespace:      m.MetricNamespace,
		TimeAggregation:      m.TimeAggregation,
		Dimensions:           m.Dimensions,
		SkipMetricValidation: m.SkipMetricValidation,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MarshalJSON implements the json.Marshaller interface for type MetricCriteria.
func (m MetricCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["criterionType"] = CriterionTypeStaticThresholdCriterion
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "metricName", m.MetricName)
	populate(objectMap, "metricNamespace", m.MetricNamespace)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "skipMetricValidation", m.SkipMetricValidation)
	populate(objectMap, "threshold", m.Threshold)
	populate(objectMap, "timeAggregation", m.TimeAggregation)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricCriteria.
func (m *MetricCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "criterionType":
			err = unpopulate(val, &m.CriterionType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, &m.Dimensions)
			delete(rawMsg, key)
		case "metricName":
			err = unpopulate(val, &m.MetricName)
			delete(rawMsg, key)
		case "metricNamespace":
			err = unpopulate(val, &m.MetricNamespace)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &m.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, &m.Operator)
			delete(rawMsg, key)
		case "skipMetricValidation":
			err = unpopulate(val, &m.SkipMetricValidation)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, &m.Threshold)
			delete(rawMsg, key)
		case "timeAggregation":
			err = unpopulate(val, &m.TimeAggregation)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricDefinition - Metric definition class specifies the metadata for a metric.
type MetricDefinition struct {
	// Custom category name for this metric.
	Category *string `json:"category,omitempty"`

	// the name and the display name of the dimension, i.e. it is a localizable string.
	Dimensions []*LocalizableString `json:"dimensions,omitempty"`

	// Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// the resource identifier of the metric definition.
	ID *string `json:"id,omitempty"`

	// Flag to indicate whether the dimension is required.
	IsDimensionRequired *bool `json:"isDimensionRequired,omitempty"`

	// the collection of what aggregation intervals are available to be queried.
	MetricAvailabilities []*MetricAvailability `json:"metricAvailabilities,omitempty"`

	// The class of the metric.
	MetricClass *MetricClass `json:"metricClass,omitempty"`

	// the name and the display name of the metric, i.e. it is a localizable string.
	Name *LocalizableString `json:"name,omitempty"`

	// the namespace the metric belongs to.
	Namespace *string `json:"namespace,omitempty"`

	// the primary aggregation type value defining how to use the values for display.
	PrimaryAggregationType *AggregationType `json:"primaryAggregationType,omitempty"`

	// the resource identifier of the resource that emitted the metric.
	ResourceID *string `json:"resourceId,omitempty"`

	// the collection of what aggregation types are supported.
	SupportedAggregationTypes []*AggregationType `json:"supportedAggregationTypes,omitempty"`

	// The unit of the metric.
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricDefinition.
func (m MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "isDimensionRequired", m.IsDimensionRequired)
	populate(objectMap, "metricAvailabilities", m.MetricAvailabilities)
	populate(objectMap, "metricClass", m.MetricClass)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "primaryAggregationType", m.PrimaryAggregationType)
	populate(objectMap, "resourceId", m.ResourceID)
	populate(objectMap, "supportedAggregationTypes", m.SupportedAggregationTypes)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// MetricDefinitionCollection - Represents collection of metric definitions.
type MetricDefinitionCollection struct {
	// REQUIRED; the values for the metric definitions.
	Value []*MetricDefinition `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricDefinitionCollection.
func (m MetricDefinitionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// MetricDefinitionsClientListOptions contains the optional parameters for the MetricDefinitionsClient.List method.
type MetricDefinitionsClientListOptions struct {
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
}

// MetricDimension - Specifies a metric dimension.
type MetricDimension struct {
	// REQUIRED; Name of the dimension.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the dimension operator. Only 'Include' and 'Exclude' are supported
	Operator *string `json:"operator,omitempty"`

	// REQUIRED; list of dimension values.
	Values []*string `json:"values,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricDimension.
func (m MetricDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", m.Name)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "values", m.Values)
	return json.Marshal(objectMap)
}

// MetricNamespace - Metric namespace class specifies the metadata for a metric namespace.
type MetricNamespace struct {
	// Kind of namespace
	Classification *NamespaceClassification `json:"classification,omitempty"`

	// The ID of the metric namespace.
	ID *string `json:"id,omitempty"`

	// The escaped name of the namespace.
	Name *string `json:"name,omitempty"`

	// Properties which include the fully qualified namespace name.
	Properties *MetricNamespaceName `json:"properties,omitempty"`

	// The type of the namespace.
	Type *string `json:"type,omitempty"`
}

// MetricNamespaceCollection - Represents collection of metric namespaces.
type MetricNamespaceCollection struct {
	// REQUIRED; The values for the metric namespaces.
	Value []*MetricNamespace `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricNamespaceCollection.
func (m MetricNamespaceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// MetricNamespaceName - The fully qualified metric namespace name.
type MetricNamespaceName struct {
	// The metric namespace name.
	MetricNamespaceName *string `json:"metricNamespaceName,omitempty"`
}

// MetricNamespacesClientListOptions contains the optional parameters for the MetricNamespacesClient.List method.
type MetricNamespacesClientListOptions struct {
	// The ISO 8601 conform Date start time from which to query for metric namespaces.
	StartTime *string
}

// MetricSettings - Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	// REQUIRED; a value indicating whether this category is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric
	// categories for a resource, first perform a GET diagnostic settings
	// operation.
	Category *string `json:"category,omitempty"`

	// the retention policy for this category.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`

	// the timegrain of the metric in ISO8601 format.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricSingleDimension - The metric dimension name and value.
type MetricSingleDimension struct {
	// REQUIRED; Name of the dimension.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Value of the dimension.
	Value *string `json:"value,omitempty"`
}

// MetricTrigger - The trigger that results in a scaling action.
type MetricTrigger struct {
	// REQUIRED; the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; the resource identifier of the resource the rule monitors.
	MetricResourceURI *string `json:"metricResourceUri,omitempty"`

	// REQUIRED; the operator that is used to compare the metric data and the threshold.
	Operator *ComparisonOperationType `json:"operator,omitempty"`

	// REQUIRED; the metric statistic type. How the metrics from multiple instances are combined.
	Statistic *MetricStatisticType `json:"statistic,omitempty"`

	// REQUIRED; the threshold of the metric that triggers the scale action.
	Threshold *float64 `json:"threshold,omitempty"`

	// REQUIRED; time aggregation type. How the data that is collected should be combined over time. The default value is Average.
	TimeAggregation *TimeAggregationType `json:"timeAggregation,omitempty"`

	// REQUIRED; the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions
	// for the metric. Must be between 12 hours and 1 minute.
	TimeGrain *string `json:"timeGrain,omitempty"`

	// REQUIRED; the range of time in which instance data is collected. This value must be greater than the delay in metric collection,
	// which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
	TimeWindow *string `json:"timeWindow,omitempty"`

	// List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
	Dimensions []*ScaleRuleMetricDimension `json:"dimensions,omitempty"`

	// a value indicating whether metric should divide per instance.
	DividePerInstance *bool `json:"dividePerInstance,omitempty"`

	// the namespace of the metric that defines what the rule monitors.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// the location of the resource the rule monitors.
	MetricResourceLocation *string `json:"metricResourceLocation,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricTrigger.
func (m MetricTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "dividePerInstance", m.DividePerInstance)
	populate(objectMap, "metricName", m.MetricName)
	populate(objectMap, "metricNamespace", m.MetricNamespace)
	populate(objectMap, "metricResourceLocation", m.MetricResourceLocation)
	populate(objectMap, "metricResourceUri", m.MetricResourceURI)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "statistic", m.Statistic)
	populate(objectMap, "threshold", m.Threshold)
	populate(objectMap, "timeAggregation", m.TimeAggregation)
	populate(objectMap, "timeGrain", m.TimeGrain)
	populate(objectMap, "timeWindow", m.TimeWindow)
	return json.Marshal(objectMap)
}

// MetricValue - Represents a metric value.
type MetricValue struct {
	// REQUIRED; the timestamp for the metric value in ISO 8601 format.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`

	// the average value in the time range.
	Average *float64 `json:"average,omitempty"`

	// the number of samples in the time range. Can be used to determine the number of values that contributed to the average
	// value.
	Count *float64 `json:"count,omitempty"`

	// the greatest value in the time range.
	Maximum *float64 `json:"maximum,omitempty"`

	// the least value in the time range.
	Minimum *float64 `json:"minimum,omitempty"`

	// the sum of all of the values in the time range.
	Total *float64 `json:"total,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MetricValue.
func (m MetricValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "average", m.Average)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "maximum", m.Maximum)
	populate(objectMap, "minimum", m.Minimum)
	populateTimeRFC3339(objectMap, "timeStamp", m.TimeStamp)
	populate(objectMap, "total", m.Total)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricValue.
func (m *MetricValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "average":
			err = unpopulate(val, &m.Average)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, &m.Count)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, &m.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, &m.Minimum)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateTimeRFC3339(val, &m.TimeStamp)
			delete(rawMsg, key)
		case "total":
			err = unpopulate(val, &m.Total)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MetricsClientListOptions contains the optional parameters for the MetricsClient.List method.
type MetricsClientListOptions struct {
	// The list of aggregation types (comma separated) to retrieve.
	Aggregation *string
	// The $filter is used to reduce the set of metric data returned. Example: Metric contains metadata A, B and C. - Return all
	// time series of C where A = a1 and B = b1 or b2 $filter=A eq 'a1' and B eq 'b1'
	// or B eq 'b2' and C eq '' - Invalid variant: $filter=A eq 'a1' and B eq 'b1' and C eq '' or B = 'b2' This is invalid because
	// the logical or operator cannot separate two different metadata names. -
	// Return all time series where A = a1, B = b1 and C = c1: $filter=A eq 'a1' and B eq 'b1' and C eq 'c1' - Return all time
	// series where A = a1 $filter=A eq 'a1' and B eq '' and C eq ''. Special case:
	// When dimension name or dimension value uses round brackets. Eg: When dimension name is dim (test) 1 Instead of using $filter=
	// "dim (test) 1 eq '' " use $filter= "dim %2528test%2529 1 eq '' " When
	// dimension name is dim (test) 3 and dimension value is dim3 (test) val Instead of using $filter= "dim (test) 3 eq 'dim3
	// (test) val' " use $filter= "dim %2528test%2529 3 eq 'dim3 %2528test%2529 val' "
	Filter *string
	// The interval (i.e. timegrain) of the query.
	Interval *string
	// The names of the metrics (comma separated) to retrieve. Special case: If a metricname itself has a comma in it then use
	// %2 to indicate it. Eg: 'Metric,Name1' should be 'Metric%2Name1'
	Metricnames *string
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
	// The aggregation to use for sorting results and the direction of the sort. Only one order can be specified. Examples: sum
	// asc.
	Orderby *string
	// Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's description for details.
	ResultType *ResultType
	// The timespan of the query. It is a string with the following format 'startDateTimeISO/endDateTimeISO'.
	Timespan *string
	// The maximum number of records to retrieve. Valid only if $filter is specified. Defaults to 10.
	Top *int32
}

// MultiMetricCriteriaClassification provides polymorphic access to related types.
// Call the interface's GetMultiMetricCriteria() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DynamicMetricCriteria, *MetricCriteria, *MultiMetricCriteria
type MultiMetricCriteriaClassification interface {
	// GetMultiMetricCriteria returns the MultiMetricCriteria content of the underlying type.
	GetMultiMetricCriteria() *MultiMetricCriteria
}

// MultiMetricCriteria - The types of conditions for a multi resource alert.
type MultiMetricCriteria struct {
	// REQUIRED; Specifies the type of threshold criteria
	CriterionType *CriterionType `json:"criterionType,omitempty"`

	// REQUIRED; Name of the metric.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; Name of the criteria.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the criteria time aggregation types.
	TimeAggregation *AggregationTypeEnum `json:"timeAggregation,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}

	// List of dimension conditions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
}

// GetMultiMetricCriteria implements the MultiMetricCriteriaClassification interface for type MultiMetricCriteria.
func (m *MultiMetricCriteria) GetMultiMetricCriteria() *MultiMetricCriteria { return m }

// MarshalJSON implements the json.Marshaller interface for type MultiMetricCriteria.
func (m MultiMetricCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["criterionType"] = m.CriterionType
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "metricName", m.MetricName)
	populate(objectMap, "metricNamespace", m.MetricNamespace)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "skipMetricValidation", m.SkipMetricValidation)
	populate(objectMap, "timeAggregation", m.TimeAggregation)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MultiMetricCriteria.
func (m *MultiMetricCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "criterionType":
			err = unpopulate(val, &m.CriterionType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, &m.Dimensions)
			delete(rawMsg, key)
		case "metricName":
			err = unpopulate(val, &m.MetricName)
			delete(rawMsg, key)
		case "metricNamespace":
			err = unpopulate(val, &m.MetricNamespace)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &m.Name)
			delete(rawMsg, key)
		case "skipMetricValidation":
			err = unpopulate(val, &m.SkipMetricValidation)
			delete(rawMsg, key)
		case "timeAggregation":
			err = unpopulate(val, &m.TimeAggregation)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// NetworkRuleSet - Definition of the network rules.
type NetworkRuleSet struct {
	// The configuration to set whether network access from public internet to the endpoints are allowed.
	PublicNetworkAccess *KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// NotificationRequestBody - The request body which contain contact detail metadata
type NotificationRequestBody struct {
	// REQUIRED; The name of the supported alert type.
	AlertType *string `json:"alertType,omitempty"`

	// The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are
	// supported.
	ArmRoleReceivers []*ArmRoleReceiver `json:"armRoleReceivers,omitempty"`

	// The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers []*AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`

	// The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers []*AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`

	// The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers []*AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`

	// The list of email receivers that are part of this action group.
	EmailReceivers []*EmailReceiver `json:"emailReceivers,omitempty"`

	// The list of event hub receivers that are part of this action group.
	EventHubReceivers []*EventHubReceiver `json:"eventHubReceivers,omitempty"`

	// The list of ITSM receivers that are part of this action group.
	ItsmReceivers []*ItsmReceiver `json:"itsmReceivers,omitempty"`

	// The list of logic app receivers that are part of this action group.
	LogicAppReceivers []*LogicAppReceiver `json:"logicAppReceivers,omitempty"`

	// The list of SMS receivers that are part of this action group.
	SmsReceivers []*SmsReceiver `json:"smsReceivers,omitempty"`

	// The list of voice receivers that are part of this action group.
	VoiceReceivers []*VoiceReceiver `json:"voiceReceivers,omitempty"`

	// The list of webhook receivers that are part of this action group.
	WebhookReceivers []*WebhookReceiver `json:"webhookReceivers,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type NotificationRequestBody.
func (n NotificationRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertType", n.AlertType)
	populate(objectMap, "armRoleReceivers", n.ArmRoleReceivers)
	populate(objectMap, "automationRunbookReceivers", n.AutomationRunbookReceivers)
	populate(objectMap, "azureAppPushReceivers", n.AzureAppPushReceivers)
	populate(objectMap, "azureFunctionReceivers", n.AzureFunctionReceivers)
	populate(objectMap, "emailReceivers", n.EmailReceivers)
	populate(objectMap, "eventHubReceivers", n.EventHubReceivers)
	populate(objectMap, "itsmReceivers", n.ItsmReceivers)
	populate(objectMap, "logicAppReceivers", n.LogicAppReceivers)
	populate(objectMap, "smsReceivers", n.SmsReceivers)
	populate(objectMap, "voiceReceivers", n.VoiceReceivers)
	populate(objectMap, "webhookReceivers", n.WebhookReceivers)
	return json.Marshal(objectMap)
}

// Operation - Microsoft Insights API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Insights
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: AlertRules, Autoscale, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Insights operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the Microsoft.Insights provider.
	Value []*Operation `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// OperationStatus - The status of operation.
type OperationStatus struct {
	// End time of the job in standard ISO8601 format.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error detail of the operation if any.
	Error *ErrorResponseCommon `json:"error,omitempty"`

	// The operation Id.
	ID *string `json:"id,omitempty"`

	// The operation name.
	Name *string `json:"name,omitempty"`

	// Start time of the job in standard ISO8601 format.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the operation.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatus.
func (o OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PerfCounterDataSource - Definition of which performance counters will be collected and how they will be collected by this
// data collection rule. Collected from both Windows and Linux machines where the counter is present.
type PerfCounterDataSource struct {
	// A list of specifier names of the performance counters you want to collect. Use a wildcard (*) to collect a counter for
	// all instances. To get a list of performance counters on Windows, run the command
	// 'typeperf'.
	CounterSpecifiers []*string `json:"counterSpecifiers,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// The number of seconds between consecutive counter measurements (samples).
	SamplingFrequencyInSeconds *int32 `json:"samplingFrequencyInSeconds,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownPerfCounterDataSourceStreams `json:"streams,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type PerfCounterDataSource.
func (p PerfCounterDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "counterSpecifiers", p.CounterSpecifiers)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "samplingFrequencyInSeconds", p.SamplingFrequencyInSeconds)
	populate(objectMap, "streams", p.Streams)
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByPrivateLinkScope
// method.
type PrivateEndpointConnectionsClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	return json.Marshal(objectMap)
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByPrivateLinkScope
// method.
type PrivateLinkResourcesClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopeOperationStatusClientGetOptions contains the optional parameters for the PrivateLinkScopeOperationStatusClient.Get
// method.
type PrivateLinkScopeOperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResourcesClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.BeginCreateOrUpdate
// method.
type PrivateLinkScopedResourcesClientBeginCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResourcesClientBeginDeleteOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.BeginDelete
// method.
type PrivateLinkScopedResourcesClientBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResourcesClientGetOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.Get
// method.
type PrivateLinkScopedResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResourcesClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.ListByPrivateLinkScope
// method.
type PrivateLinkScopedResourcesClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientBeginDeleteOptions contains the optional parameters for the PrivateLinkScopesClient.BeginDelete
// method.
type PrivateLinkScopesClientBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientCreateOrUpdateOptions contains the optional parameters for the PrivateLinkScopesClient.CreateOrUpdate
// method.
type PrivateLinkScopesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientGetOptions contains the optional parameters for the PrivateLinkScopesClient.Get method.
type PrivateLinkScopesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkScopesClient.ListByResourceGroup
// method.
type PrivateLinkScopesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientListOptions contains the optional parameters for the PrivateLinkScopesClient.List method.
type PrivateLinkScopesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientUpdateTagsOptions contains the optional parameters for the PrivateLinkScopesClient.UpdateTags method.
type PrivateLinkScopesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesResource - An azure resource object
type PrivateLinkScopesResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkScopesResource.
func (p PrivateLinkScopesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionStateProperty - State of the private endpoint connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ProxyOnlyResource - A proxy only azure resource object
type ProxyOnlyResource struct {
	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProxyResource - An azure resource object
type ProxyResource struct {
	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Recurrence - The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
type Recurrence struct {
	// REQUIRED; the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning
	// each week will have the same set of profiles. For example, to set a daily schedule, set
	// schedule to every day of the week. The frequency property specifies that the schedule is repeated weekly.
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// REQUIRED; the scheduling constraints for when the profile begins.
	Schedule *RecurrentSchedule `json:"schedule,omitempty"`
}

// RecurrentSchedule - The scheduling constraints for when the profile begins.
type RecurrentSchedule struct {
	// REQUIRED; the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
	Days []*string `json:"days,omitempty"`

	// REQUIRED; A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM
	// times are not supported).
	Hours []*int32 `json:"hours,omitempty"`

	// REQUIRED; A collection of minutes at which the profile takes effect at.
	Minutes []*int32 `json:"minutes,omitempty"`

	// REQUIRED; the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11,
	// Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific
	// Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard
	// Time, Central Standard Time, Central Standard Time (Mexico), Canada Central
	// Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay
	// Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA
	// Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
	// Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
	// Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time,
	// Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
	// Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa
	// Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard
	// Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard
	// Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time,
	// Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian
	// Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard
	// Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard
	// Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard
	// Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard
	// Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard
	// Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard
	// Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar
	// Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central
	// Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West
	// Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central
	// Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time,
	// UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type RecurrentSchedule.
func (r RecurrentSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "days", r.Days)
	populate(objectMap, "hours", r.Hours)
	populate(objectMap, "minutes", r.Minutes)
	populate(objectMap, "timeZone", r.TimeZone)
	return json.Marshal(objectMap)
}

// Resource - An azure resource object
type Resource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// ResourceForUpdate - Definition of ARM tracked top level resource properties for update operation.
type ResourceForUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ResourceForUpdate.
func (r ResourceForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// Response - The response to a metrics query.
type Response struct {
	// REQUIRED; The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
	// '/'. This may be adjusted in the future and returned back from what was originally
	// requested.
	Timespan *string `json:"timespan,omitempty"`

	// REQUIRED; the value of the collection.
	Value []*Metric `json:"value,omitempty"`

	// The integer value representing the relative cost of the query.
	Cost *int32 `json:"cost,omitempty"`

	// The interval (window size) for which the metric data was returned in. This may be adjusted in the future and returned back
	// from what was originally requested. This is not present if a metadata request
	// was made.
	Interval *string `json:"interval,omitempty"`

	// The namespace of the metrics being queried
	Namespace *string `json:"namespace,omitempty"`

	// The region of the resource being queried for metrics.
	Resourceregion *string `json:"resourceregion,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Response.
func (r Response) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cost", r.Cost)
	populate(objectMap, "interval", r.Interval)
	populate(objectMap, "namespace", r.Namespace)
	populate(objectMap, "resourceregion", r.Resourceregion)
	populate(objectMap, "timespan", r.Timespan)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// ResponseWithError - An error response from the API.
type ResponseWithError struct {
	// REQUIRED; Error information.
	Error *Error `json:"error,omitempty"`
}

// RetentionPolicy - Specifies the retention policy for the log.
type RetentionPolicy struct {
	// REQUIRED; the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`

	// REQUIRED; a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// RuleActionClassification provides polymorphic access to related types.
// Call the interface's GetRuleAction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RuleAction, *RuleEmailAction, *RuleWebhookAction
type RuleActionClassification interface {
	// GetRuleAction returns the RuleAction content of the underlying type.
	GetRuleAction() *RuleAction
}

// RuleAction - The action that is performed when the alert rule becomes active, and when an alert condition is resolved.
type RuleAction struct {
	// REQUIRED; specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
	ODataType *string `json:"odata.type,omitempty"`
}

// GetRuleAction implements the RuleActionClassification interface for type RuleAction.
func (r *RuleAction) GetRuleAction() *RuleAction { return r }

// RuleConditionClassification provides polymorphic access to related types.
// Call the interface's GetRuleCondition() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LocationThresholdRuleCondition, *ManagementEventRuleCondition, *RuleCondition, *ThresholdRuleCondition
type RuleConditionClassification interface {
	// GetRuleCondition returns the RuleCondition content of the underlying type.
	GetRuleCondition() *RuleCondition
}

// RuleCondition - The condition that results in the alert rule being activated.
type RuleCondition struct {
	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type RuleCondition.
func (r *RuleCondition) GetRuleCondition() *RuleCondition { return r }

// MarshalJSON implements the json.Marshaller interface for type RuleCondition.
func (r RuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataSource", r.DataSource)
	objectMap["odata.type"] = r.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleCondition.
func (r *RuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			r.DataSource, err = unmarshalRuleDataSourceClassification(val)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &r.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// RuleDataSourceClassification provides polymorphic access to related types.
// Call the interface's GetRuleDataSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RuleDataSource, *RuleManagementEventDataSource, *RuleMetricDataSource
type RuleDataSourceClassification interface {
	// GetRuleDataSource returns the RuleDataSource content of the underlying type.
	GetRuleDataSource() *RuleDataSource
}

// RuleDataSource - The resource from which the rule collects its data.
type RuleDataSource struct {
	// REQUIRED; specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
	ODataType *string `json:"odata.type,omitempty"`

	// the legacy resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing
	// rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`

	// the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// the resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// GetRuleDataSource implements the RuleDataSourceClassification interface for type RuleDataSource.
func (r *RuleDataSource) GetRuleDataSource() *RuleDataSource { return r }

// RuleEmailAction - Specifies the action to send email when the rule condition is evaluated. The discriminator is always
// RuleEmailAction in this case.
type RuleEmailAction struct {
	// REQUIRED; specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
	ODataType *string `json:"odata.type,omitempty"`

	// the list of administrator's custom email addresses to notify of the activation of the alert.
	CustomEmails []*string `json:"customEmails,omitempty"`

	// Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
	SendToServiceOwners *bool `json:"sendToServiceOwners,omitempty"`
}

// GetRuleAction implements the RuleActionClassification interface for type RuleEmailAction.
func (r *RuleEmailAction) GetRuleAction() *RuleAction {
	return &RuleAction{
		ODataType: r.ODataType,
	}
}

// MarshalJSON implements the json.Marshaller interface for type RuleEmailAction.
func (r RuleEmailAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customEmails", r.CustomEmails)
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
	populate(objectMap, "sendToServiceOwners", r.SendToServiceOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleEmailAction.
func (r *RuleEmailAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customEmails":
			err = unpopulate(val, &r.CustomEmails)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &r.ODataType)
			delete(rawMsg, key)
		case "sendToServiceOwners":
			err = unpopulate(val, &r.SendToServiceOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// RuleManagementEventClaimsDataSource - The claims for a rule management event data source.
type RuleManagementEventClaimsDataSource struct {
	// the email address.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// RuleManagementEventDataSource - A rule management event data source. The discriminator fields is always RuleManagementEventDataSource
// in this case.
type RuleManagementEventDataSource struct {
	// REQUIRED; specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
	ODataType *string `json:"odata.type,omitempty"`

	// the claims.
	Claims *RuleManagementEventClaimsDataSource `json:"claims,omitempty"`

	// the event name.
	EventName *string `json:"eventName,omitempty"`

	// the event source.
	EventSource *string `json:"eventSource,omitempty"`

	// the legacy resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing
	// rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`

	// the level.
	Level *string `json:"level,omitempty"`

	// the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// The name of the operation that should be checked for. If no name is provided, any operation will match.
	OperationName *string `json:"operationName,omitempty"`

	// the resource group name.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// the resource provider name.
	ResourceProviderName *string `json:"resourceProviderName,omitempty"`

	// the resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`

	// The status of the operation that should be checked for. If no status is provided, any status will match.
	Status *string `json:"status,omitempty"`

	// the substatus.
	SubStatus *string `json:"subStatus,omitempty"`
}

// GetRuleDataSource implements the RuleDataSourceClassification interface for type RuleManagementEventDataSource.
func (r *RuleManagementEventDataSource) GetRuleDataSource() *RuleDataSource {
	return &RuleDataSource{
		ODataType:        r.ODataType,
		ResourceURI:      r.ResourceURI,
		LegacyResourceID: r.LegacyResourceID,
		ResourceLocation: r.ResourceLocation,
		MetricNamespace:  r.MetricNamespace,
	}
}

// MarshalJSON implements the json.Marshaller interface for type RuleManagementEventDataSource.
func (r RuleManagementEventDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "eventName", r.EventName)
	populate(objectMap, "eventSource", r.EventSource)
	populate(objectMap, "legacyResourceId", r.LegacyResourceID)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "metricNamespace", r.MetricNamespace)
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroupName", r.ResourceGroupName)
	populate(objectMap, "resourceLocation", r.ResourceLocation)
	populate(objectMap, "resourceProviderName", r.ResourceProviderName)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subStatus", r.SubStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleManagementEventDataSource.
func (r *RuleManagementEventDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "claims":
			err = unpopulate(val, &r.Claims)
			delete(rawMsg, key)
		case "eventName":
			err = unpopulate(val, &r.EventName)
			delete(rawMsg, key)
		case "eventSource":
			err = unpopulate(val, &r.EventSource)
			delete(rawMsg, key)
		case "legacyResourceId":
			err = unpopulate(val, &r.LegacyResourceID)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, &r.Level)
			delete(rawMsg, key)
		case "metricNamespace":
			err = unpopulate(val, &r.MetricNamespace)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &r.ODataType)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, &r.ResourceGroupName)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, &r.ResourceLocation)
			delete(rawMsg, key)
		case "resourceProviderName":
			err = unpopulate(val, &r.ResourceProviderName)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, &r.Status)
			delete(rawMsg, key)
		case "subStatus":
			err = unpopulate(val, &r.SubStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// RuleMetricDataSource - A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
type RuleMetricDataSource struct {
	// REQUIRED; specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
	ODataType *string `json:"odata.type,omitempty"`

	// the legacy resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing
	// rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`

	// the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`

	// the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// the resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// GetRuleDataSource implements the RuleDataSourceClassification interface for type RuleMetricDataSource.
func (r *RuleMetricDataSource) GetRuleDataSource() *RuleDataSource {
	return &RuleDataSource{
		ODataType:        r.ODataType,
		ResourceURI:      r.ResourceURI,
		LegacyResourceID: r.LegacyResourceID,
		ResourceLocation: r.ResourceLocation,
		MetricNamespace:  r.MetricNamespace,
	}
}

// MarshalJSON implements the json.Marshaller interface for type RuleMetricDataSource.
func (r RuleMetricDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "legacyResourceId", r.LegacyResourceID)
	populate(objectMap, "metricName", r.MetricName)
	populate(objectMap, "metricNamespace", r.MetricNamespace)
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
	populate(objectMap, "resourceLocation", r.ResourceLocation)
	populate(objectMap, "resourceUri", r.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleMetricDataSource.
func (r *RuleMetricDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "legacyResourceId":
			err = unpopulate(val, &r.LegacyResourceID)
			delete(rawMsg, key)
		case "metricName":
			err = unpopulate(val, &r.MetricName)
			delete(rawMsg, key)
		case "metricNamespace":
			err = unpopulate(val, &r.MetricNamespace)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &r.ODataType)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, &r.ResourceLocation)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, &r.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// RuleWebhookAction - Specifies the action to post to service when the rule condition is evaluated. The discriminator is
// always RuleWebhookAction in this case.
type RuleWebhookAction struct {
	// REQUIRED; specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
	ODataType *string `json:"odata.type,omitempty"`

	// the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	Properties map[string]*string `json:"properties,omitempty"`

	// the service uri to Post the notification when the alert activates or resolves.
	ServiceURI *string `json:"serviceUri,omitempty"`
}

// GetRuleAction implements the RuleActionClassification interface for type RuleWebhookAction.
func (r *RuleWebhookAction) GetRuleAction() *RuleAction {
	return &RuleAction{
		ODataType: r.ODataType,
	}
}

// MarshalJSON implements the json.Marshaller interface for type RuleWebhookAction.
func (r RuleWebhookAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "serviceUri", r.ServiceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleWebhookAction.
func (r *RuleWebhookAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "odata.type":
			err = unpopulate(val, &r.ODataType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, &r.Properties)
			delete(rawMsg, key)
		case "serviceUri":
			err = unpopulate(val, &r.ServiceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// ScaleAction - The parameters for the scaling action.
type ScaleAction struct {
	// REQUIRED; the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week
	// and 1 minute in ISO 8601 format.
	Cooldown *string `json:"cooldown,omitempty"`

	// REQUIRED; the scale direction. Whether the scaling action increases or decreases the number of instances.
	Direction *ScaleDirection `json:"direction,omitempty"`

	// REQUIRED; the type of action that should occur when the scale rule fires.
	Type *ScaleType `json:"type,omitempty"`

	// the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is
	// 1.
	Value *string `json:"value,omitempty"`
}

// ScaleCapacity - The number of instances that can be used during this profile.
type ScaleCapacity struct {
	// REQUIRED; the number of instances that will be set if metrics are not available for evaluation. The default is only used
	// if the current instance count is lower than the default.
	Default *string `json:"default,omitempty"`

	// REQUIRED; the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores
	// that are available in the subscription.
	Maximum *string `json:"maximum,omitempty"`

	// REQUIRED; the minimum number of instances for the resource.
	Minimum *string `json:"minimum,omitempty"`
}

// ScaleRule - A rule that provide the triggers and parameters for the scaling action.
type ScaleRule struct {
	// REQUIRED; the trigger that results in a scaling action.
	MetricTrigger *MetricTrigger `json:"metricTrigger,omitempty"`

	// REQUIRED; the parameters for the scaling action.
	ScaleAction *ScaleAction `json:"scaleAction,omitempty"`
}

// ScaleRuleMetricDimension - Specifies an auto scale rule metric dimension.
type ScaleRuleMetricDimension struct {
	// REQUIRED; Name of the dimension.
	DimensionName *string `json:"DimensionName,omitempty"`

	// REQUIRED; the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values.
	// 'NotEquals' being not equal to all of the values
	Operator *ScaleRuleMetricDimensionOperationType `json:"Operator,omitempty"`

	// REQUIRED; list of dimension values. For example: ["App1","App2"].
	Values []*string `json:"Values,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ScaleRuleMetricDimension.
func (s ScaleRuleMetricDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "DimensionName", s.DimensionName)
	populate(objectMap, "Operator", s.Operator)
	populate(objectMap, "Values", s.Values)
	return json.Marshal(objectMap)
}

// Schedule - Defines how often to run the search and the time interval.
type Schedule struct {
	// REQUIRED; frequency (in minutes) at which rule condition should be evaluated.
	FrequencyInMinutes *int32 `json:"frequencyInMinutes,omitempty"`

	// REQUIRED; Time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
	TimeWindowInMinutes *int32 `json:"timeWindowInMinutes,omitempty"`
}

// ScheduledQueryRulesClientCreateOrUpdateOptions contains the optional parameters for the ScheduledQueryRulesClient.CreateOrUpdate
// method.
type ScheduledQueryRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientDeleteOptions contains the optional parameters for the ScheduledQueryRulesClient.Delete method.
type ScheduledQueryRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientGetOptions contains the optional parameters for the ScheduledQueryRulesClient.Get method.
type ScheduledQueryRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientListByResourceGroupOptions contains the optional parameters for the ScheduledQueryRulesClient.ListByResourceGroup
// method.
type ScheduledQueryRulesClientListByResourceGroupOptions struct {
	// The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
	Filter *string
}

// ScheduledQueryRulesClientListBySubscriptionOptions contains the optional parameters for the ScheduledQueryRulesClient.ListBySubscription
// method.
type ScheduledQueryRulesClientListBySubscriptionOptions struct {
	// The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
	Filter *string
}

// ScheduledQueryRulesClientUpdateOptions contains the optional parameters for the ScheduledQueryRulesClient.Update method.
type ScheduledQueryRulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScopedResource - A private link scoped resource
type ScopedResource struct {
	// Resource properties.
	Properties *ScopedResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScopedResourceListResult - A list of scoped resources in a private link scope.
type ScopedResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ScopedResource `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ScopedResourceListResult.
func (s ScopedResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// ScopedResourceProperties - Properties of a private link scoped resource.
type ScopedResourceProperties struct {
	// The resource id of the scoped Azure monitor resource.
	LinkedResourceID *string `json:"linkedResourceId,omitempty"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SenderAuthorization - the authorization used by the user who has performed the operation that led to this event. This captures
// the RBAC properties of the event. These usually include the 'action', 'role' and the 'scope'
type SenderAuthorization struct {
	// the permissible actions. For instance: microsoft.support/supporttickets/write
	Action *string `json:"action,omitempty"`

	// the role of the user. For instance: Subscription Admin
	Role *string `json:"role,omitempty"`

	// the scope.
	Scope *string `json:"scope,omitempty"`
}

// SingleBaseline - The baseline values for a single sensitivity value.
type SingleBaseline struct {
	// REQUIRED; The high thresholds of the baseline.
	HighThresholds []*float64 `json:"highThresholds,omitempty"`

	// REQUIRED; The low thresholds of the baseline.
	LowThresholds []*float64 `json:"lowThresholds,omitempty"`

	// REQUIRED; the sensitivity of the baseline.
	Sensitivity *BaselineSensitivity `json:"sensitivity,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type SingleBaseline.
func (s SingleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "highThresholds", s.HighThresholds)
	populate(objectMap, "lowThresholds", s.LowThresholds)
	populate(objectMap, "sensitivity", s.Sensitivity)
	return json.Marshal(objectMap)
}

// SingleMetricBaseline - The baseline results of a single metric.
type SingleMetricBaseline struct {
	// REQUIRED; The metric baseline Id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; The name of the metric for which the baselines were retrieved.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The metric baseline properties of the metric.
	Properties *MetricBaselinesProperties `json:"properties,omitempty"`

	// REQUIRED; The resource type of the metric baseline resource.
	Type *string `json:"type,omitempty"`
}

// SmsReceiver - An SMS receiver.
type SmsReceiver struct {
	// REQUIRED; The country code of the SMS receiver.
	CountryCode *string `json:"countryCode,omitempty"`

	// REQUIRED; The name of the SMS receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The phone number of the SMS receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`

	// READ-ONLY; The status of the receiver.
	Status *ReceiverStatus `json:"status,omitempty" azure:"ro"`
}

// Source - Specifies the log search query.
type Source struct {
	// REQUIRED; The resource uri over which log search query is to be run.
	DataSourceID *string `json:"dataSourceId,omitempty"`

	// List of Resource referred into query
	AuthorizedResources []*string `json:"authorizedResources,omitempty"`

	// Log search query. Required for action type - AlertingAction
	Query *string `json:"query,omitempty"`

	// Set value to 'ResultCount' .
	QueryType *QueryType `json:"queryType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Source.
func (s Source) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizedResources", s.AuthorizedResources)
	populate(objectMap, "dataSourceId", s.DataSourceID)
	populate(objectMap, "query", s.Query)
	populate(objectMap, "queryType", s.QueryType)
	return json.Marshal(objectMap)
}

// SyslogDataSource - Definition of which syslog data will be collected and how it will be collected. Only collected from
// Linux machines.
type SyslogDataSource struct {
	// The list of facility names.
	FacilityNames []*KnownSyslogDataSourceFacilityNames `json:"facilityNames,omitempty"`

	// The log levels to collect.
	LogLevels []*KnownSyslogDataSourceLogLevels `json:"logLevels,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownSyslogDataSourceStreams `json:"streams,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type SyslogDataSource.
func (s SyslogDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "facilityNames", s.FacilityNames)
	populate(objectMap, "logLevels", s.LogLevels)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "streams", s.Streams)
	return json.Marshal(objectMap)
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkScope
// instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TagsResource.
func (t TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// TenantActivityLogsClientListOptions contains the optional parameters for the TenantActivityLogsClient.List method.
type TenantActivityLogsClientListOptions struct {
	// Reduces the set of data collected.
	// The $filter is very restricted and allows only the following patterns.
	// - List events for a resource group: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin,
	// Operation' and resourceGroupName eq ''.
	// - List events for resource: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin, Operation'
	// and resourceUri eq ''.
	// - List events for a subscription: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin, Operation'.
	// - List events for a resource provider: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin,
	// Operation' and resourceProvider eq ''.
	// - List events for a correlation Id: api-version=2014-04-01&$filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z' and
	// eventTimestamp le '2014-07-20T04:36:37.6407898Z' and eventChannels eq 'Admin,
	// Operation' and correlationId eq ''.
	// NOTE: No other syntax is allowed.
	Filter *string
	// Used to fetch events with only the given properties.
	// The $select argument is a comma separated list of property names to be returned. Possible values are: authorization, claims,
	// correlationId, description, eventDataId, eventName, eventTimestamp,
	// httpRequest, level, operationId, operationName, properties, resourceGroupName, resourceProviderName, resourceId, status,
	// submissionTimestamp, subStatus, subscriptionId
	Select *string
}

// TestNotificationDetailsResponse - The details of the test notification results.
type TestNotificationDetailsResponse struct {
	// REQUIRED; The overall state
	State *string `json:"State,omitempty"`

	// The list of action detail
	ActionDetails []*ActionDetail `json:"ActionDetails,omitempty"`

	// The completed time
	CompletedTime *string `json:"CompletedTime,omitempty"`

	// The context info
	Context *Context `json:"Context,omitempty"`

	// The created time
	CreatedTime *string `json:"CreatedTime,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TestNotificationDetailsResponse.
func (t TestNotificationDetailsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ActionDetails", t.ActionDetails)
	populate(objectMap, "CompletedTime", t.CompletedTime)
	populate(objectMap, "Context", t.Context)
	populate(objectMap, "CreatedTime", t.CreatedTime)
	populate(objectMap, "State", t.State)
	return json.Marshal(objectMap)
}

// TestNotificationResponse - The response when test notification succeeded
type TestNotificationResponse struct {
	// REQUIRED; The correlation id
	CorrelationID *string `json:"correlationId,omitempty"`

	// REQUIRED; The created time
	CreatedTime *string `json:"createdTime,omitempty"`

	// REQUIRED; The notification id
	NotificationID *string `json:"notificationId,omitempty"`
}

// ThresholdRuleCondition - A rule condition based on a metric crossing a threshold.
type ThresholdRuleCondition struct {
	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// REQUIRED; the operator used to compare the data and the threshold.
	Operator *ConditionOperator `json:"operator,omitempty"`

	// REQUIRED; the threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`

	// the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType
	// of the Metric.
	TimeAggregation *TimeAggregationOperator `json:"timeAggregation,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified
	// then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type ThresholdRuleCondition.
func (t *ThresholdRuleCondition) GetRuleCondition() *RuleCondition {
	return &RuleCondition{
		ODataType:  t.ODataType,
		DataSource: t.DataSource,
	}
}

// MarshalJSON implements the json.Marshaller interface for type ThresholdRuleCondition.
func (t ThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataSource", t.DataSource)
	objectMap["odata.type"] = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
	populate(objectMap, "operator", t.Operator)
	populate(objectMap, "threshold", t.Threshold)
	populate(objectMap, "timeAggregation", t.TimeAggregation)
	populate(objectMap, "windowSize", t.WindowSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThresholdRuleCondition.
func (t *ThresholdRuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			t.DataSource, err = unmarshalRuleDataSourceClassification(val)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &t.ODataType)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, &t.Operator)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, &t.Threshold)
			delete(rawMsg, key)
		case "timeAggregation":
			err = unpopulate(val, &t.TimeAggregation)
			delete(rawMsg, key)
		case "windowSize":
			err = unpopulate(val, &t.WindowSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// TimeSeriesBaseline - The baseline values for a single time series.
type TimeSeriesBaseline struct {
	// REQUIRED; The aggregation type of the metric.
	Aggregation *string `json:"aggregation,omitempty"`

	// REQUIRED; The baseline values for each sensitivity.
	Data []*SingleBaseline `json:"data,omitempty"`

	// REQUIRED; The list of timestamps of the baselines.
	Timestamps []*time.Time `json:"timestamps,omitempty"`

	// The dimensions of this time series.
	Dimensions []*MetricSingleDimension `json:"dimensions,omitempty"`

	// The baseline metadata values.
	MetadataValues []*BaselineMetadata `json:"metadataValues,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TimeSeriesBaseline.
func (t TimeSeriesBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregation", t.Aggregation)
	populate(objectMap, "data", t.Data)
	populate(objectMap, "dimensions", t.Dimensions)
	populate(objectMap, "metadataValues", t.MetadataValues)
	aux := make([]*timeRFC3339, len(t.Timestamps), len(t.Timestamps))
	for i := 0; i < len(t.Timestamps); i++ {
		aux[i] = (*timeRFC3339)(t.Timestamps[i])
	}
	populate(objectMap, "timestamps", aux)
	return json.Marshal(objectMap)
}

// TimeSeriesElement - A time series result type. The discriminator value is always TimeSeries in this case.
type TimeSeriesElement struct {
	// An array of data points representing the metric values. This is only returned if a result type of data is specified.
	Data []*MetricValue `json:"data,omitempty"`

	// the metadata values returned if $filter was specified in the call.
	Metadatavalues []*MetadataValue `json:"metadatavalues,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TimeSeriesElement.
func (t TimeSeriesElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "data", t.Data)
	populate(objectMap, "metadatavalues", t.Metadatavalues)
	return json.Marshal(objectMap)
}

// TimeWindow - A specific date-time for the profile.
type TimeWindow struct {
	// REQUIRED; the end time for the profile in ISO 8601 format.
	End *time.Time `json:"end,omitempty"`

	// REQUIRED; the start time for the profile in ISO 8601 format.
	Start *time.Time `json:"start,omitempty"`

	// the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time,
	// UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time
	// (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central
	// America Standard Time, Central Standard Time, Central Standard Time
	// (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela
	// Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central
	// Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America
	// Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland
	// Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
	// Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time,
	// Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
	// Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan
	// Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard
	// Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
	// Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus
	// Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard
	// Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time,
	// Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time,
	// Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time,
	// Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard
	// Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard
	// Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard
	// Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard
	// Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern
	// Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia
	// Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New
	// Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line
	// Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TimeWindow.
func (t TimeWindow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "end", t.End)
	populateTimeRFC3339(objectMap, "start", t.Start)
	populate(objectMap, "timeZone", t.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeWindow.
func (t *TimeWindow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulateTimeRFC3339(val, &t.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulateTimeRFC3339(val, &t.Start)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, &t.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// TrackedEntityResource - An azure resource object
type TrackedEntityResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g.
	// ApiApps are a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type TrackedEntityResource.
func (t TrackedEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// TriggerCondition - The condition that results in the Log Search rule.
type TriggerCondition struct {
	// REQUIRED; Result or count threshold based on which rule should be triggered.
	Threshold *float64 `json:"threshold,omitempty"`

	// REQUIRED; Evaluation operation for rule - 'GreaterThan' or 'LessThan.
	ThresholdOperator *ConditionalOperator `json:"thresholdOperator,omitempty"`

	// Trigger condition for metric query rule
	MetricTrigger *LogMetricTrigger `json:"metricTrigger,omitempty"`
}

// VMInsightsClientGetOnboardingStatusOptions contains the optional parameters for the VMInsightsClient.GetOnboardingStatus
// method.
type VMInsightsClientGetOnboardingStatusOptions struct {
	// placeholder for future optional parameters
}

// VMInsightsOnboardingStatus - VM Insights onboarding status for a resource.
type VMInsightsOnboardingStatus struct {
	// Resource properties.
	Properties *VMInsightsOnboardingStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VMInsightsOnboardingStatusProperties - Resource properties.
type VMInsightsOnboardingStatusProperties struct {
	// REQUIRED; The status of VM Insights data from the resource. When reported as present the data array will contain information
	// about the data containers to which data for the specified resource is being routed.
	DataStatus *DataStatus `json:"dataStatus,omitempty"`

	// REQUIRED; The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription,
	// is considered onboarded if at least one resource under it is onboarded.
	OnboardingStatus *OnboardingStatus `json:"onboardingStatus,omitempty"`

	// REQUIRED; Azure Resource Manager identifier of the resource whose onboarding status is being represented.
	ResourceID *string `json:"resourceId,omitempty"`

	// Containers that currently store VM Insights data for the specified resource.
	Data []*DataContainer `json:"data,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type VMInsightsOnboardingStatusProperties.
func (v VMInsightsOnboardingStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "data", v.Data)
	populate(objectMap, "dataStatus", v.DataStatus)
	populate(objectMap, "onboardingStatus", v.OnboardingStatus)
	populate(objectMap, "resourceId", v.ResourceID)
	return json.Marshal(objectMap)
}

// VoiceReceiver - A voice receiver.
type VoiceReceiver struct {
	// REQUIRED; The country code of the voice receiver.
	CountryCode *string `json:"countryCode,omitempty"`

	// REQUIRED; The name of the voice receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The phone number of the voice receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// WebhookNotification - Webhook notification of an autoscale event.
type WebhookNotification struct {
	// a property bag of settings. This value can be empty.
	Properties map[string]*string `json:"properties,omitempty"`

	// the service address to receive the notification.
	ServiceURI *string `json:"serviceUri,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type WebhookNotification.
func (w WebhookNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "serviceUri", w.ServiceURI)
	return json.Marshal(objectMap)
}

// WebhookReceiver - A webhook receiver.
type WebhookReceiver struct {
	// REQUIRED; The name of the webhook receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// Indicates the identifier uri for aad auth.
	IdentifierURI *string `json:"identifierUri,omitempty"`

	// Indicates the webhook app object Id for aad auth.
	ObjectID *string `json:"objectId,omitempty"`

	// Indicates the tenant id for aad auth.
	TenantID *string `json:"tenantId,omitempty"`

	// Indicates whether or not use AAD authentication.
	UseAADAuth *bool `json:"useAadAuth,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// WebtestLocationAvailabilityCriteria - Specifies the metric alert rule criteria for a web test resource.
type WebtestLocationAvailabilityCriteria struct {
	// REQUIRED; The Application Insights resource Id.
	ComponentID *string `json:"componentId,omitempty"`

	// REQUIRED; The number of failed locations.
	FailedLocationCount *float32 `json:"failedLocationCount,omitempty"`

	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// REQUIRED; The Application Insights web test Id.
	WebTestID *string `json:"webTestId,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]map[string]interface{}
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type WebtestLocationAvailabilityCriteria.
func (w *WebtestLocationAvailabilityCriteria) GetMetricAlertCriteria() *MetricAlertCriteria {
	return &MetricAlertCriteria{
		ODataType:            w.ODataType,
		AdditionalProperties: w.AdditionalProperties,
	}
}

// MarshalJSON implements the json.Marshaller interface for type WebtestLocationAvailabilityCriteria.
func (w WebtestLocationAvailabilityCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "componentId", w.ComponentID)
	populate(objectMap, "failedLocationCount", w.FailedLocationCount)
	objectMap["odata.type"] = OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria
	populate(objectMap, "webTestId", w.WebTestID)
	if w.AdditionalProperties != nil {
		for key, val := range w.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebtestLocationAvailabilityCriteria.
func (w *WebtestLocationAvailabilityCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, &w.ComponentID)
			delete(rawMsg, key)
		case "failedLocationCount":
			err = unpopulate(val, &w.FailedLocationCount)
			delete(rawMsg, key)
		case "odata.type":
			err = unpopulate(val, &w.ODataType)
			delete(rawMsg, key)
		case "webTestId":
			err = unpopulate(val, &w.WebTestID)
			delete(rawMsg, key)
		default:
			if w.AdditionalProperties == nil {
				w.AdditionalProperties = map[string]map[string]interface{}{}
			}
			if val != nil {
				var aux map[string]interface{}
				err = json.Unmarshal(val, &aux)
				w.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// WindowsEventLogDataSource - Definition of which Windows Event Log events will be collected and how they will be collected.
// Only collected from Windows machines.
type WindowsEventLogDataSource struct {
	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownWindowsEventLogDataSourceStreams `json:"streams,omitempty"`

	// A list of Windows Event Log queries in XPATH format.
	XPathQueries []*string `json:"xPathQueries,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type WindowsEventLogDataSource.
func (w WindowsEventLogDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", w.Name)
	populate(objectMap, "streams", w.Streams)
	populate(objectMap, "xPathQueries", w.XPathQueries)
	return json.Marshal(objectMap)
}

// WorkspaceInfo - Information about a Log Analytics Workspace.
type WorkspaceInfo struct {
	// REQUIRED; Azure Resource Manager identifier of the Log Analytics Workspace.
	ID *string `json:"id,omitempty"`

	// REQUIRED; Location of the Log Analytics workspace.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *WorkspaceInfoProperties `json:"properties,omitempty"`
}

// WorkspaceInfoProperties - Resource properties.
type WorkspaceInfoProperties struct {
	// REQUIRED; Log Analytics workspace identifier.
	CustomerID *string `json:"customerId,omitempty"`
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, v interface{}) error {
	if data == nil {
		return nil
	}
	return json.Unmarshal(data, v)
}
