package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccessKeyLastUsedResources invokes the actiontrail.GetAccessKeyLastUsedResources API synchronously
func (client *Client) GetAccessKeyLastUsedResources(request *GetAccessKeyLastUsedResourcesRequest) (response *GetAccessKeyLastUsedResourcesResponse, err error) {
	response = CreateGetAccessKeyLastUsedResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccessKeyLastUsedResourcesWithChan invokes the actiontrail.GetAccessKeyLastUsedResources API asynchronously
func (client *Client) GetAccessKeyLastUsedResourcesWithChan(request *GetAccessKeyLastUsedResourcesRequest) (<-chan *GetAccessKeyLastUsedResourcesResponse, <-chan error) {
	responseChan := make(chan *GetAccessKeyLastUsedResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccessKeyLastUsedResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccessKeyLastUsedResourcesWithCallback invokes the actiontrail.GetAccessKeyLastUsedResources API asynchronously
func (client *Client) GetAccessKeyLastUsedResourcesWithCallback(request *GetAccessKeyLastUsedResourcesRequest, callback func(response *GetAccessKeyLastUsedResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccessKeyLastUsedResourcesResponse
		var err error
		defer close(result)
		response, err = client.GetAccessKeyLastUsedResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccessKeyLastUsedResourcesRequest is the request struct for api GetAccessKeyLastUsedResources
type GetAccessKeyLastUsedResourcesRequest struct {
	*requests.RpcRequest
	AccessKey   string `position:"Query" name:"AccessKey"`
	NextToken   string `position:"Query" name:"NextToken"`
	PageSize    string `position:"Query" name:"PageSize"`
	ServiceName string `position:"Query" name:"ServiceName"`
}

// GetAccessKeyLastUsedResourcesResponse is the response struct for api GetAccessKeyLastUsedResources
type GetAccessKeyLastUsedResourcesResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	NextToken string          `json:"NextToken" xml:"NextToken"`
	Resources []ResourcesItem `json:"Resources" xml:"Resources"`
}

// CreateGetAccessKeyLastUsedResourcesRequest creates a request to invoke GetAccessKeyLastUsedResources API
func CreateGetAccessKeyLastUsedResourcesRequest() (request *GetAccessKeyLastUsedResourcesRequest) {
	request = &GetAccessKeyLastUsedResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "GetAccessKeyLastUsedResources", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAccessKeyLastUsedResourcesResponse creates a response to parse from GetAccessKeyLastUsedResources response
func CreateGetAccessKeyLastUsedResourcesResponse() (response *GetAccessKeyLastUsedResourcesResponse) {
	response = &GetAccessKeyLastUsedResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
