package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageableQueryExperimentTaskByClusterId invokes the ahas_openapi.PageableQueryExperimentTaskByClusterId API synchronously
func (client *Client) PageableQueryExperimentTaskByClusterId(request *PageableQueryExperimentTaskByClusterIdRequest) (response *PageableQueryExperimentTaskByClusterIdResponse, err error) {
	response = CreatePageableQueryExperimentTaskByClusterIdResponse()
	err = client.DoAction(request, response)
	return
}

// PageableQueryExperimentTaskByClusterIdWithChan invokes the ahas_openapi.PageableQueryExperimentTaskByClusterId API asynchronously
func (client *Client) PageableQueryExperimentTaskByClusterIdWithChan(request *PageableQueryExperimentTaskByClusterIdRequest) (<-chan *PageableQueryExperimentTaskByClusterIdResponse, <-chan error) {
	responseChan := make(chan *PageableQueryExperimentTaskByClusterIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageableQueryExperimentTaskByClusterId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageableQueryExperimentTaskByClusterIdWithCallback invokes the ahas_openapi.PageableQueryExperimentTaskByClusterId API asynchronously
func (client *Client) PageableQueryExperimentTaskByClusterIdWithCallback(request *PageableQueryExperimentTaskByClusterIdRequest, callback func(response *PageableQueryExperimentTaskByClusterIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageableQueryExperimentTaskByClusterIdResponse
		var err error
		defer close(result)
		response, err = client.PageableQueryExperimentTaskByClusterId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageableQueryExperimentTaskByClusterIdRequest is the request struct for api PageableQueryExperimentTaskByClusterId
type PageableQueryExperimentTaskByClusterIdRequest struct {
	*requests.RpcRequest
	ClusterId          string           `position:"Query" name:"ClusterId"`
	AhasRegionId       string           `position:"Query" name:"AhasRegionId"`
	IncludeInvalidHost requests.Boolean `position:"Query" name:"IncludeInvalidHost"`
	Size               requests.Integer `position:"Query" name:"Size"`
	Namespace          string           `position:"Query" name:"Namespace"`
	Page               requests.Integer `position:"Query" name:"Page"`
}

// PageableQueryExperimentTaskByClusterIdResponse is the response struct for api PageableQueryExperimentTaskByClusterId
type PageableQueryExperimentTaskByClusterIdResponse struct {
	*responses.BaseResponse
	Pages           int                  `json:"Pages" xml:"Pages"`
	RequestId       string               `json:"RequestId" xml:"RequestId"`
	Message         string               `json:"Message" xml:"Message"`
	PageSize        int                  `json:"PageSize" xml:"PageSize"`
	CurrentPage     int                  `json:"CurrentPage" xml:"CurrentPage"`
	Total           int                  `json:"Total" xml:"Total"`
	HttpStatusCode  int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code            string               `json:"Code" xml:"Code"`
	Success         bool                 `json:"Success" xml:"Success"`
	ExperimentTasks []ExperimentTaskInfo `json:"ExperimentTasks" xml:"ExperimentTasks"`
}

// CreatePageableQueryExperimentTaskByClusterIdRequest creates a request to invoke PageableQueryExperimentTaskByClusterId API
func CreatePageableQueryExperimentTaskByClusterIdRequest() (request *PageableQueryExperimentTaskByClusterIdRequest) {
	request = &PageableQueryExperimentTaskByClusterIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "PageableQueryExperimentTaskByClusterId", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePageableQueryExperimentTaskByClusterIdResponse creates a response to parse from PageableQueryExperimentTaskByClusterId response
func CreatePageableQueryExperimentTaskByClusterIdResponse() (response *PageableQueryExperimentTaskByClusterIdResponse) {
	response = &PageableQueryExperimentTaskByClusterIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
