package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRuleConditions invokes the airec.ListRuleConditions API synchronously
func (client *Client) ListRuleConditions(request *ListRuleConditionsRequest) (response *ListRuleConditionsResponse, err error) {
	response = CreateListRuleConditionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRuleConditionsWithChan invokes the airec.ListRuleConditions API asynchronously
func (client *Client) ListRuleConditionsWithChan(request *ListRuleConditionsRequest) (<-chan *ListRuleConditionsResponse, <-chan error) {
	responseChan := make(chan *ListRuleConditionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRuleConditions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRuleConditionsWithCallback invokes the airec.ListRuleConditions API asynchronously
func (client *Client) ListRuleConditionsWithCallback(request *ListRuleConditionsRequest, callback func(response *ListRuleConditionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRuleConditionsResponse
		var err error
		defer close(result)
		response, err = client.ListRuleConditions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRuleConditionsRequest is the request struct for api ListRuleConditions
type ListRuleConditionsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
}

// ListRuleConditionsResponse is the response struct for api ListRuleConditions
type ListRuleConditionsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Code      string       `json:"code" xml:"code"`
	Message   string       `json:"message" xml:"message"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListRuleConditionsRequest creates a request to invoke ListRuleConditions API
func CreateListRuleConditionsRequest() (request *ListRuleConditionsRequest) {
	request = &ListRuleConditionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListRuleConditions", "/v2/openapi/instances/[instanceId]/rule-conditions", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListRuleConditionsResponse creates a response to parse from ListRuleConditions response
func CreateListRuleConditionsResponse() (response *ListRuleConditionsResponse) {
	response = &ListRuleConditionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
