package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListImageLabels invokes the aiworkspace.ListImageLabels API synchronously
func (client *Client) ListImageLabels(request *ListImageLabelsRequest) (response *ListImageLabelsResponse, err error) {
	response = CreateListImageLabelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListImageLabelsWithChan invokes the aiworkspace.ListImageLabels API asynchronously
func (client *Client) ListImageLabelsWithChan(request *ListImageLabelsRequest) (<-chan *ListImageLabelsResponse, <-chan error) {
	responseChan := make(chan *ListImageLabelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListImageLabels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListImageLabelsWithCallback invokes the aiworkspace.ListImageLabels API asynchronously
func (client *Client) ListImageLabelsWithCallback(request *ListImageLabelsRequest, callback func(response *ListImageLabelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListImageLabelsResponse
		var err error
		defer close(result)
		response, err = client.ListImageLabels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListImageLabelsRequest is the request struct for api ListImageLabels
type ListImageLabelsRequest struct {
	*requests.RoaRequest
	ImageId     string `position:"Query" name:"ImageId"`
	LabelKeys   string `position:"Query" name:"LabelKeys"`
	Region      string `position:"Query" name:"Region"`
	LabelFilter string `position:"Query" name:"LabelFilter"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// ListImageLabelsResponse is the response struct for api ListImageLabels
type ListImageLabelsResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	TotalCount int64        `json:"TotalCount" xml:"TotalCount"`
	Labels     []LabelsItem `json:"Labels" xml:"Labels"`
}

// CreateListImageLabelsRequest creates a request to invoke ListImageLabels API
func CreateListImageLabelsRequest() (request *ListImageLabelsRequest) {
	request = &ListImageLabelsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "ListImageLabels", "/api/v1/image/labels", "", "")
	request.Method = requests.GET
	return
}

// CreateListImageLabelsResponse creates a response to parse from ListImageLabels response
func CreateListImageLabelsResponse() (response *ListImageLabelsResponse) {
	response = &ListImageLabelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
