package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDefaultWorkspace invokes the aiworkspace.UpdateDefaultWorkspace API synchronously
func (client *Client) UpdateDefaultWorkspace(request *UpdateDefaultWorkspaceRequest) (response *UpdateDefaultWorkspaceResponse, err error) {
	response = CreateUpdateDefaultWorkspaceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDefaultWorkspaceWithChan invokes the aiworkspace.UpdateDefaultWorkspace API asynchronously
func (client *Client) UpdateDefaultWorkspaceWithChan(request *UpdateDefaultWorkspaceRequest) (<-chan *UpdateDefaultWorkspaceResponse, <-chan error) {
	responseChan := make(chan *UpdateDefaultWorkspaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDefaultWorkspace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDefaultWorkspaceWithCallback invokes the aiworkspace.UpdateDefaultWorkspace API asynchronously
func (client *Client) UpdateDefaultWorkspaceWithCallback(request *UpdateDefaultWorkspaceRequest, callback func(response *UpdateDefaultWorkspaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDefaultWorkspaceResponse
		var err error
		defer close(result)
		response, err = client.UpdateDefaultWorkspace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDefaultWorkspaceRequest is the request struct for api UpdateDefaultWorkspace
type UpdateDefaultWorkspaceRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// UpdateDefaultWorkspaceResponse is the response struct for api UpdateDefaultWorkspace
type UpdateDefaultWorkspaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDefaultWorkspaceRequest creates a request to invoke UpdateDefaultWorkspace API
func CreateUpdateDefaultWorkspaceRequest() (request *UpdateDefaultWorkspaceRequest) {
	request = &UpdateDefaultWorkspaceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "UpdateDefaultWorkspace", "/api/v1/defaultWorkspaces", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateDefaultWorkspaceResponse creates a response to parse from UpdateDefaultWorkspace response
func CreateUpdateDefaultWorkspaceResponse() (response *UpdateDefaultWorkspaceResponse) {
	response = &UpdateDefaultWorkspaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
