package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWsChGeneral invokes the alinlp.GetWsChGeneral API synchronously
func (client *Client) GetWsChGeneral(request *GetWsChGeneralRequest) (response *GetWsChGeneralResponse, err error) {
	response = CreateGetWsChGeneralResponse()
	err = client.DoAction(request, response)
	return
}

// GetWsChGeneralWithChan invokes the alinlp.GetWsChGeneral API asynchronously
func (client *Client) GetWsChGeneralWithChan(request *GetWsChGeneralRequest) (<-chan *GetWsChGeneralResponse, <-chan error) {
	responseChan := make(chan *GetWsChGeneralResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWsChGeneral(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWsChGeneralWithCallback invokes the alinlp.GetWsChGeneral API asynchronously
func (client *Client) GetWsChGeneralWithCallback(request *GetWsChGeneralRequest, callback func(response *GetWsChGeneralResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWsChGeneralResponse
		var err error
		defer close(result)
		response, err = client.GetWsChGeneral(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWsChGeneralRequest is the request struct for api GetWsChGeneral
type GetWsChGeneralRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	OutType     string `position:"Body" name:"OutType"`
}

// GetWsChGeneralResponse is the response struct for api GetWsChGeneral
type GetWsChGeneralResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWsChGeneralRequest creates a request to invoke GetWsChGeneral API
func CreateGetWsChGeneralRequest() (request *GetWsChGeneralRequest) {
	request = &GetWsChGeneralRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWsChGeneral", "", "")
	request.Method = requests.POST
	return
}

// CreateGetWsChGeneralResponse creates a response to parse from GetWsChGeneral response
func CreateGetWsChGeneralResponse() (response *GetWsChGeneralResponse) {
	response = &GetWsChGeneralResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
