package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Edss invokes the amp.Edss API synchronously
func (client *Client) Edss(request *EdssRequest) (response *EdssResponse, err error) {
	response = CreateEdssResponse()
	err = client.DoAction(request, response)
	return
}

// EdssWithChan invokes the amp.Edss API asynchronously
func (client *Client) EdssWithChan(request *EdssRequest) (<-chan *EdssResponse, <-chan error) {
	responseChan := make(chan *EdssResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Edss(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EdssWithCallback invokes the amp.Edss API asynchronously
func (client *Client) EdssWithCallback(request *EdssRequest, callback func(response *EdssResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EdssResponse
		var err error
		defer close(result)
		response, err = client.Edss(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EdssRequest is the request struct for api Edss
type EdssRequest struct {
	*requests.RoaRequest
	A string `position:"Query" name:"A"`
}

// EdssResponse is the response struct for api Edss
type EdssResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateEdssRequest creates a request to invoke Edss API
func CreateEdssRequest() (request *EdssRequest) {
	request = &EdssRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "Edss", "/efe/e", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEdssResponse creates a response to parse from Edss response
func CreateEdssResponse() (response *EdssResponse) {
	response = &EdssResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
