package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSurveyResourceConnections invokes the apds.ListSurveyResourceConnections API synchronously
func (client *Client) ListSurveyResourceConnections(request *ListSurveyResourceConnectionsRequest) (response *ListSurveyResourceConnectionsResponse, err error) {
	response = CreateListSurveyResourceConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSurveyResourceConnectionsWithChan invokes the apds.ListSurveyResourceConnections API asynchronously
func (client *Client) ListSurveyResourceConnectionsWithChan(request *ListSurveyResourceConnectionsRequest) (<-chan *ListSurveyResourceConnectionsResponse, <-chan error) {
	responseChan := make(chan *ListSurveyResourceConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSurveyResourceConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSurveyResourceConnectionsWithCallback invokes the apds.ListSurveyResourceConnections API asynchronously
func (client *Client) ListSurveyResourceConnectionsWithCallback(request *ListSurveyResourceConnectionsRequest, callback func(response *ListSurveyResourceConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSurveyResourceConnectionsResponse
		var err error
		defer close(result)
		response, err = client.ListSurveyResourceConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSurveyResourceConnectionsRequest is the request struct for api ListSurveyResourceConnections
type ListSurveyResourceConnectionsRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// ListSurveyResourceConnectionsResponse is the response struct for api ListSurveyResourceConnections
type ListSurveyResourceConnectionsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"Error" xml:"Error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateListSurveyResourceConnectionsRequest creates a request to invoke ListSurveyResourceConnections API
func CreateListSurveyResourceConnectionsRequest() (request *ListSurveyResourceConnectionsRequest) {
	request = &ListSurveyResourceConnectionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "ListSurveyResourceConnections", "/okss-services/resource-connects", "", "")
	request.Method = requests.POST
	return
}

// CreateListSurveyResourceConnectionsResponse creates a response to parse from ListSurveyResourceConnections response
func CreateListSurveyResourceConnectionsResponse() (response *ListSurveyResourceConnectionsResponse) {
	response = &ListSurveyResourceConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
