package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyScenario invokes the arms.ApplyScenario API synchronously
func (client *Client) ApplyScenario(request *ApplyScenarioRequest) (response *ApplyScenarioResponse, err error) {
	response = CreateApplyScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyScenarioWithChan invokes the arms.ApplyScenario API asynchronously
func (client *Client) ApplyScenarioWithChan(request *ApplyScenarioRequest) (<-chan *ApplyScenarioResponse, <-chan error) {
	responseChan := make(chan *ApplyScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyScenarioWithCallback invokes the arms.ApplyScenario API asynchronously
func (client *Client) ApplyScenarioWithCallback(request *ApplyScenarioRequest, callback func(response *ApplyScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyScenarioResponse
		var err error
		defer close(result)
		response, err = client.ApplyScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyScenarioRequest is the request struct for api ApplyScenario
type ApplyScenarioRequest struct {
	*requests.RpcRequest
	SnForce      requests.Boolean `position:"Query" name:"SnForce"`
	Sign         string           `position:"Query" name:"Sign"`
	SnStat       requests.Boolean `position:"Query" name:"SnStat"`
	Scenario     string           `position:"Query" name:"Scenario"`
	SnDump       requests.Boolean `position:"Query" name:"SnDump"`
	AppId        string           `position:"Query" name:"AppId"`
	Name         string           `position:"Query" name:"Name"`
	SnTransfer   requests.Boolean `position:"Query" name:"SnTransfer"`
	UpdateOption requests.Boolean `position:"Query" name:"UpdateOption"`
	Config       string           `position:"Query" name:"Config"`
}

// ApplyScenarioResponse is the response struct for api ApplyScenario
type ApplyScenarioResponse struct {
	*responses.BaseResponse
	Result    string `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApplyScenarioRequest creates a request to invoke ApplyScenario API
func CreateApplyScenarioRequest() (request *ApplyScenarioRequest) {
	request = &ApplyScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ApplyScenario", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyScenarioResponse creates a response to parse from ApplyScenario response
func CreateApplyScenarioResponse() (response *ApplyScenarioResponse) {
	response = &ApplyScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
