package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAlertContact invokes the arms.DeleteAlertContact API synchronously
func (client *Client) DeleteAlertContact(request *DeleteAlertContactRequest) (response *DeleteAlertContactResponse, err error) {
	response = CreateDeleteAlertContactResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAlertContactWithChan invokes the arms.DeleteAlertContact API asynchronously
func (client *Client) DeleteAlertContactWithChan(request *DeleteAlertContactRequest) (<-chan *DeleteAlertContactResponse, <-chan error) {
	responseChan := make(chan *DeleteAlertContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAlertContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAlertContactWithCallback invokes the arms.DeleteAlertContact API asynchronously
func (client *Client) DeleteAlertContactWithCallback(request *DeleteAlertContactRequest, callback func(response *DeleteAlertContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAlertContactResponse
		var err error
		defer close(result)
		response, err = client.DeleteAlertContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAlertContactRequest is the request struct for api DeleteAlertContact
type DeleteAlertContactRequest struct {
	*requests.RpcRequest
	ContactId   requests.Integer `position:"Query" name:"ContactId"`
	ProxyUserId string           `position:"Query" name:"ProxyUserId"`
}

// DeleteAlertContactResponse is the response struct for api DeleteAlertContact
type DeleteAlertContactResponse struct {
	*responses.BaseResponse
	DeleteAlertContactIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	RequestId                   string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAlertContactRequest creates a request to invoke DeleteAlertContact API
func CreateDeleteAlertContactRequest() (request *DeleteAlertContactRequest) {
	request = &DeleteAlertContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteAlertContact", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAlertContactResponse creates a response to parse from DeleteAlertContact response
func CreateDeleteAlertContactResponse() (response *DeleteAlertContactResponse) {
	response = &DeleteAlertContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
