package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrometheusGlobalView invokes the arms.ListPrometheusGlobalView API synchronously
func (client *Client) ListPrometheusGlobalView(request *ListPrometheusGlobalViewRequest) (response *ListPrometheusGlobalViewResponse, err error) {
	response = CreateListPrometheusGlobalViewResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrometheusGlobalViewWithChan invokes the arms.ListPrometheusGlobalView API asynchronously
func (client *Client) ListPrometheusGlobalViewWithChan(request *ListPrometheusGlobalViewRequest) (<-chan *ListPrometheusGlobalViewResponse, <-chan error) {
	responseChan := make(chan *ListPrometheusGlobalViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrometheusGlobalView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrometheusGlobalViewWithCallback invokes the arms.ListPrometheusGlobalView API asynchronously
func (client *Client) ListPrometheusGlobalViewWithCallback(request *ListPrometheusGlobalViewRequest, callback func(response *ListPrometheusGlobalViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrometheusGlobalViewResponse
		var err error
		defer close(result)
		response, err = client.ListPrometheusGlobalView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrometheusGlobalViewRequest is the request struct for api ListPrometheusGlobalView
type ListPrometheusGlobalViewRequest struct {
	*requests.RpcRequest
}

// ListPrometheusGlobalViewResponse is the response struct for api ListPrometheusGlobalView
type ListPrometheusGlobalViewResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateListPrometheusGlobalViewRequest creates a request to invoke ListPrometheusGlobalView API
func CreateListPrometheusGlobalViewRequest() (request *ListPrometheusGlobalViewRequest) {
	request = &ListPrometheusGlobalViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListPrometheusGlobalView", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPrometheusGlobalViewResponse creates a response to parse from ListPrometheusGlobalView response
func CreateListPrometheusGlobalViewResponse() (response *ListPrometheusGlobalViewResponse) {
	response = &ListPrometheusGlobalViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
