package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManageRecordingRule invokes the arms.ManageRecordingRule API synchronously
func (client *Client) ManageRecordingRule(request *ManageRecordingRuleRequest) (response *ManageRecordingRuleResponse, err error) {
	response = CreateManageRecordingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ManageRecordingRuleWithChan invokes the arms.ManageRecordingRule API asynchronously
func (client *Client) ManageRecordingRuleWithChan(request *ManageRecordingRuleRequest) (<-chan *ManageRecordingRuleResponse, <-chan error) {
	responseChan := make(chan *ManageRecordingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManageRecordingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManageRecordingRuleWithCallback invokes the arms.ManageRecordingRule API asynchronously
func (client *Client) ManageRecordingRuleWithCallback(request *ManageRecordingRuleRequest, callback func(response *ManageRecordingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManageRecordingRuleResponse
		var err error
		defer close(result)
		response, err = client.ManageRecordingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManageRecordingRuleRequest is the request struct for api ManageRecordingRule
type ManageRecordingRuleRequest struct {
	*requests.RpcRequest
	RuleYaml    string `position:"Query" name:"RuleYaml"`
	QueryUserId string `position:"Query" name:"QueryUserId"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// ManageRecordingRuleResponse is the response struct for api ManageRecordingRule
type ManageRecordingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateManageRecordingRuleRequest creates a request to invoke ManageRecordingRule API
func CreateManageRecordingRuleRequest() (request *ManageRecordingRuleRequest) {
	request = &ManageRecordingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ManageRecordingRule", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateManageRecordingRuleResponse creates a response to parse from ManageRecordingRule response
func CreateManageRecordingRuleResponse() (response *ManageRecordingRuleResponse) {
	response = &ManageRecordingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
