package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTraceAppByName invokes the arms.SearchTraceAppByName API synchronously
func (client *Client) SearchTraceAppByName(request *SearchTraceAppByNameRequest) (response *SearchTraceAppByNameResponse, err error) {
	response = CreateSearchTraceAppByNameResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTraceAppByNameWithChan invokes the arms.SearchTraceAppByName API asynchronously
func (client *Client) SearchTraceAppByNameWithChan(request *SearchTraceAppByNameRequest) (<-chan *SearchTraceAppByNameResponse, <-chan error) {
	responseChan := make(chan *SearchTraceAppByNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTraceAppByName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTraceAppByNameWithCallback invokes the arms.SearchTraceAppByName API asynchronously
func (client *Client) SearchTraceAppByNameWithCallback(request *SearchTraceAppByNameRequest, callback func(response *SearchTraceAppByNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTraceAppByNameResponse
		var err error
		defer close(result)
		response, err = client.SearchTraceAppByName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTraceAppByNameRequest is the request struct for api SearchTraceAppByName
type SearchTraceAppByNameRequest struct {
	*requests.RpcRequest
	TraceAppName string `position:"Query" name:"TraceAppName"`
}

// SearchTraceAppByNameResponse is the response struct for api SearchTraceAppByName
type SearchTraceAppByNameResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	TraceApps []TraceApp `json:"TraceApps" xml:"TraceApps"`
}

// CreateSearchTraceAppByNameRequest creates a request to invoke SearchTraceAppByName API
func CreateSearchTraceAppByNameRequest() (request *SearchTraceAppByNameRequest) {
	request = &SearchTraceAppByNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SearchTraceAppByName", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchTraceAppByNameResponse creates a response to parse from SearchTraceAppByName response
func CreateSearchTraceAppByNameResponse() (response *SearchTraceAppByNameResponse) {
	response = &SearchTraceAppByNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
