package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCertificateForPackageRequest invokes the cas.CreateCertificateForPackageRequest API synchronously
func (client *Client) CreateCertificateForPackageRequest(request *CreateCertificateForPackageRequestRequest) (response *CreateCertificateForPackageRequestResponse, err error) {
	response = CreateCreateCertificateForPackageRequestResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCertificateForPackageRequestWithChan invokes the cas.CreateCertificateForPackageRequest API asynchronously
func (client *Client) CreateCertificateForPackageRequestWithChan(request *CreateCertificateForPackageRequestRequest) (<-chan *CreateCertificateForPackageRequestResponse, <-chan error) {
	responseChan := make(chan *CreateCertificateForPackageRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCertificateForPackageRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCertificateForPackageRequestWithCallback invokes the cas.CreateCertificateForPackageRequest API asynchronously
func (client *Client) CreateCertificateForPackageRequestWithCallback(request *CreateCertificateForPackageRequestRequest, callback func(response *CreateCertificateForPackageRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCertificateForPackageRequestResponse
		var err error
		defer close(result)
		response, err = client.CreateCertificateForPackageRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCertificateForPackageRequestRequest is the request struct for api CreateCertificateForPackageRequest
type CreateCertificateForPackageRequestRequest struct {
	*requests.RpcRequest
	ProductCode  string `position:"Query" name:"ProductCode"`
	Csr          string `position:"Query" name:"Csr"`
	ValidateType string `position:"Query" name:"ValidateType"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	Email        string `position:"Query" name:"Email"`
	Phone        string `position:"Query" name:"Phone"`
	CompanyName  string `position:"Query" name:"CompanyName"`
	Domain       string `position:"Query" name:"Domain"`
	Username     string `position:"Query" name:"Username"`
}

// CreateCertificateForPackageRequestResponse is the response struct for api CreateCertificateForPackageRequest
type CreateCertificateForPackageRequestResponse struct {
	*responses.BaseResponse
	OrderId   int64  `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCertificateForPackageRequestRequest creates a request to invoke CreateCertificateForPackageRequest API
func CreateCreateCertificateForPackageRequestRequest() (request *CreateCertificateForPackageRequestRequest) {
	request = &CreateCertificateForPackageRequestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "CreateCertificateForPackageRequest", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCertificateForPackageRequestResponse creates a response to parse from CreateCertificateForPackageRequest response
func CreateCreateCertificateForPackageRequestResponse() (response *CreateCertificateForPackageRequestResponse) {
	response = &CreateCertificateForPackageRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
