package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCert invokes the cas.ListCert API synchronously
func (client *Client) ListCert(request *ListCertRequest) (response *ListCertResponse, err error) {
	response = CreateListCertResponse()
	err = client.DoAction(request, response)
	return
}

// ListCertWithChan invokes the cas.ListCert API asynchronously
func (client *Client) ListCertWithChan(request *ListCertRequest) (<-chan *ListCertResponse, <-chan error) {
	responseChan := make(chan *ListCertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCertWithCallback invokes the cas.ListCert API asynchronously
func (client *Client) ListCertWithCallback(request *ListCertRequest, callback func(response *ListCertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCertResponse
		var err error
		defer close(result)
		response, err = client.ListCert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCertRequest is the request struct for api ListCert
type ListCertRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	WarehouseId requests.Integer `position:"Query" name:"WarehouseId"`
	SourceType  string           `position:"Query" name:"SourceType"`
	KeyWord     string           `position:"Query" name:"KeyWord"`
	ShowSize    requests.Integer `position:"Query" name:"ShowSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Status      string           `position:"Query" name:"Status"`
}

// ListCertResponse is the response struct for api ListCert
type ListCertResponse struct {
	*responses.BaseResponse
	ShowSize    int64  `json:"ShowSize" xml:"ShowSize"`
	CurrentPage int64  `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int64  `json:"TotalCount" xml:"TotalCount"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	CertList    []Cert `json:"CertList" xml:"CertList"`
}

// CreateListCertRequest creates a request to invoke ListCert API
func CreateListCertRequest() (request *ListCertRequest) {
	request = &ListCertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "ListCert", "", "")
	request.Method = requests.POST
	return
}

// CreateListCertResponse creates a response to parse from ListCert response
func CreateListCertResponse() (response *ListCertResponse) {
	response = &ListCertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
