package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeWHClientCertificate invokes the cas.RevokeWHClientCertificate API synchronously
func (client *Client) RevokeWHClientCertificate(request *RevokeWHClientCertificateRequest) (response *RevokeWHClientCertificateResponse, err error) {
	response = CreateRevokeWHClientCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeWHClientCertificateWithChan invokes the cas.RevokeWHClientCertificate API asynchronously
func (client *Client) RevokeWHClientCertificateWithChan(request *RevokeWHClientCertificateRequest) (<-chan *RevokeWHClientCertificateResponse, <-chan error) {
	responseChan := make(chan *RevokeWHClientCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeWHClientCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeWHClientCertificateWithCallback invokes the cas.RevokeWHClientCertificate API asynchronously
func (client *Client) RevokeWHClientCertificateWithCallback(request *RevokeWHClientCertificateRequest, callback func(response *RevokeWHClientCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeWHClientCertificateResponse
		var err error
		defer close(result)
		response, err = client.RevokeWHClientCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeWHClientCertificateRequest is the request struct for api RevokeWHClientCertificate
type RevokeWHClientCertificateRequest struct {
	*requests.RpcRequest
	Identifier string `position:"Query" name:"Identifier"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// RevokeWHClientCertificateResponse is the response struct for api RevokeWHClientCertificate
type RevokeWHClientCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeWHClientCertificateRequest creates a request to invoke RevokeWHClientCertificate API
func CreateRevokeWHClientCertificateRequest() (request *RevokeWHClientCertificateRequest) {
	request = &RevokeWHClientCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "RevokeWHClientCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateRevokeWHClientCertificateResponse creates a response to parse from RevokeWHClientCertificate response
func CreateRevokeWHClientCertificateResponse() (response *RevokeWHClientCertificateResponse) {
	response = &RevokeWHClientCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
