package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadPCACert invokes the cas.UploadPCACert API synchronously
func (client *Client) UploadPCACert(request *UploadPCACertRequest) (response *UploadPCACertResponse, err error) {
	response = CreateUploadPCACertResponse()
	err = client.DoAction(request, response)
	return
}

// UploadPCACertWithChan invokes the cas.UploadPCACert API asynchronously
func (client *Client) UploadPCACertWithChan(request *UploadPCACertRequest) (<-chan *UploadPCACertResponse, <-chan error) {
	responseChan := make(chan *UploadPCACertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadPCACert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadPCACertWithCallback invokes the cas.UploadPCACert API asynchronously
func (client *Client) UploadPCACertWithCallback(request *UploadPCACertRequest, callback func(response *UploadPCACertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadPCACertResponse
		var err error
		defer close(result)
		response, err = client.UploadPCACert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadPCACertRequest is the request struct for api UploadPCACert
type UploadPCACertRequest struct {
	*requests.RpcRequest
	Cert        string           `position:"Query" name:"Cert"`
	PrivateKey  string           `position:"Query" name:"PrivateKey"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	WarehouseId requests.Integer `position:"Query" name:"WarehouseId"`
	Name        string           `position:"Query" name:"Name"`
}

// UploadPCACertResponse is the response struct for api UploadPCACert
type UploadPCACertResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Identifier string `json:"Identifier" xml:"Identifier"`
}

// CreateUploadPCACertRequest creates a request to invoke UploadPCACert API
func CreateUploadPCACertRequest() (request *UploadPCACertRequest) {
	request = &UploadPCACertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "UploadPCACert", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadPCACertResponse creates a response to parse from UploadPCACert response
func CreateUploadPCACertResponse() (response *UploadPCACertResponse) {
	response = &UploadPCACertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
