package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckTransitRouterService invokes the cbn.CheckTransitRouterService API synchronously
func (client *Client) CheckTransitRouterService(request *CheckTransitRouterServiceRequest) (response *CheckTransitRouterServiceResponse, err error) {
	response = CreateCheckTransitRouterServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CheckTransitRouterServiceWithChan invokes the cbn.CheckTransitRouterService API asynchronously
func (client *Client) CheckTransitRouterServiceWithChan(request *CheckTransitRouterServiceRequest) (<-chan *CheckTransitRouterServiceResponse, <-chan error) {
	responseChan := make(chan *CheckTransitRouterServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckTransitRouterService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckTransitRouterServiceWithCallback invokes the cbn.CheckTransitRouterService API asynchronously
func (client *Client) CheckTransitRouterServiceWithCallback(request *CheckTransitRouterServiceRequest, callback func(response *CheckTransitRouterServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckTransitRouterServiceResponse
		var err error
		defer close(result)
		response, err = client.CheckTransitRouterService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckTransitRouterServiceRequest is the request struct for api CheckTransitRouterService
type CheckTransitRouterServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
}

// CheckTransitRouterServiceResponse is the response struct for api CheckTransitRouterService
type CheckTransitRouterServiceResponse struct {
	*responses.BaseResponse
	Enabled   string `json:"Enabled" xml:"Enabled"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckTransitRouterServiceRequest creates a request to invoke CheckTransitRouterService API
func CreateCheckTransitRouterServiceRequest() (request *CheckTransitRouterServiceRequest) {
	request = &CheckTransitRouterServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CheckTransitRouterService", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckTransitRouterServiceResponse creates a response to parse from CheckTransitRouterService response
func CreateCheckTransitRouterServiceResponse() (response *CheckTransitRouterServiceResponse) {
	response = &CheckTransitRouterServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
