package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCenChildInstanceRouteEntryToCen invokes the cbn.CreateCenChildInstanceRouteEntryToCen API synchronously
func (client *Client) CreateCenChildInstanceRouteEntryToCen(request *CreateCenChildInstanceRouteEntryToCenRequest) (response *CreateCenChildInstanceRouteEntryToCenResponse, err error) {
	response = CreateCreateCenChildInstanceRouteEntryToCenResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCenChildInstanceRouteEntryToCenWithChan invokes the cbn.CreateCenChildInstanceRouteEntryToCen API asynchronously
func (client *Client) CreateCenChildInstanceRouteEntryToCenWithChan(request *CreateCenChildInstanceRouteEntryToCenRequest) (<-chan *CreateCenChildInstanceRouteEntryToCenResponse, <-chan error) {
	responseChan := make(chan *CreateCenChildInstanceRouteEntryToCenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCenChildInstanceRouteEntryToCen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCenChildInstanceRouteEntryToCenWithCallback invokes the cbn.CreateCenChildInstanceRouteEntryToCen API asynchronously
func (client *Client) CreateCenChildInstanceRouteEntryToCenWithCallback(request *CreateCenChildInstanceRouteEntryToCenRequest, callback func(response *CreateCenChildInstanceRouteEntryToCenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCenChildInstanceRouteEntryToCenResponse
		var err error
		defer close(result)
		response, err = client.CreateCenChildInstanceRouteEntryToCen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCenChildInstanceRouteEntryToCenRequest is the request struct for api CreateCenChildInstanceRouteEntryToCen
type CreateCenChildInstanceRouteEntryToCenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                 string           `position:"Query" name:"CenId"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	NextHopGatewayZoneId  string           `position:"Query" name:"NextHopGatewayZoneId"`
	ChildInstanceRegionId string           `position:"Query" name:"ChildInstanceRegionId"`
	RouteTableId          string           `position:"Query" name:"RouteTableId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	DestinationCidrBlock  string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	ChildInstanceType     string           `position:"Query" name:"ChildInstanceType"`
	Version               string           `position:"Query" name:"Version"`
	ChildInstanceId       string           `position:"Query" name:"ChildInstanceId"`
	ChildInstanceAliUid   requests.Integer `position:"Query" name:"ChildInstanceAliUid"`
}

// CreateCenChildInstanceRouteEntryToCenResponse is the response struct for api CreateCenChildInstanceRouteEntryToCen
type CreateCenChildInstanceRouteEntryToCenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCenChildInstanceRouteEntryToCenRequest creates a request to invoke CreateCenChildInstanceRouteEntryToCen API
func CreateCreateCenChildInstanceRouteEntryToCenRequest() (request *CreateCenChildInstanceRouteEntryToCenRequest) {
	request = &CreateCenChildInstanceRouteEntryToCenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateCenChildInstanceRouteEntryToCen", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCenChildInstanceRouteEntryToCenResponse creates a response to parse from CreateCenChildInstanceRouteEntryToCen response
func CreateCreateCenChildInstanceRouteEntryToCenResponse() (response *CreateCenChildInstanceRouteEntryToCenResponse) {
	response = &CreateCenChildInstanceRouteEntryToCenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
