package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterRouteEntry invokes the cbn.CreateTransitRouterRouteEntry API synchronously
func (client *Client) CreateTransitRouterRouteEntry(request *CreateTransitRouterRouteEntryRequest) (response *CreateTransitRouterRouteEntryResponse, err error) {
	response = CreateCreateTransitRouterRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterRouteEntryWithChan invokes the cbn.CreateTransitRouterRouteEntry API asynchronously
func (client *Client) CreateTransitRouterRouteEntryWithChan(request *CreateTransitRouterRouteEntryRequest) (<-chan *CreateTransitRouterRouteEntryResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterRouteEntryWithCallback invokes the cbn.CreateTransitRouterRouteEntry API asynchronously
func (client *Client) CreateTransitRouterRouteEntryWithCallback(request *CreateTransitRouterRouteEntryRequest, callback func(response *CreateTransitRouterRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterRouteEntryRequest is the request struct for api CreateTransitRouterRouteEntry
type CreateTransitRouterRouteEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                             requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                                 string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteEntryNextHopType          string           `position:"Query" name:"TransitRouterRouteEntryNextHopType"`
	TransitRouterRouteEntryDestinationCidrBlock string           `position:"Query" name:"TransitRouterRouteEntryDestinationCidrBlock"`
	TransitRouterRouteTableId                   string           `position:"Query" name:"TransitRouterRouteTableId"`
	TransitRouterRouteEntryNextHopId            string           `position:"Query" name:"TransitRouterRouteEntryNextHopId"`
	TransitRouterRouteEntryDescription          string           `position:"Query" name:"TransitRouterRouteEntryDescription"`
	DryRun                                      requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount                        string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                                string           `position:"Query" name:"OwnerAccount"`
	OwnerId                                     requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterRouteEntryName                 string           `position:"Query" name:"TransitRouterRouteEntryName"`
	Version                                     string           `position:"Query" name:"Version"`
}

// CreateTransitRouterRouteEntryResponse is the response struct for api CreateTransitRouterRouteEntry
type CreateTransitRouterRouteEntryResponse struct {
	*responses.BaseResponse
	TransitRouterRouteEntryId string `json:"TransitRouterRouteEntryId" xml:"TransitRouterRouteEntryId"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouterRouteEntryRequest creates a request to invoke CreateTransitRouterRouteEntry API
func CreateCreateTransitRouterRouteEntryRequest() (request *CreateTransitRouterRouteEntryRequest) {
	request = &CreateTransitRouterRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterRouteEntry", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterRouteEntryResponse creates a response to parse from CreateTransitRouterRouteEntry response
func CreateCreateTransitRouterRouteEntryResponse() (response *CreateTransitRouterRouteEntryResponse) {
	response = &CreateTransitRouterRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
