package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTrafficMarkingPolicy invokes the cbn.DeleteTrafficMarkingPolicy API synchronously
func (client *Client) DeleteTrafficMarkingPolicy(request *DeleteTrafficMarkingPolicyRequest) (response *DeleteTrafficMarkingPolicyResponse, err error) {
	response = CreateDeleteTrafficMarkingPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTrafficMarkingPolicyWithChan invokes the cbn.DeleteTrafficMarkingPolicy API asynchronously
func (client *Client) DeleteTrafficMarkingPolicyWithChan(request *DeleteTrafficMarkingPolicyRequest) (<-chan *DeleteTrafficMarkingPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteTrafficMarkingPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrafficMarkingPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTrafficMarkingPolicyWithCallback invokes the cbn.DeleteTrafficMarkingPolicy API asynchronously
func (client *Client) DeleteTrafficMarkingPolicyWithCallback(request *DeleteTrafficMarkingPolicyRequest, callback func(response *DeleteTrafficMarkingPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTrafficMarkingPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteTrafficMarkingPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTrafficMarkingPolicyRequest is the request struct for api DeleteTrafficMarkingPolicy
type DeleteTrafficMarkingPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	TrafficMarkingPolicyId string           `position:"Query" name:"TrafficMarkingPolicyId"`
	DryRun                 requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	Version                string           `position:"Query" name:"Version"`
}

// DeleteTrafficMarkingPolicyResponse is the response struct for api DeleteTrafficMarkingPolicy
type DeleteTrafficMarkingPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTrafficMarkingPolicyRequest creates a request to invoke DeleteTrafficMarkingPolicy API
func CreateDeleteTrafficMarkingPolicyRequest() (request *DeleteTrafficMarkingPolicyRequest) {
	request = &DeleteTrafficMarkingPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteTrafficMarkingPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTrafficMarkingPolicyResponse creates a response to parse from DeleteTrafficMarkingPolicy response
func CreateDeleteTrafficMarkingPolicyResponse() (response *DeleteTrafficMarkingPolicyResponse) {
	response = &DeleteTrafficMarkingPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
