package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCenAttachedChildInstanceAttribute invokes the cbn.DescribeCenAttachedChildInstanceAttribute API synchronously
func (client *Client) DescribeCenAttachedChildInstanceAttribute(request *DescribeCenAttachedChildInstanceAttributeRequest) (response *DescribeCenAttachedChildInstanceAttributeResponse, err error) {
	response = CreateDescribeCenAttachedChildInstanceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCenAttachedChildInstanceAttributeWithChan invokes the cbn.DescribeCenAttachedChildInstanceAttribute API asynchronously
func (client *Client) DescribeCenAttachedChildInstanceAttributeWithChan(request *DescribeCenAttachedChildInstanceAttributeRequest) (<-chan *DescribeCenAttachedChildInstanceAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeCenAttachedChildInstanceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCenAttachedChildInstanceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCenAttachedChildInstanceAttributeWithCallback invokes the cbn.DescribeCenAttachedChildInstanceAttribute API asynchronously
func (client *Client) DescribeCenAttachedChildInstanceAttributeWithCallback(request *DescribeCenAttachedChildInstanceAttributeRequest, callback func(response *DescribeCenAttachedChildInstanceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCenAttachedChildInstanceAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeCenAttachedChildInstanceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCenAttachedChildInstanceAttributeRequest is the request struct for api DescribeCenAttachedChildInstanceAttribute
type DescribeCenAttachedChildInstanceAttributeRequest struct {
	*requests.RpcRequest
	IncludeRouteTable     requests.Boolean `position:"Query" name:"IncludeRouteTable"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                 string           `position:"Query" name:"CenId"`
	ChildInstanceRegionId string           `position:"Query" name:"ChildInstanceRegionId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	ChildInstanceType     string           `position:"Query" name:"ChildInstanceType"`
	Version               string           `position:"Query" name:"Version"`
	ChildInstanceId       string           `position:"Query" name:"ChildInstanceId"`
}

// DescribeCenAttachedChildInstanceAttributeResponse is the response struct for api DescribeCenAttachedChildInstanceAttribute
type DescribeCenAttachedChildInstanceAttributeResponse struct {
	*responses.BaseResponse
	Status                   string                   `json:"Status" xml:"Status"`
	ChildInstanceType        string                   `json:"ChildInstanceType" xml:"ChildInstanceType"`
	ChildInstanceRegionId    string                   `json:"ChildInstanceRegionId" xml:"ChildInstanceRegionId"`
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	ChildInstanceOwnerId     int64                    `json:"ChildInstanceOwnerId" xml:"ChildInstanceOwnerId"`
	ChildInstanceId          string                   `json:"ChildInstanceId" xml:"ChildInstanceId"`
	CenId                    string                   `json:"CenId" xml:"CenId"`
	ChildInstanceName        string                   `json:"ChildInstanceName" xml:"ChildInstanceName"`
	Ipv6StatusInCen          string                   `json:"Ipv6StatusInCen" xml:"Ipv6StatusInCen"`
	ChildInstanceAttachTime  string                   `json:"ChildInstanceAttachTime" xml:"ChildInstanceAttachTime"`
	ChildInstanceRouteTables ChildInstanceRouteTables `json:"ChildInstanceRouteTables" xml:"ChildInstanceRouteTables"`
}

// CreateDescribeCenAttachedChildInstanceAttributeRequest creates a request to invoke DescribeCenAttachedChildInstanceAttribute API
func CreateDescribeCenAttachedChildInstanceAttributeRequest() (request *DescribeCenAttachedChildInstanceAttributeRequest) {
	request = &DescribeCenAttachedChildInstanceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeCenAttachedChildInstanceAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCenAttachedChildInstanceAttributeResponse creates a response to parse from DescribeCenAttachedChildInstanceAttribute response
func CreateDescribeCenAttachedChildInstanceAttributeResponse() (response *DescribeCenAttachedChildInstanceAttributeResponse) {
	response = &DescribeCenAttachedChildInstanceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
