package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterCidr invokes the cbn.ListTransitRouterCidr API synchronously
func (client *Client) ListTransitRouterCidr(request *ListTransitRouterCidrRequest) (response *ListTransitRouterCidrResponse, err error) {
	response = CreateListTransitRouterCidrResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterCidrWithChan invokes the cbn.ListTransitRouterCidr API asynchronously
func (client *Client) ListTransitRouterCidrWithChan(request *ListTransitRouterCidrRequest) (<-chan *ListTransitRouterCidrResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterCidrWithCallback invokes the cbn.ListTransitRouterCidr API asynchronously
func (client *Client) ListTransitRouterCidrWithCallback(request *ListTransitRouterCidrRequest, callback func(response *ListTransitRouterCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterCidrResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterCidrRequest is the request struct for api ListTransitRouterCidr
type ListTransitRouterCidrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	TransitRouterCidrId  string           `position:"Query" name:"TransitRouterCidrId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId      string           `position:"Query" name:"TransitRouterId"`
	Version              string           `position:"Query" name:"Version"`
}

// ListTransitRouterCidrResponse is the response struct for api ListTransitRouterCidr
type ListTransitRouterCidrResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	CidrLists []CidrListsItem `json:"CidrLists" xml:"CidrLists"`
}

// CreateListTransitRouterCidrRequest creates a request to invoke ListTransitRouterCidr API
func CreateListTransitRouterCidrRequest() (request *ListTransitRouterCidrRequest) {
	request = &ListTransitRouterCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterCidr", "", "")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterCidrResponse creates a response to parse from ListTransitRouterCidr response
func CreateListTransitRouterCidrResponse() (response *ListTransitRouterCidrResponse) {
	response = &ListTransitRouterCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
