package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDoNotCallFileUploadParameters invokes the ccc.GetDoNotCallFileUploadParameters API synchronously
func (client *Client) GetDoNotCallFileUploadParameters(request *GetDoNotCallFileUploadParametersRequest) (response *GetDoNotCallFileUploadParametersResponse, err error) {
	response = CreateGetDoNotCallFileUploadParametersResponse()
	err = client.DoAction(request, response)
	return
}

// GetDoNotCallFileUploadParametersWithChan invokes the ccc.GetDoNotCallFileUploadParameters API asynchronously
func (client *Client) GetDoNotCallFileUploadParametersWithChan(request *GetDoNotCallFileUploadParametersRequest) (<-chan *GetDoNotCallFileUploadParametersResponse, <-chan error) {
	responseChan := make(chan *GetDoNotCallFileUploadParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDoNotCallFileUploadParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDoNotCallFileUploadParametersWithCallback invokes the ccc.GetDoNotCallFileUploadParameters API asynchronously
func (client *Client) GetDoNotCallFileUploadParametersWithCallback(request *GetDoNotCallFileUploadParametersRequest, callback func(response *GetDoNotCallFileUploadParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDoNotCallFileUploadParametersResponse
		var err error
		defer close(result)
		response, err = client.GetDoNotCallFileUploadParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDoNotCallFileUploadParametersRequest is the request struct for api GetDoNotCallFileUploadParameters
type GetDoNotCallFileUploadParametersRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	FileName   string `position:"Query" name:"FileName"`
}

// GetDoNotCallFileUploadParametersResponse is the response struct for api GetDoNotCallFileUploadParameters
type GetDoNotCallFileUploadParametersResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetDoNotCallFileUploadParametersRequest creates a request to invoke GetDoNotCallFileUploadParameters API
func CreateGetDoNotCallFileUploadParametersRequest() (request *GetDoNotCallFileUploadParametersRequest) {
	request = &GetDoNotCallFileUploadParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetDoNotCallFileUploadParameters", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDoNotCallFileUploadParametersResponse creates a response to parse from GetDoNotCallFileUploadParameters response
func CreateGetDoNotCallFileUploadParametersResponse() (response *GetDoNotCallFileUploadParametersResponse) {
	response = &GetDoNotCallFileUploadParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
