package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRDSToClickhouseDb invokes the clickhouse.CreateRDSToClickhouseDb API synchronously
func (client *Client) CreateRDSToClickhouseDb(request *CreateRDSToClickhouseDbRequest) (response *CreateRDSToClickhouseDbResponse, err error) {
	response = CreateCreateRDSToClickhouseDbResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRDSToClickhouseDbWithChan invokes the clickhouse.CreateRDSToClickhouseDb API asynchronously
func (client *Client) CreateRDSToClickhouseDbWithChan(request *CreateRDSToClickhouseDbRequest) (<-chan *CreateRDSToClickhouseDbResponse, <-chan error) {
	responseChan := make(chan *CreateRDSToClickhouseDbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRDSToClickhouseDb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRDSToClickhouseDbWithCallback invokes the clickhouse.CreateRDSToClickhouseDb API asynchronously
func (client *Client) CreateRDSToClickhouseDbWithCallback(request *CreateRDSToClickhouseDbRequest, callback func(response *CreateRDSToClickhouseDbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRDSToClickhouseDbResponse
		var err error
		defer close(result)
		response, err = client.CreateRDSToClickhouseDb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRDSToClickhouseDbRequest is the request struct for api CreateRDSToClickhouseDb
type CreateRDSToClickhouseDbRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SynDbTables          string           `position:"Query" name:"SynDbTables"`
	RdsVpcId             string           `position:"Query" name:"RdsVpcId"`
	CkPassword           string           `position:"Query" name:"CkPassword"`
	RdsPassword          string           `position:"Query" name:"RdsPassword"`
	CkUserName           string           `position:"Query" name:"CkUserName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DbClusterId          string           `position:"Query" name:"DbClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RdsId                string           `position:"Query" name:"RdsId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ClickhousePort       requests.Integer `position:"Query" name:"ClickhousePort"`
	LimitUpper           requests.Integer `position:"Query" name:"LimitUpper"`
	RdsPort              requests.Integer `position:"Query" name:"RdsPort"`
	SkipUnsupported      requests.Boolean `position:"Query" name:"SkipUnsupported"`
	RdsVpcUrl            string           `position:"Query" name:"RdsVpcUrl"`
	RdsUserName          string           `position:"Query" name:"RdsUserName"`
}

// CreateRDSToClickhouseDbResponse is the response struct for api CreateRDSToClickhouseDb
type CreateRDSToClickhouseDbResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	Status      int64    `json:"Status" xml:"Status"`
	ErrorMsg    string   `json:"ErrorMsg" xml:"ErrorMsg"`
	RepeatedDbs []string `json:"RepeatedDbs" xml:"RepeatedDbs"`
}

// CreateCreateRDSToClickhouseDbRequest creates a request to invoke CreateRDSToClickhouseDb API
func CreateCreateRDSToClickhouseDbRequest() (request *CreateRDSToClickhouseDbRequest) {
	request = &CreateRDSToClickhouseDbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "CreateRDSToClickhouseDb", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRDSToClickhouseDbResponse creates a response to parse from CreateRDSToClickhouseDb response
func CreateCreateRDSToClickhouseDbResponse() (response *CreateRDSToClickhouseDbResponse) {
	response = &CreateRDSToClickhouseDbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
