package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportRealtime invokes the cloudwf.ReportRealtime API synchronously
// api document: https://help.aliyun.com/api/cloudwf/reportrealtime.html
func (client *Client) ReportRealtime(request *ReportRealtimeRequest) (response *ReportRealtimeResponse, err error) {
	response = CreateReportRealtimeResponse()
	err = client.DoAction(request, response)
	return
}

// ReportRealtimeWithChan invokes the cloudwf.ReportRealtime API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportrealtime.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportRealtimeWithChan(request *ReportRealtimeRequest) (<-chan *ReportRealtimeResponse, <-chan error) {
	responseChan := make(chan *ReportRealtimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportRealtime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportRealtimeWithCallback invokes the cloudwf.ReportRealtime API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportrealtime.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportRealtimeWithCallback(request *ReportRealtimeRequest, callback func(response *ReportRealtimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportRealtimeResponse
		var err error
		defer close(result)
		response, err = client.ReportRealtime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportRealtimeRequest is the request struct for api ReportRealtime
type ReportRealtimeRequest struct {
	*requests.RpcRequest
	Agsid requests.Integer `position:"Query" name:"Agsid"`
}

// ReportRealtimeResponse is the response struct for api ReportRealtime
type ReportRealtimeResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateReportRealtimeRequest creates a request to invoke ReportRealtime API
func CreateReportRealtimeRequest() (request *ReportRealtimeRequest) {
	request = &ReportRealtimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ReportRealtime", "cloudwf", "openAPI")
	return
}

// CreateReportRealtimeResponse creates a response to parse from ReportRealtime response
func CreateReportRealtimeResponse() (response *ReportRealtimeResponse) {
	response = &ReportRealtimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
