package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeAP invokes the cloudwf.UpgradeAP API synchronously
// api document: https://help.aliyun.com/api/cloudwf/upgradeap.html
func (client *Client) UpgradeAP(request *UpgradeAPRequest) (response *UpgradeAPResponse, err error) {
	response = CreateUpgradeAPResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeAPWithChan invokes the cloudwf.UpgradeAP API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/upgradeap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeAPWithChan(request *UpgradeAPRequest) (<-chan *UpgradeAPResponse, <-chan error) {
	responseChan := make(chan *UpgradeAPResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeAP(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeAPWithCallback invokes the cloudwf.UpgradeAP API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/upgradeap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeAPWithCallback(request *UpgradeAPRequest, callback func(response *UpgradeAPResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeAPResponse
		var err error
		defer close(result)
		response, err = client.UpgradeAP(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeAPRequest is the request struct for api UpgradeAP
type UpgradeAPRequest struct {
	*requests.RpcRequest
	Ids *[]string `position:"Query" name:"Ids"  type:"Repeated"`
}

// UpgradeAPResponse is the response struct for api UpgradeAP
type UpgradeAPResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateUpgradeAPRequest creates a request to invoke UpgradeAP API
func CreateUpgradeAPRequest() (request *UpgradeAPRequest) {
	request = &UpgradeAPRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "UpgradeAP", "cloudwf", "openAPI")
	return
}

// CreateUpgradeAPResponse creates a response to parse from UpgradeAP response
func CreateUpgradeAPResponse() (response *UpgradeAPResponse) {
	response = &UpgradeAPResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
