package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddWebhook invokes the codeup.AddWebhook API synchronously
func (client *Client) AddWebhook(request *AddWebhookRequest) (response *AddWebhookResponse, err error) {
	response = CreateAddWebhookResponse()
	err = client.DoAction(request, response)
	return
}

// AddWebhookWithChan invokes the codeup.AddWebhook API asynchronously
func (client *Client) AddWebhookWithChan(request *AddWebhookRequest) (<-chan *AddWebhookResponse, <-chan error) {
	responseChan := make(chan *AddWebhookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddWebhook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddWebhookWithCallback invokes the codeup.AddWebhook API asynchronously
func (client *Client) AddWebhookWithCallback(request *AddWebhookRequest, callback func(response *AddWebhookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddWebhookResponse
		var err error
		defer close(result)
		response, err = client.AddWebhook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddWebhookRequest is the request struct for api AddWebhook
type AddWebhookRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// AddWebhookResponse is the response struct for api AddWebhook
type AddWebhookResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateAddWebhookRequest creates a request to invoke AddWebhook API
func CreateAddWebhookRequest() (request *AddWebhookRequest) {
	request = &AddWebhookRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "AddWebhook", "/api/v3/projects/[ProjectId]/hooks", "", "")
	request.Method = requests.POST
	return
}

// CreateAddWebhookResponse creates a response to parse from AddWebhook response
func CreateAddWebhookResponse() (response *AddWebhookResponse) {
	response = &AddWebhookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
