package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserProduceOperateLogs invokes the companyreg.ListUserProduceOperateLogs API synchronously
func (client *Client) ListUserProduceOperateLogs(request *ListUserProduceOperateLogsRequest) (response *ListUserProduceOperateLogsResponse, err error) {
	response = CreateListUserProduceOperateLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserProduceOperateLogsWithChan invokes the companyreg.ListUserProduceOperateLogs API asynchronously
func (client *Client) ListUserProduceOperateLogsWithChan(request *ListUserProduceOperateLogsRequest) (<-chan *ListUserProduceOperateLogsResponse, <-chan error) {
	responseChan := make(chan *ListUserProduceOperateLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserProduceOperateLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserProduceOperateLogsWithCallback invokes the companyreg.ListUserProduceOperateLogs API asynchronously
func (client *Client) ListUserProduceOperateLogsWithCallback(request *ListUserProduceOperateLogsRequest, callback func(response *ListUserProduceOperateLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserProduceOperateLogsResponse
		var err error
		defer close(result)
		response, err = client.ListUserProduceOperateLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserProduceOperateLogsRequest is the request struct for api ListUserProduceOperateLogs
type ListUserProduceOperateLogsRequest struct {
	*requests.RpcRequest
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	BizType  string           `position:"Query" name:"BizType"`
	BizId    string           `position:"Query" name:"BizId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// ListUserProduceOperateLogsResponse is the response struct for api ListUserProduceOperateLogs
type ListUserProduceOperateLogsResponse struct {
	*responses.BaseResponse
	PageNum      int         `json:"PageNum" xml:"PageNum"`
	RequestId    string      `json:"RequestId" xml:"RequestId"`
	Success      bool        `json:"Success" xml:"Success"`
	TotalItemNum int         `json:"TotalItemNum" xml:"TotalItemNum"`
	PageSize     int         `json:"PageSize" xml:"PageSize"`
	TotalPageNum int         `json:"TotalPageNum" xml:"TotalPageNum"`
	Data         []OpateLogs `json:"Data" xml:"Data"`
}

// CreateListUserProduceOperateLogsRequest creates a request to invoke ListUserProduceOperateLogs API
func CreateListUserProduceOperateLogsRequest() (request *ListUserProduceOperateLogsRequest) {
	request = &ListUserProduceOperateLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "ListUserProduceOperateLogs", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUserProduceOperateLogsResponse creates a response to parse from ListUserProduceOperateLogs response
func CreateListUserProduceOperateLogsResponse() (response *ListUserProduceOperateLogsResponse) {
	response = &ListUserProduceOperateLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
