package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataServicePublishedApi invokes the dataworks_public.GetDataServicePublishedApi API synchronously
func (client *Client) GetDataServicePublishedApi(request *GetDataServicePublishedApiRequest) (response *GetDataServicePublishedApiResponse, err error) {
	response = CreateGetDataServicePublishedApiResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataServicePublishedApiWithChan invokes the dataworks_public.GetDataServicePublishedApi API asynchronously
func (client *Client) GetDataServicePublishedApiWithChan(request *GetDataServicePublishedApiRequest) (<-chan *GetDataServicePublishedApiResponse, <-chan error) {
	responseChan := make(chan *GetDataServicePublishedApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataServicePublishedApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataServicePublishedApiWithCallback invokes the dataworks_public.GetDataServicePublishedApi API asynchronously
func (client *Client) GetDataServicePublishedApiWithCallback(request *GetDataServicePublishedApiRequest, callback func(response *GetDataServicePublishedApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataServicePublishedApiResponse
		var err error
		defer close(result)
		response, err = client.GetDataServicePublishedApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataServicePublishedApiRequest is the request struct for api GetDataServicePublishedApi
type GetDataServicePublishedApiRequest struct {
	*requests.RpcRequest
	TenantId  requests.Integer `position:"Body" name:"TenantId"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
	ApiId     requests.Integer `position:"Body" name:"ApiId"`
}

// GetDataServicePublishedApiResponse is the response struct for api GetDataServicePublishedApi
type GetDataServicePublishedApiResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string                           `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool                             `json:"Success" xml:"Success"`
	ErrorCode      string                           `json:"ErrorCode" xml:"ErrorCode"`
	Data           DataInGetDataServicePublishedApi `json:"Data" xml:"Data"`
}

// CreateGetDataServicePublishedApiRequest creates a request to invoke GetDataServicePublishedApi API
func CreateGetDataServicePublishedApiRequest() (request *GetDataServicePublishedApiRequest) {
	request = &GetDataServicePublishedApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDataServicePublishedApi", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDataServicePublishedApiResponse creates a response to parse from GetDataServicePublishedApi response
func CreateGetDataServicePublishedApiResponse() (response *GetDataServicePublishedApiResponse) {
	response = &GetDataServicePublishedApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
