package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMetaCollections invokes the dataworks_public.ListMetaCollections API synchronously
func (client *Client) ListMetaCollections(request *ListMetaCollectionsRequest) (response *ListMetaCollectionsResponse, err error) {
	response = CreateListMetaCollectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMetaCollectionsWithChan invokes the dataworks_public.ListMetaCollections API asynchronously
func (client *Client) ListMetaCollectionsWithChan(request *ListMetaCollectionsRequest) (<-chan *ListMetaCollectionsResponse, <-chan error) {
	responseChan := make(chan *ListMetaCollectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMetaCollections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMetaCollectionsWithCallback invokes the dataworks_public.ListMetaCollections API asynchronously
func (client *Client) ListMetaCollectionsWithCallback(request *ListMetaCollectionsRequest, callback func(response *ListMetaCollectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMetaCollectionsResponse
		var err error
		defer close(result)
		response, err = client.ListMetaCollections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMetaCollectionsRequest is the request struct for api ListMetaCollections
type ListMetaCollectionsRequest struct {
	*requests.RpcRequest
	Creator             string           `position:"Query" name:"Creator"`
	Follower            string           `position:"Query" name:"Follower"`
	ParentQualifiedName string           `position:"Query" name:"ParentQualifiedName"`
	OrderBy             string           `position:"Query" name:"OrderBy"`
	CollectionType      string           `position:"Query" name:"CollectionType"`
	Administrator       string           `position:"Query" name:"Administrator"`
	NextToken           string           `position:"Query" name:"NextToken"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
	Keyword             string           `position:"Query" name:"Keyword"`
}

// ListMetaCollectionsResponse is the response struct for api ListMetaCollections
type ListMetaCollectionsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateListMetaCollectionsRequest creates a request to invoke ListMetaCollections API
func CreateListMetaCollectionsRequest() (request *ListMetaCollectionsRequest) {
	request = &ListMetaCollectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListMetaCollections", "", "")
	request.Method = requests.POST
	return
}

// CreateListMetaCollectionsResponse creates a response to parse from ListMetaCollections response
func CreateListMetaCollectionsResponse() (response *ListMetaCollectionsResponse) {
	response = &ListMetaCollectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
