package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitializeDbsServiceLinkedRole invokes the dbs.InitializeDbsServiceLinkedRole API synchronously
func (client *Client) InitializeDbsServiceLinkedRole(request *InitializeDbsServiceLinkedRoleRequest) (response *InitializeDbsServiceLinkedRoleResponse, err error) {
	response = CreateInitializeDbsServiceLinkedRoleResponse()
	err = client.DoAction(request, response)
	return
}

// InitializeDbsServiceLinkedRoleWithChan invokes the dbs.InitializeDbsServiceLinkedRole API asynchronously
func (client *Client) InitializeDbsServiceLinkedRoleWithChan(request *InitializeDbsServiceLinkedRoleRequest) (<-chan *InitializeDbsServiceLinkedRoleResponse, <-chan error) {
	responseChan := make(chan *InitializeDbsServiceLinkedRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitializeDbsServiceLinkedRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitializeDbsServiceLinkedRoleWithCallback invokes the dbs.InitializeDbsServiceLinkedRole API asynchronously
func (client *Client) InitializeDbsServiceLinkedRoleWithCallback(request *InitializeDbsServiceLinkedRoleRequest, callback func(response *InitializeDbsServiceLinkedRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitializeDbsServiceLinkedRoleResponse
		var err error
		defer close(result)
		response, err = client.InitializeDbsServiceLinkedRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitializeDbsServiceLinkedRoleRequest is the request struct for api InitializeDbsServiceLinkedRole
type InitializeDbsServiceLinkedRoleRequest struct {
	*requests.RpcRequest
}

// InitializeDbsServiceLinkedRoleResponse is the response struct for api InitializeDbsServiceLinkedRole
type InitializeDbsServiceLinkedRoleResponse struct {
	*responses.BaseResponse
	Data       string `json:"Data" xml:"Data"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    string `json:"Success" xml:"Success"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateInitializeDbsServiceLinkedRoleRequest creates a request to invoke InitializeDbsServiceLinkedRole API
func CreateInitializeDbsServiceLinkedRoleRequest() (request *InitializeDbsServiceLinkedRoleRequest) {
	request = &InitializeDbsServiceLinkedRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "InitializeDbsServiceLinkedRole", "", "")
	request.Method = requests.POST
	return
}

// CreateInitializeDbsServiceLinkedRoleResponse creates a response to parse from InitializeDbsServiceLinkedRole response
func CreateInitializeDbsServiceLinkedRoleResponse() (response *InitializeDbsServiceLinkedRoleResponse) {
	response = &InitializeDbsServiceLinkedRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
