package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRDDomainConfig invokes the dcdn.DescribeRDDomainConfig API synchronously
func (client *Client) DescribeRDDomainConfig(request *DescribeRDDomainConfigRequest) (response *DescribeRDDomainConfigResponse, err error) {
	response = CreateDescribeRDDomainConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRDDomainConfigWithChan invokes the dcdn.DescribeRDDomainConfig API asynchronously
func (client *Client) DescribeRDDomainConfigWithChan(request *DescribeRDDomainConfigRequest) (<-chan *DescribeRDDomainConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeRDDomainConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRDDomainConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRDDomainConfigWithCallback invokes the dcdn.DescribeRDDomainConfig API asynchronously
func (client *Client) DescribeRDDomainConfigWithCallback(request *DescribeRDDomainConfigRequest, callback func(response *DescribeRDDomainConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRDDomainConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeRDDomainConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRDDomainConfigRequest is the request struct for api DescribeRDDomainConfig
type DescribeRDDomainConfigRequest struct {
	*requests.RpcRequest
	FunctionName string `position:"Query" name:"FunctionName"`
	DomainName   string `position:"Query" name:"DomainName"`
}

// DescribeRDDomainConfigResponse is the response struct for api DescribeRDDomainConfig
type DescribeRDDomainConfigResponse struct {
	*responses.BaseResponse
	RequestId     string                                 `json:"RequestId" xml:"RequestId"`
	DomainConfigs []DomainConfigInDescribeRDDomainConfig `json:"DomainConfigs" xml:"DomainConfigs"`
}

// CreateDescribeRDDomainConfigRequest creates a request to invoke DescribeRDDomainConfig API
func CreateDescribeRDDomainConfigRequest() (request *DescribeRDDomainConfigRequest) {
	request = &DescribeRDDomainConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeRDDomainConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRDDomainConfigResponse creates a response to parse from DescribeRDDomainConfig response
func CreateDescribeRDDomainConfigResponse() (response *DescribeRDDomainConfigResponse) {
	response = &DescribeRDDomainConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
