package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigUdpReflect invokes the ddoscoo.ConfigUdpReflect API synchronously
func (client *Client) ConfigUdpReflect(request *ConfigUdpReflectRequest) (response *ConfigUdpReflectResponse, err error) {
	response = CreateConfigUdpReflectResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigUdpReflectWithChan invokes the ddoscoo.ConfigUdpReflect API asynchronously
func (client *Client) ConfigUdpReflectWithChan(request *ConfigUdpReflectRequest) (<-chan *ConfigUdpReflectResponse, <-chan error) {
	responseChan := make(chan *ConfigUdpReflectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigUdpReflect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigUdpReflectWithCallback invokes the ddoscoo.ConfigUdpReflect API asynchronously
func (client *Client) ConfigUdpReflectWithCallback(request *ConfigUdpReflectRequest, callback func(response *ConfigUdpReflectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigUdpReflectResponse
		var err error
		defer close(result)
		response, err = client.ConfigUdpReflect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigUdpReflectRequest is the request struct for api ConfigUdpReflect
type ConfigUdpReflectRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Config     string `position:"Query" name:"Config"`
}

// ConfigUdpReflectResponse is the response struct for api ConfigUdpReflect
type ConfigUdpReflectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigUdpReflectRequest creates a request to invoke ConfigUdpReflect API
func CreateConfigUdpReflectRequest() (request *ConfigUdpReflectRequest) {
	request = &ConfigUdpReflectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ConfigUdpReflect", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigUdpReflectResponse creates a response to parse from ConfigUdpReflect response
func CreateConfigUdpReflectResponse() (response *ConfigUdpReflectResponse) {
	response = &ConfigUdpReflectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
