package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSlsLogstoreInfo invokes the ddoscoo.DescribeSlsLogstoreInfo API synchronously
func (client *Client) DescribeSlsLogstoreInfo(request *DescribeSlsLogstoreInfoRequest) (response *DescribeSlsLogstoreInfoResponse, err error) {
	response = CreateDescribeSlsLogstoreInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSlsLogstoreInfoWithChan invokes the ddoscoo.DescribeSlsLogstoreInfo API asynchronously
func (client *Client) DescribeSlsLogstoreInfoWithChan(request *DescribeSlsLogstoreInfoRequest) (<-chan *DescribeSlsLogstoreInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeSlsLogstoreInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSlsLogstoreInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSlsLogstoreInfoWithCallback invokes the ddoscoo.DescribeSlsLogstoreInfo API asynchronously
func (client *Client) DescribeSlsLogstoreInfoWithCallback(request *DescribeSlsLogstoreInfoRequest, callback func(response *DescribeSlsLogstoreInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSlsLogstoreInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeSlsLogstoreInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSlsLogstoreInfoRequest is the request struct for api DescribeSlsLogstoreInfo
type DescribeSlsLogstoreInfoRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Lang            string `position:"Query" name:"Lang"`
}

// DescribeSlsLogstoreInfoResponse is the response struct for api DescribeSlsLogstoreInfo
type DescribeSlsLogstoreInfoResponse struct {
	*responses.BaseResponse
	Ttl       int    `json:"Ttl" xml:"Ttl"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Quota     int64  `json:"Quota" xml:"Quota"`
	LogStore  string `json:"LogStore" xml:"LogStore"`
	Used      int64  `json:"Used" xml:"Used"`
	Project   string `json:"Project" xml:"Project"`
}

// CreateDescribeSlsLogstoreInfoRequest creates a request to invoke DescribeSlsLogstoreInfo API
func CreateDescribeSlsLogstoreInfoRequest() (request *DescribeSlsLogstoreInfoRequest) {
	request = &DescribeSlsLogstoreInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeSlsLogstoreInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSlsLogstoreInfoResponse creates a response to parse from DescribeSlsLogstoreInfo response
func CreateDescribeSlsLogstoreInfoResponse() (response *DescribeSlsLogstoreInfoResponse) {
	response = &DescribeSlsLogstoreInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
