package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebCacheMode invokes the ddoscoo.ModifyWebCacheMode API synchronously
func (client *Client) ModifyWebCacheMode(request *ModifyWebCacheModeRequest) (response *ModifyWebCacheModeResponse, err error) {
	response = CreateModifyWebCacheModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebCacheModeWithChan invokes the ddoscoo.ModifyWebCacheMode API asynchronously
func (client *Client) ModifyWebCacheModeWithChan(request *ModifyWebCacheModeRequest) (<-chan *ModifyWebCacheModeResponse, <-chan error) {
	responseChan := make(chan *ModifyWebCacheModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebCacheMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebCacheModeWithCallback invokes the ddoscoo.ModifyWebCacheMode API asynchronously
func (client *Client) ModifyWebCacheModeWithCallback(request *ModifyWebCacheModeRequest, callback func(response *ModifyWebCacheModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebCacheModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebCacheMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebCacheModeRequest is the request struct for api ModifyWebCacheMode
type ModifyWebCacheModeRequest struct {
	*requests.RpcRequest
	Mode            string `position:"Query" name:"Mode"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// ModifyWebCacheModeResponse is the response struct for api ModifyWebCacheMode
type ModifyWebCacheModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebCacheModeRequest creates a request to invoke ModifyWebCacheMode API
func CreateModifyWebCacheModeRequest() (request *ModifyWebCacheModeRequest) {
	request = &ModifyWebCacheModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebCacheMode", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyWebCacheModeResponse creates a response to parse from ModifyWebCacheMode response
func CreateModifyWebCacheModeResponse() (response *ModifyWebCacheModeResponse) {
	response = &ModifyWebCacheModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
