package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStandardGroups invokes the dms_enterprise.ListStandardGroups API synchronously
func (client *Client) ListStandardGroups(request *ListStandardGroupsRequest) (response *ListStandardGroupsResponse, err error) {
	response = CreateListStandardGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListStandardGroupsWithChan invokes the dms_enterprise.ListStandardGroups API asynchronously
func (client *Client) ListStandardGroupsWithChan(request *ListStandardGroupsRequest) (<-chan *ListStandardGroupsResponse, <-chan error) {
	responseChan := make(chan *ListStandardGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStandardGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStandardGroupsWithCallback invokes the dms_enterprise.ListStandardGroups API asynchronously
func (client *Client) ListStandardGroupsWithCallback(request *ListStandardGroupsRequest, callback func(response *ListStandardGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStandardGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListStandardGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStandardGroupsRequest is the request struct for api ListStandardGroups
type ListStandardGroupsRequest struct {
	*requests.RpcRequest
	Tid requests.Integer `position:"Query" name:"Tid"`
}

// ListStandardGroupsResponse is the response struct for api ListStandardGroups
type ListStandardGroupsResponse struct {
	*responses.BaseResponse
	RequestId         string                  `json:"RequestId" xml:"RequestId"`
	Success           bool                    `json:"Success" xml:"Success"`
	ErrorMessage      string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode         string                  `json:"ErrorCode" xml:"ErrorCode"`
	StandardGroupList []StandardGroupListItem `json:"StandardGroupList" xml:"StandardGroupList"`
}

// CreateListStandardGroupsRequest creates a request to invoke ListStandardGroups API
func CreateListStandardGroupsRequest() (request *ListStandardGroupsRequest) {
	request = &ListStandardGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListStandardGroups", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListStandardGroupsResponse creates a response to parse from ListStandardGroups response
func CreateListStandardGroupsResponse() (response *ListStandardGroupsResponse) {
	response = &ListStandardGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
