package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLocalEnsAssociation invokes the domain.QueryLocalEnsAssociation API synchronously
func (client *Client) QueryLocalEnsAssociation(request *QueryLocalEnsAssociationRequest) (response *QueryLocalEnsAssociationResponse, err error) {
	response = CreateQueryLocalEnsAssociationResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLocalEnsAssociationWithChan invokes the domain.QueryLocalEnsAssociation API asynchronously
func (client *Client) QueryLocalEnsAssociationWithChan(request *QueryLocalEnsAssociationRequest) (<-chan *QueryLocalEnsAssociationResponse, <-chan error) {
	responseChan := make(chan *QueryLocalEnsAssociationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLocalEnsAssociation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLocalEnsAssociationWithCallback invokes the domain.QueryLocalEnsAssociation API asynchronously
func (client *Client) QueryLocalEnsAssociationWithCallback(request *QueryLocalEnsAssociationRequest, callback func(response *QueryLocalEnsAssociationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLocalEnsAssociationResponse
		var err error
		defer close(result)
		response, err = client.QueryLocalEnsAssociation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLocalEnsAssociationRequest is the request struct for api QueryLocalEnsAssociation
type QueryLocalEnsAssociationRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// QueryLocalEnsAssociationResponse is the response struct for api QueryLocalEnsAssociation
type QueryLocalEnsAssociationResponse struct {
	*responses.BaseResponse
	Address   string `json:"Address" xml:"Address"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateQueryLocalEnsAssociationRequest creates a request to invoke QueryLocalEnsAssociation API
func CreateQueryLocalEnsAssociationRequest() (request *QueryLocalEnsAssociationRequest) {
	request = &QueryLocalEnsAssociationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "QueryLocalEnsAssociation", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryLocalEnsAssociationResponse creates a response to parse from QueryLocalEnsAssociation response
func CreateQueryLocalEnsAssociationResponse() (response *QueryLocalEnsAssociationResponse) {
	response = &QueryLocalEnsAssociationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
