package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterUsedUtilization invokes the dts.DescribeClusterUsedUtilization API synchronously
func (client *Client) DescribeClusterUsedUtilization(request *DescribeClusterUsedUtilizationRequest) (response *DescribeClusterUsedUtilizationResponse, err error) {
	response = CreateDescribeClusterUsedUtilizationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterUsedUtilizationWithChan invokes the dts.DescribeClusterUsedUtilization API asynchronously
func (client *Client) DescribeClusterUsedUtilizationWithChan(request *DescribeClusterUsedUtilizationRequest) (<-chan *DescribeClusterUsedUtilizationResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterUsedUtilizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterUsedUtilization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterUsedUtilizationWithCallback invokes the dts.DescribeClusterUsedUtilization API asynchronously
func (client *Client) DescribeClusterUsedUtilizationWithCallback(request *DescribeClusterUsedUtilizationRequest, callback func(response *DescribeClusterUsedUtilizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterUsedUtilizationResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterUsedUtilization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterUsedUtilizationRequest is the request struct for api DescribeClusterUsedUtilization
type DescribeClusterUsedUtilizationRequest struct {
	*requests.RpcRequest
	MetricType         string `position:"Body" name:"MetricType"`
	ClientToken        string `position:"Body" name:"ClientToken"`
	DedicatedClusterId string `position:"Body" name:"DedicatedClusterId"`
	Env                string `position:"Body" name:"Env"`
	OwnerID            string `position:"Body" name:"OwnerID"`
	AccountId          string `position:"Body" name:"AccountId"`
	SecurityToken      string `position:"Body" name:"SecurityToken"`
	DtsJobId           string `position:"Body" name:"DtsJobId"`
}

// DescribeClusterUsedUtilizationResponse is the response struct for api DescribeClusterUsedUtilization
type DescribeClusterUsedUtilizationResponse struct {
	*responses.BaseResponse
	DedicatedClusterId   string  `json:"DedicatedClusterId" xml:"DedicatedClusterId"`
	CpuTotal             float64 `json:"CpuTotal" xml:"CpuTotal"`
	MemoryUsed           float64 `json:"MemoryUsed" xml:"MemoryUsed"`
	MemoryTotal          float64 `json:"MemoryTotal" xml:"MemoryTotal"`
	DiskTotal            float64 `json:"DiskTotal" xml:"DiskTotal"`
	DiskUsed             float64 `json:"DiskUsed" xml:"DiskUsed"`
	DuTotal              int     `json:"DuTotal" xml:"DuTotal"`
	DuUsed               int     `json:"DuUsed" xml:"DuUsed"`
	TaskRunning          int     `json:"TaskRunning" xml:"TaskRunning"`
	Success              bool    `json:"Success" xml:"Success"`
	Code                 string  `json:"Code" xml:"Code"`
	ErrCode              string  `json:"ErrCode" xml:"ErrCode"`
	ErrMessage           string  `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage       string  `json:"DynamicMessage" xml:"DynamicMessage"`
	HttpStatusCode       int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId            string  `json:"RequestId" xml:"RequestId"`
	MemoryUsedPercentage float64 `json:"MemoryUsedPercentage" xml:"MemoryUsedPercentage"`
}

// CreateDescribeClusterUsedUtilizationRequest creates a request to invoke DescribeClusterUsedUtilization API
func CreateDescribeClusterUsedUtilizationRequest() (request *DescribeClusterUsedUtilizationRequest) {
	request = &DescribeClusterUsedUtilizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeClusterUsedUtilization", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterUsedUtilizationResponse creates a response to parse from DescribeClusterUsedUtilization response
func CreateDescribeClusterUsedUtilizationResponse() (response *DescribeClusterUsedUtilizationResponse) {
	response = &DescribeClusterUsedUtilizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
