package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ThreeElementsVerification invokes the dytnsapi.ThreeElementsVerification API synchronously
func (client *Client) ThreeElementsVerification(request *ThreeElementsVerificationRequest) (response *ThreeElementsVerificationResponse, err error) {
	response = CreateThreeElementsVerificationResponse()
	err = client.DoAction(request, response)
	return
}

// ThreeElementsVerificationWithChan invokes the dytnsapi.ThreeElementsVerification API asynchronously
func (client *Client) ThreeElementsVerificationWithChan(request *ThreeElementsVerificationRequest) (<-chan *ThreeElementsVerificationResponse, <-chan error) {
	responseChan := make(chan *ThreeElementsVerificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ThreeElementsVerification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ThreeElementsVerificationWithCallback invokes the dytnsapi.ThreeElementsVerification API asynchronously
func (client *Client) ThreeElementsVerificationWithCallback(request *ThreeElementsVerificationRequest, callback func(response *ThreeElementsVerificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ThreeElementsVerificationResponse
		var err error
		defer close(result)
		response, err = client.ThreeElementsVerification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ThreeElementsVerificationRequest is the request struct for api ThreeElementsVerification
type ThreeElementsVerificationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CertCode             string           `position:"Query" name:"CertCode"`
	RouteName            string           `position:"Query" name:"RouteName"`
	Mask                 string           `position:"Query" name:"Mask"`
	ResultCount          string           `position:"Query" name:"ResultCount"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
	Name                 string           `position:"Query" name:"Name"`
	FlowName             string           `position:"Query" name:"FlowName"`
}

// ThreeElementsVerificationResponse is the response struct for api ThreeElementsVerification
type ThreeElementsVerificationResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateThreeElementsVerificationRequest creates a request to invoke ThreeElementsVerification API
func CreateThreeElementsVerificationRequest() (request *ThreeElementsVerificationRequest) {
	request = &ThreeElementsVerificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "ThreeElementsVerification", "", "")
	request.Method = requests.POST
	return
}

// CreateThreeElementsVerificationResponse creates a response to parse from ThreeElementsVerification response
func CreateThreeElementsVerificationResponse() (response *ThreeElementsVerificationResponse) {
	response = &ThreeElementsVerificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
