package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEai invokes the eais.CreateEai API synchronously
func (client *Client) CreateEai(request *CreateEaiRequest) (response *CreateEaiResponse, err error) {
	response = CreateCreateEaiResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEaiWithChan invokes the eais.CreateEai API asynchronously
func (client *Client) CreateEaiWithChan(request *CreateEaiRequest) (<-chan *CreateEaiResponse, <-chan error) {
	responseChan := make(chan *CreateEaiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEai(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEaiWithCallback invokes the eais.CreateEai API asynchronously
func (client *Client) CreateEaiWithCallback(request *CreateEaiRequest, callback func(response *CreateEaiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEaiResponse
		var err error
		defer close(result)
		response, err = client.CreateEai(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEaiRequest is the request struct for api CreateEai
type CreateEaiRequest struct {
	*requests.RpcRequest
	ClientToken     string `position:"Query" name:"ClientToken"`
	SecurityGroupId string `position:"Query" name:"SecurityGroupId"`
	VSwitchId       string `position:"Query" name:"VSwitchId"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	InstanceName    string `position:"Query" name:"InstanceName"`
	InstanceType    string `position:"Query" name:"InstanceType"`
}

// CreateEaiResponse is the response struct for api CreateEai
type CreateEaiResponse struct {
	*responses.BaseResponse
	ElasticAcceleratedInstanceId string `json:"ElasticAcceleratedInstanceId" xml:"ElasticAcceleratedInstanceId"`
	RequestId                    string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateEaiRequest creates a request to invoke CreateEai API
func CreateCreateEaiRequest() (request *CreateEaiRequest) {
	request = &CreateEaiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "CreateEai", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEaiResponse creates a response to parse from CreateEai response
func CreateCreateEaiResponse() (response *CreateEaiResponse) {
	response = &CreateEaiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
