package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlarmEventStackInfo invokes the ecd.DescribeAlarmEventStackInfo API synchronously
func (client *Client) DescribeAlarmEventStackInfo(request *DescribeAlarmEventStackInfoRequest) (response *DescribeAlarmEventStackInfoResponse, err error) {
	response = CreateDescribeAlarmEventStackInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlarmEventStackInfoWithChan invokes the ecd.DescribeAlarmEventStackInfo API asynchronously
func (client *Client) DescribeAlarmEventStackInfoWithChan(request *DescribeAlarmEventStackInfoRequest) (<-chan *DescribeAlarmEventStackInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeAlarmEventStackInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlarmEventStackInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlarmEventStackInfoWithCallback invokes the ecd.DescribeAlarmEventStackInfo API asynchronously
func (client *Client) DescribeAlarmEventStackInfoWithCallback(request *DescribeAlarmEventStackInfoRequest, callback func(response *DescribeAlarmEventStackInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlarmEventStackInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlarmEventStackInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlarmEventStackInfoRequest is the request struct for api DescribeAlarmEventStackInfo
type DescribeAlarmEventStackInfoRequest struct {
	*requests.RpcRequest
	UniqueInfo string `position:"Query" name:"UniqueInfo"`
	EventName  string `position:"Query" name:"EventName"`
	DesktopId  string `position:"Query" name:"DesktopId"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeAlarmEventStackInfoResponse is the response struct for api DescribeAlarmEventStackInfo
type DescribeAlarmEventStackInfoResponse struct {
	*responses.BaseResponse
	StackInfo string `json:"StackInfo" xml:"StackInfo"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeAlarmEventStackInfoRequest creates a request to invoke DescribeAlarmEventStackInfo API
func CreateDescribeAlarmEventStackInfoRequest() (request *DescribeAlarmEventStackInfoRequest) {
	request = &DescribeAlarmEventStackInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeAlarmEventStackInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAlarmEventStackInfoResponse creates a response to parse from DescribeAlarmEventStackInfo response
func CreateDescribeAlarmEventStackInfoResponse() (response *DescribeAlarmEventStackInfoResponse) {
	response = &DescribeAlarmEventStackInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
