package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopGroups invokes the ecd.DescribeDesktopGroups API synchronously
func (client *Client) DescribeDesktopGroups(request *DescribeDesktopGroupsRequest) (response *DescribeDesktopGroupsResponse, err error) {
	response = CreateDescribeDesktopGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopGroupsWithChan invokes the ecd.DescribeDesktopGroups API asynchronously
func (client *Client) DescribeDesktopGroupsWithChan(request *DescribeDesktopGroupsRequest) (<-chan *DescribeDesktopGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopGroupsWithCallback invokes the ecd.DescribeDesktopGroups API asynchronously
func (client *Client) DescribeDesktopGroupsWithCallback(request *DescribeDesktopGroupsRequest, callback func(response *DescribeDesktopGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopGroupsRequest is the request struct for api DescribeDesktopGroups
type DescribeDesktopGroupsRequest struct {
	*requests.RpcRequest
	OfficeSiteId       string           `position:"Query" name:"OfficeSiteId"`
	EndUserIds         *[]string        `position:"Query" name:"EndUserIds"  type:"Repeated"`
	DesktopGroupName   string           `position:"Query" name:"DesktopGroupName"`
	DesktopGroupId     string           `position:"Query" name:"DesktopGroupId"`
	NextToken          string           `position:"Query" name:"NextToken"`
	Period             requests.Integer `position:"Query" name:"Period"`
	OwnType            requests.Integer `position:"Query" name:"OwnType"`
	ExcludedEndUserIds *[]string        `position:"Query" name:"ExcludedEndUserIds"  type:"Repeated"`
	PeriodUnit         string           `position:"Query" name:"PeriodUnit"`
	MaxResults         requests.Integer `position:"Query" name:"MaxResults"`
	PolicyGroupId      string           `position:"Query" name:"PolicyGroupId"`
	Status             requests.Integer `position:"Query" name:"Status"`
}

// DescribeDesktopGroupsResponse is the response struct for api DescribeDesktopGroups
type DescribeDesktopGroupsResponse struct {
	*responses.BaseResponse
	NextToken     string         `json:"NextToken" xml:"NextToken"`
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	DesktopGroups []DesktopGroup `json:"DesktopGroups" xml:"DesktopGroups"`
}

// CreateDescribeDesktopGroupsRequest creates a request to invoke DescribeDesktopGroups API
func CreateDescribeDesktopGroupsRequest() (request *DescribeDesktopGroupsRequest) {
	request = &DescribeDesktopGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopGroups", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopGroupsResponse creates a response to parse from DescribeDesktopGroups response
func CreateDescribeDesktopGroupsResponse() (response *DescribeDesktopGroupsResponse) {
	response = &DescribeDesktopGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
