package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDesktopsInGroup invokes the ecd.DisableDesktopsInGroup API synchronously
func (client *Client) DisableDesktopsInGroup(request *DisableDesktopsInGroupRequest) (response *DisableDesktopsInGroupResponse, err error) {
	response = CreateDisableDesktopsInGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDesktopsInGroupWithChan invokes the ecd.DisableDesktopsInGroup API asynchronously
func (client *Client) DisableDesktopsInGroupWithChan(request *DisableDesktopsInGroupRequest) (<-chan *DisableDesktopsInGroupResponse, <-chan error) {
	responseChan := make(chan *DisableDesktopsInGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDesktopsInGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDesktopsInGroupWithCallback invokes the ecd.DisableDesktopsInGroup API asynchronously
func (client *Client) DisableDesktopsInGroupWithCallback(request *DisableDesktopsInGroupRequest, callback func(response *DisableDesktopsInGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDesktopsInGroupResponse
		var err error
		defer close(result)
		response, err = client.DisableDesktopsInGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDesktopsInGroupRequest is the request struct for api DisableDesktopsInGroup
type DisableDesktopsInGroupRequest struct {
	*requests.RpcRequest
	DesktopIds     *[]string `position:"Query" name:"DesktopIds"  type:"Repeated"`
	DesktopGroupId string    `position:"Query" name:"DesktopGroupId"`
}

// DisableDesktopsInGroupResponse is the response struct for api DisableDesktopsInGroup
type DisableDesktopsInGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableDesktopsInGroupRequest creates a request to invoke DisableDesktopsInGroup API
func CreateDisableDesktopsInGroupRequest() (request *DisableDesktopsInGroupRequest) {
	request = &DisableDesktopsInGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DisableDesktopsInGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableDesktopsInGroupResponse creates a response to parse from DisableDesktopsInGroup response
func CreateDisableDesktopsInGroupResponse() (response *DisableDesktopsInGroupResponse) {
	response = &DisableDesktopsInGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
