package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserAdOrganizationUnits invokes the ecd.ListUserAdOrganizationUnits API synchronously
func (client *Client) ListUserAdOrganizationUnits(request *ListUserAdOrganizationUnitsRequest) (response *ListUserAdOrganizationUnitsResponse, err error) {
	response = CreateListUserAdOrganizationUnitsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserAdOrganizationUnitsWithChan invokes the ecd.ListUserAdOrganizationUnits API asynchronously
func (client *Client) ListUserAdOrganizationUnitsWithChan(request *ListUserAdOrganizationUnitsRequest) (<-chan *ListUserAdOrganizationUnitsResponse, <-chan error) {
	responseChan := make(chan *ListUserAdOrganizationUnitsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserAdOrganizationUnits(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserAdOrganizationUnitsWithCallback invokes the ecd.ListUserAdOrganizationUnits API asynchronously
func (client *Client) ListUserAdOrganizationUnitsWithCallback(request *ListUserAdOrganizationUnitsRequest, callback func(response *ListUserAdOrganizationUnitsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserAdOrganizationUnitsResponse
		var err error
		defer close(result)
		response, err = client.ListUserAdOrganizationUnits(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserAdOrganizationUnitsRequest is the request struct for api ListUserAdOrganizationUnits
type ListUserAdOrganizationUnitsRequest struct {
	*requests.RpcRequest
	OfficeSiteId string `position:"Query" name:"OfficeSiteId"`
}

// ListUserAdOrganizationUnitsResponse is the response struct for api ListUserAdOrganizationUnits
type ListUserAdOrganizationUnitsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	OUNames   []OuName `json:"OUNames" xml:"OUNames"`
}

// CreateListUserAdOrganizationUnitsRequest creates a request to invoke ListUserAdOrganizationUnits API
func CreateListUserAdOrganizationUnitsRequest() (request *ListUserAdOrganizationUnitsRequest) {
	request = &ListUserAdOrganizationUnitsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ListUserAdOrganizationUnits", "", "")
	request.Method = requests.POST
	return
}

// CreateListUserAdOrganizationUnitsResponse creates a response to parse from ListUserAdOrganizationUnits response
func CreateListUserAdOrganizationUnitsResponse() (response *ListUserAdOrganizationUnitsResponse) {
	response = &ListUserAdOrganizationUnitsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
