package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBundle invokes the ecd.ModifyBundle API synchronously
func (client *Client) ModifyBundle(request *ModifyBundleRequest) (response *ModifyBundleResponse, err error) {
	response = CreateModifyBundleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBundleWithChan invokes the ecd.ModifyBundle API asynchronously
func (client *Client) ModifyBundleWithChan(request *ModifyBundleRequest) (<-chan *ModifyBundleResponse, <-chan error) {
	responseChan := make(chan *ModifyBundleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBundle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBundleWithCallback invokes the ecd.ModifyBundle API asynchronously
func (client *Client) ModifyBundleWithCallback(request *ModifyBundleRequest, callback func(response *ModifyBundleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBundleResponse
		var err error
		defer close(result)
		response, err = client.ModifyBundle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBundleRequest is the request struct for api ModifyBundle
type ModifyBundleRequest struct {
	*requests.RpcRequest
	ImageId     string `position:"Query" name:"ImageId"`
	BundleId    string `position:"Query" name:"BundleId"`
	Description string `position:"Query" name:"Description"`
	Language    string `position:"Query" name:"Language"`
	BundleName  string `position:"Query" name:"BundleName"`
}

// ModifyBundleResponse is the response struct for api ModifyBundle
type ModifyBundleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyBundleRequest creates a request to invoke ModifyBundle API
func CreateModifyBundleRequest() (request *ModifyBundleRequest) {
	request = &ModifyBundleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyBundle", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyBundleResponse creates a response to parse from ModifyBundle response
func CreateModifyBundleResponse() (response *ModifyBundleResponse) {
	response = &ModifyBundleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
