package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiskSpec invokes the ecd.ModifyDiskSpec API synchronously
func (client *Client) ModifyDiskSpec(request *ModifyDiskSpecRequest) (response *ModifyDiskSpecResponse, err error) {
	response = CreateModifyDiskSpecResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiskSpecWithChan invokes the ecd.ModifyDiskSpec API asynchronously
func (client *Client) ModifyDiskSpecWithChan(request *ModifyDiskSpecRequest) (<-chan *ModifyDiskSpecResponse, <-chan error) {
	responseChan := make(chan *ModifyDiskSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiskSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiskSpecWithCallback invokes the ecd.ModifyDiskSpec API asynchronously
func (client *Client) ModifyDiskSpecWithCallback(request *ModifyDiskSpecRequest, callback func(response *ModifyDiskSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiskSpecResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiskSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiskSpecRequest is the request struct for api ModifyDiskSpec
type ModifyDiskSpecRequest struct {
	*requests.RpcRequest
	RootDiskPerformanceLevel string           `position:"Query" name:"RootDiskPerformanceLevel"`
	AutoPay                  requests.Boolean `position:"Query" name:"AutoPay"`
	UserDiskPerformanceLevel string           `position:"Query" name:"UserDiskPerformanceLevel"`
	PromotionId              string           `position:"Query" name:"PromotionId"`
	DesktopId                string           `position:"Query" name:"DesktopId"`
}

// ModifyDiskSpecResponse is the response struct for api ModifyDiskSpec
type ModifyDiskSpecResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDiskSpecRequest creates a request to invoke ModifyDiskSpec API
func CreateModifyDiskSpecRequest() (request *ModifyDiskSpecRequest) {
	request = &ModifyDiskSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDiskSpec", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDiskSpecResponse creates a response to parse from ModifyDiskSpec response
func CreateModifyDiskSpecResponse() (response *ModifyDiskSpecResponse) {
	response = &ModifyDiskSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
