package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebootDesktops invokes the ecd.RebootDesktops API synchronously
func (client *Client) RebootDesktops(request *RebootDesktopsRequest) (response *RebootDesktopsResponse, err error) {
	response = CreateRebootDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// RebootDesktopsWithChan invokes the ecd.RebootDesktops API asynchronously
func (client *Client) RebootDesktopsWithChan(request *RebootDesktopsRequest) (<-chan *RebootDesktopsResponse, <-chan error) {
	responseChan := make(chan *RebootDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebootDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebootDesktopsWithCallback invokes the ecd.RebootDesktops API asynchronously
func (client *Client) RebootDesktopsWithCallback(request *RebootDesktopsRequest, callback func(response *RebootDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebootDesktopsResponse
		var err error
		defer close(result)
		response, err = client.RebootDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebootDesktopsRequest is the request struct for api RebootDesktops
type RebootDesktopsRequest struct {
	*requests.RpcRequest
	DesktopId *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
}

// RebootDesktopsResponse is the response struct for api RebootDesktops
type RebootDesktopsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRebootDesktopsRequest creates a request to invoke RebootDesktops API
func CreateRebootDesktopsRequest() (request *RebootDesktopsRequest) {
	request = &RebootDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RebootDesktops", "", "")
	request.Method = requests.POST
	return
}

// CreateRebootDesktopsResponse creates a response to parse from RebootDesktops response
func CreateRebootDesktopsResponse() (response *RebootDesktopsResponse) {
	response = &RebootDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
